<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Get patient details if patient ID is provided
$pat_id = $_GET['pat_id'] ?? '';
$patient = null;
if ($pat_id) {
    $ret = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $patient = $res->fetch_object();
}

// Handle form submission
if (isset($_POST['add_bill'])) {
    $pat_id = $_POST['pat_id'];
    $bill_date = $_POST['bill_date'];
    $description = $_POST['description'];
    $amount = $_POST['amount'];
    $status = $_POST['status'];
    
    // Generate bill number
    $bill_number = 'BIL' . rand(10000, 99999);
    
    // Insert bill into database
    $query = "INSERT INTO his_bills (bill_number, pat_id, bill_date, description, amount, status) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sissss', $bill_number, $pat_id, $bill_date, $description, $amount, $status);
    
    if ($stmt->execute()) {
        $success = "Bill created successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Billing</a></li>
                                        <li class="breadcrumb-item active">Add Bill</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Create Patient Bill</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Bill Information</h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_id">Patient</label>
                                                    <select class="form-control" id="pat_id" name="pat_id" required>
                                                        <option value="">Select Patient</option>
                                                        <?php
                                                        $ret = "SELECT * FROM his_patients ORDER BY pat_fname";
                                                        $stmt = $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res = $stmt->get_result();
                                                        while ($pat = $res->fetch_object()) {
                                                            $selected = ($pat->pat_id == $pat_id) ? 'selected' : '';
                                                            echo "<option value='$pat->pat_id' $selected>$pat->pat_fname $pat->pat_lname ($pat->pat_number)</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="bill_date">Bill Date</label>
                                                    <input type="date" class="form-control" id="bill_date" name="bill_date" value="<?php echo date('Y-m-d'); ?>" required>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3" required placeholder="Enter bill description"></textarea>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="amount">Amount ($)</label>
                                                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" required placeholder="Enter amount">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" id="status" name="status" required>
                                                        <option value="Pending">Pending</option>
                                                        <option value="Paid">Paid</option>
                                                        <option value="Partial">Partial Payment</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <button type="submit" name="add_bill" class="btn btn-primary">Create Bill</button>
                                        <a href="view_patients.php" class="btn btn-secondary">Cancel</a>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>