<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Get patient details if patient ID is provided
$pat_id = $_GET['pat_id'] ?? '';
$patient = null;
if ($pat_id) {
    $ret = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $patient = $res->fetch_object();
}

// Get pending bills for the patient
$bills = [];
if ($pat_id) {
    $ret = "SELECT * FROM his_bills WHERE pat_id = ? AND status != 'Paid'";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($bill = $res->fetch_object()) {
        $bills[] = $bill;
    }
}

// Handle form submission
if (isset($_POST['add_payment'])) {
    $pat_id = $_POST['pat_id'];
    $bill_id = $_POST['bill_id'];
    $payment_date = $_POST['payment_date'];
    $amount = $_POST['amount'];
    $payment_method = $_POST['payment_method'];
    $notes = $_POST['notes'];
    
    // Generate payment reference
    $payment_ref = 'PAY' . rand(10000, 99999);
    
    // Insert payment into database
    $query = "INSERT INTO his_payments (payment_ref, pat_id, bill_id, payment_date, amount, payment_method, notes) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('siissss', $payment_ref, $pat_id, $bill_id, $payment_date, $amount, $payment_method, $notes);
    
    if ($stmt->execute()) {
        // Update bill status if full payment is made
        if ($_POST['payment_type'] == 'full') {
            $update_query = "UPDATE his_bills SET status = 'Paid' WHERE bill_id = ?";
            $update_stmt = $mysqli->prepare($update_query);
            $update_stmt->bind_param('i', $bill_id);
            $update_stmt->execute();
        } else {
            $update_query = "UPDATE his_bills SET status = 'Partial' WHERE bill_id = ?";
            $update_stmt = $mysqli->prepare($update_query);
            $update_stmt->bind_param('i', $bill_id);
            $update_stmt->execute();
        }
        
        $success = "Payment recorded successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Billing</a></li>
                                        <li class="breadcrumb-item active">Add Payment</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Record Payment</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Payment Information</h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_id">Patient</label>
                                                    <select class="form-control" id="pat_id" name="pat_id" required onchange="this.form.submit()">
                                                        <option value="">Select Patient</option>
                                                        <?php
                                                        $ret = "SELECT * FROM his_patients ORDER BY pat_fname";
                                                        $stmt = $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res = $stmt->get_result();
                                                        while ($pat = $res->fetch_object()) {
                                                            $selected = ($pat->pat_id == $pat_id) ? 'selected' : '';
                                                            echo "<option value='$pat->pat_id' $selected>$pat->pat_fname $pat->pat_lname ($pat->pat_number)</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="payment_date">Payment Date</label>
                                                    <input type="date" class="form-control" id="payment_date" name="payment_date" value="<?php echo date('Y-m-d'); ?>" required>
                                                </div>
                                            </div>
                                        </div>

                                        <?php if ($pat_id && count($bills) > 0) { ?>
                                        <div class="form-group">
                                            <label for="bill_id">Select Bill</label>
                                            <select class="form-control" id="bill_id" name="bill_id" required>
                                                <?php foreach ($bills as $bill) { ?>
                                                    <option value="<?php echo $bill->bill_id; ?>">
                                                        Bill #<?php echo $bill->bill_number; ?> - 
                                                        <?php echo $bill->description; ?> - 
                                                        $<?php echo $bill->amount; ?> (<?php echo $bill->status; ?>)
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="payment_type">Payment Type</label>
                                                    <select class="form-control" id="payment_type" name="payment_type" required>
                                                        <option value="full">Full Payment</option>
                                                        <option value="partial">Partial Payment</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="amount">Amount ($)</label>
                                                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" required placeholder="Enter payment amount">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="payment_method">Payment Method</label>
                                                    <select class="form-control" id="payment_method" name="payment_method" required>
                                                        <option value="Cash">Cash</option>
                                                        <option value="Credit Card">Credit Card</option>
                                                        <option value="Debit Card">Debit Card</option>
                                                        <option value="Bank Transfer">Bank Transfer</option>
                                                        <option value="Insurance">Insurance</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="notes">Notes</label>
                                            <textarea class="form-control" id="notes" name="notes" rows="2" placeholder="Any additional notes"></textarea>
                                        </div>

                                        <button type="submit" name="add_payment" class="btn btn-success">Record Payment</button>
                                        <?php } elseif ($pat_id) { ?>
                                            <div class="alert alert-info">No pending bills found for this patient.</div>
                                        <?php } ?>
                                        
                                        <a href="view_patients.php" class="btn btn-secondary">Cancel</a>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>