<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_bed'])) {
    $bed_number = $_POST['bed_number'];
    $bed_name = $_POST['bed_name'];
    $room_id = $_POST['room_id'];
    $bed_type = $_POST['bed_type'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_beds (bed_number, bed_name, room_id, bed_type, description, status) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssisss', $bed_number, $bed_name, $room_id, $bed_type, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Bed added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_bed'])) {
    $bed_id = $_POST['bed_id'];
    $bed_number = $_POST['bed_number'];
    $bed_name = $_POST['bed_name'];
    $room_id = $_POST['room_id'];
    $bed_type = $_POST['bed_type'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_beds SET bed_number = ?, bed_name = ?, room_id = ?, bed_type = ?, description = ?, status = ? WHERE bed_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssisssi', $bed_number, $bed_name, $room_id, $bed_type, $description, $status, $bed_id);
    
    if ($stmt->execute()) {
        $success = "Bed updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $bed_id = $_GET['delete'];
    $query = "DELETE FROM his_beds WHERE bed_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $bed_id);
    
    if ($stmt->execute()) {
        $success = "Bed deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all beds with room and ward information
$beds = [];
$ret = "SELECT b.*, r.room_number, r.room_name, w.ward_number, w.ward_name 
        FROM his_beds b 
        LEFT JOIN his_rooms r ON b.room_id = r.room_id 
        LEFT JOIN his_wards w ON r.ward_id = w.ward_id 
        ORDER BY b.bed_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($bed = $res->fetch_object()) {
    $beds[] = $bed;
}

// Get all rooms for dropdown
$rooms = [];
$ret = "SELECT r.*, w.ward_number, w.ward_name 
        FROM his_rooms r 
        LEFT JOIN his_wards w ON r.ward_id = w.ward_id 
        WHERE r.status = 'Active' ORDER BY r.room_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($room = $res->fetch_object()) {
    $rooms[] = $room;
}

// Get specific bed for editing
$edit_bed = null;
if (isset($_GET['edit'])) {
    $bed_id = $_GET['edit'];
    $ret = "SELECT * FROM his_beds WHERE bed_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $bed_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_bed = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Bed Management</a></li>
                                        <li class="breadcrumb-item active">Beds</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Beds</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_bed) ? 'Edit Bed' : 'Add New Bed'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_bed)) { ?>
                                            <input type="hidden" name="bed_id" value="<?php echo $edit_bed->bed_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="bed_number">Bed Number *</label>
                                                    <input type="text" class="form-control" id="bed_number" name="bed_number" value="<?php echo isset($edit_bed) ? $edit_bed->bed_number : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="bed_name">Bed Name *</label>
                                                    <input type="text" class="form-control" id="bed_name" name="bed_name" value="<?php echo isset($edit_bed) ? $edit_bed->bed_name : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="room_id">Room *</label>
                                                    <select class="form-control" id="room_id" name="room_id" required>
                                                        <option value="">Select Room</option>
                                                        <?php foreach ($rooms as $room) { ?>
                                                            <option value="<?php echo $room->room_id; ?>" <?php echo (isset($edit_bed) && $edit_bed->room_id == $room->room_id) ? 'selected' : ''; ?>>
                                                                <?php echo $room->room_number . ' - ' . $room->room_name . ' (' . $room->ward_number . ' - ' . $room->ward_name . ')'; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="bed_type">Bed Type</label>
                                                    <select class="form-control" id="bed_type" name="bed_type" required>
                                                        <option value="General" <?php echo (isset($edit_bed) && $edit_bed->bed_type == 'General') ? 'selected' : ''; ?>>General</option>
                                                        <option value="ICU" <?php echo (isset($edit_bed) && $edit_bed->bed_type == 'ICU') ? 'selected' : ''; ?>>ICU</option>
                                                        <option value="Emergency" <?php echo (isset($edit_bed) && $edit_bed->bed_type == 'Emergency') ? 'selected' : ''; ?>>Emergency</option>
                                                        <option value="Maternity" <?php echo (isset($edit_bed) && $edit_bed->bed_type == 'Maternity') ? 'selected' : ''; ?>>Maternity</option>
                                                        <option value="Pediatric" <?php echo (isset($edit_bed) && $edit_bed->bed_type == 'Pediatric') ? 'selected' : ''; ?>>Pediatric</option>
                                                        <option value="Other" <?php echo (isset($edit_bed) && $edit_bed->bed_type == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" id="status" name="status" required>
                                                        <option value="Available" <?php echo (isset($edit_bed) && $edit_bed->status == 'Available') ? 'selected' : ''; ?>>Available</option>
                                                        <option value="Occupied" <?php echo (isset($edit_bed) && $edit_bed->status == 'Occupied') ? 'selected' : ''; ?>>Occupied</option>
                                                        <option value="Maintenance" <?php echo (isset($edit_bed) && $edit_bed->status == 'Maintenance') ? 'selected' : ''; ?>>Maintenance</option>
                                                        <option value="Reserved" <?php echo (isset($edit_bed) && $edit_bed->status == 'Reserved') ? 'selected' : ''; ?>>Reserved</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo isset($edit_bed) ? $edit_bed->description : ''; ?></textarea>
                                        </div>
                                        <?php if(isset($edit_bed)) { ?>
                                            <button type="submit" name="update_bed" class="btn btn-primary">Update Bed</button>
                                            <a href="bedno.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_bed" class="btn btn-success">Add Bed</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Beds</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Bed Number</th>
                                                <th>Bed Name</th>
                                                <th>Room</th>
                                                <th>Ward</th>
                                                <th>Type</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($beds as $bed) { ?>
                                                <tr>
                                                    <td><?php echo $bed->bed_number; ?></td>
                                                    <td><?php echo $bed->bed_name; ?></td>
                                                    <td><?php echo $bed->room_number . ' - ' . $bed->room_name; ?></td>
                                                    <td><?php echo $bed->ward_number . ' - ' . $bed->ward_name; ?></td>
                                                    <td><?php echo $bed->bed_type; ?></td>
                                                    <td><?php echo $bed->description; ?></td>
                                                    <td><span class="badge badge-<?php echo $bed->status == 'Available' ? 'success' : ($bed->status == 'Occupied' ? 'warning' : ($bed->status == 'Maintenance' ? 'danger' : 'info')); ?>"><?php echo $bed->status; ?></span></td>
                                                    <td>
                                                        <a href="bedno.php?edit=<?php echo $bed->bed_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="bedno.php?delete=<?php echo $bed->bed_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this bed?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>