<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_dept'])) {
    $dept_type_id = $_POST['dept_type_id'];
    $dept_name = $_POST['dept_name'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_department_master (dept_type_id, dept_name, description, status) VALUES (?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('isss', $dept_type_id, $dept_name, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Department added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_dept'])) {
    $dept_id = $_POST['dept_id'];
    $dept_type_id = $_POST['dept_type_id'];
    $dept_name = $_POST['dept_name'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_department_master SET dept_type_id = ?, dept_name = ?, description = ?, status = ? WHERE dept_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('isssi', $dept_type_id, $dept_name, $description, $status, $dept_id);
    
    if ($stmt->execute()) {
        $success = "Department updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $dept_id = $_GET['delete'];
    $query = "DELETE FROM his_department_master WHERE dept_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $dept_id);
    
    if ($stmt->execute()) {
        $success = "Department deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all departments with type information
$departments = [];
$ret = "SELECT d.*, dt.dept_type_name 
        FROM his_department_master d 
        LEFT JOIN his_department_types dt ON d.dept_type_id = dt.dept_type_id 
        ORDER BY d.dept_name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($dept = $res->fetch_object()) {
    $departments[] = $dept;
}

// Get all department types for dropdown
$dept_types = [];
$ret = "SELECT * FROM his_department_types WHERE status = 'Active' ORDER BY dept_type_name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($dept_type = $res->fetch_object()) {
    $dept_types[] = $dept_type;
}

// Get specific department for editing
$edit_dept = null;
if (isset($_GET['edit'])) {
    $dept_id = $_GET['edit'];
    $ret = "SELECT * FROM his_department_master WHERE dept_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $dept_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_dept = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
          <div class="form-section">
    <h5>Add New Department</h5>
    <form action="update_settings.php" method="post">
        <input type="hidden" name="setting_type" value="department_add">
        
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="department_name">Department Name</label>
                <input type="text" class="form-control" id="department_name" name="department_name" required>
            </div>
            
            <div class="form-group col-md-6">
                <label for="department_type">Department Type</label>
                <select class="form-control" id="department_type" name="department_type" required>
                    <option value="OutPatient">OPD</option>
                    <option value="InPatient">IPD</option>
                 
                                                        <?php foreach ($dept_types as $dept_type) { ?>
                                                            <option value="<?php echo $dept_type->dept_type_name; ?>" <?php echo (isset($edit_dept) && $edit_dept->dept_type_name == $dept_type->dept_type_name) ? 'selected' : ''; ?>>
                                                                <?php echo $dept_type->dept_type_name; ?>
                                                            </option>
                                                        <?php } ?>
                </select>
            </div>
        </div>
        
       <!--  <div class="form-row">
            <div class="form-group col-md-4">
                <label for="opd_fee">OPD Fee (if applicable)</label>
                <input type="number" step="0.01" class="form-control" id="opd_fee" name="opd_fee" value="0.00">
            </div>
            
            <div class="form-group col-md-4">
                <label for="ipd_fee">IPD Fee (if applicable)</label>
                <input type="number" step="0.01" class="form-control" id="ipd_fee" name="ipd_fee" value="0.00">
            </div>
            
            <div class="form-group col-md-4">
                <label for="ailment_name">Common Ailment</label>
                <input type="text" class="form-control" id="ailment_name" name="ailment_name">
            </div>
        </div> -->
        
        <div class="form-group">
            <label for="department_description">Description</label>
            <textarea class="form-control" id="department_description" name="department_description" rows="3"></textarea>
        </div>
        
        <button type="submit" class="btn btn-primary">Add Department</button>
    </form>
</div>

<div class="form-section">
    <h5>Manage Departments</h5>
    <div class="table-responsive">
        <table id="departments-table" class="table table-bordered mb-0" style="width:100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Department Name</th>
                    <th>Type</th>
                   <!--  <th>OPD Fee</th>
                    <th>IPD Fee</th>
                    <th>Common Ailment</th> -->
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $ret = "SELECT * FROM his_departments ORDER BY department_name";
                $stmt = $mysqli->prepare($ret);
                $stmt->execute();
                $res = $stmt->get_result();
                $cnt = 1;
                while($row = $res->fetch_object()):
                ?>
                <tr>
                    <td><?php echo $cnt; ?></td>
                    <td><?php echo htmlspecialchars($row->department_name); ?></td>
                    <td><?php echo htmlspecialchars($row->department_type); ?></td>
                   <!--  <td><//?php echo number_format($row->opd_fee, 2); ?></td>
                    <td><//?php echo number_format($row->ipd_fee, 2); ?></td>
                    <td><//?php echo htmlspecialchars($row->ailment_name); ?></td> -->
                    <td>
                        <div class="d-flex" style="gap: 5px;">
                            <a href="edit_department.php?id=<?php echo $row->department_id; ?>" class="badge badge-primary">
                                <i class="fas fa-edit mr-1"></i> Edit
                            </a>
                            <a href="update_settings.php?action=delete_department&id=<?php echo $row->department_id; ?>" 
                               class="badge badge-danger" onclick="return confirm('Are you sure you want to delete this department?');">
                                <i class="fas fa-trash-alt mr-1"></i> Delete
                            </a>
                        </div>
                    </td>
                </tr>
                <?php $cnt++; endwhile; ?>
            </tbody>
        </table>
    </div>
</div>
            
        </div>
    </div>
<?php include('assets/inc/footer.php');?>
    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>