<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_dept_type'])) {
    $dept_type_name = $_POST['dept_type_name'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_department_types (dept_type_name, description, status) VALUES (?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sss', $dept_type_name, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Department type added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_dept_type'])) {
    $dept_type_id = $_POST['dept_type_id'];
    $dept_type_name = $_POST['dept_type_name'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_department_types SET dept_type_name = ?, description = ?, status = ? WHERE dept_type_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssi', $dept_type_name, $description, $status, $dept_type_id);
    
    if ($stmt->execute()) {
        $success = "Department type updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $dept_type_id = $_GET['delete'];
    $query = "DELETE FROM his_department_types WHERE dept_type_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $dept_type_id);
    
    if ($stmt->execute()) {
        $success = "Department type deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all department types
$dept_types = [];
$ret = "SELECT * FROM his_department_types ORDER BY dept_type_name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($dept_type = $res->fetch_object()) {
    $dept_types[] = $dept_type;
}

// Get specific department type for editing
$edit_dept_type = null;
if (isset($_GET['edit'])) {
    $dept_type_id = $_GET['edit'];
    $ret = "SELECT * FROM his_department_types WHERE dept_type_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $dept_type_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_dept_type = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Department Management</a></li>
                                        <li class="breadcrumb-item active">Department Types</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Department Types</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_dept_type) ? 'Edit Department Type' : 'Add New Department Type'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_dept_type)) { ?>
                                            <input type="hidden" name="dept_type_id" value="<?php echo $edit_dept_type->dept_type_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="dept_type_name">Department Type Name *</label>
                                                    <input type="text" class="form-control" id="dept_type_name" name="dept_type_name" value="<?php echo isset($edit_dept_type) ? $edit_dept_type->dept_type_name : ''; ?>" required>
                                                </div>
                                            </div>
                                          <div class="col-md-6">
    <div class="form-group">
        <label>Status</label>
        <div class="radio">
            <input type="radio" id="status_active" name="status" value="Active" 
                <?php echo (isset($edit_dept_type) && $edit_dept_type->status == 'Active') ? 'checked' : ''; ?> required>
            <label for="status_active">Active</label>
        </div>
        <div class="radio">
            <input type="radio" id="status_inactive" name="status" value="Inactive"
                <?php echo (isset($edit_dept_type) && $edit_dept_type->status == 'Inactive') ? 'checked' : ''; ?>>
            <label for="status_inactive">Inactive</label>
        </div>
    </div>
</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo isset($edit_dept_type) ? $edit_dept_type->description : ''; ?></textarea>
                                        </div>
                                        <?php if(isset($edit_dept_type)) { ?>
                                            <button type="submit" name="update_dept_type" class="btn btn-primary">Update Department Type</button>
                                            <a href="dept_types.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_dept_type" class="btn btn-success">Add Department Type</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Department Types</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Department Type Name</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($dept_types as $dept_type) { ?>
                                                <tr>
                                                    <td><?php echo $dept_type->dept_type_name; ?></td>
                                                    <td><?php echo $dept_type->description; ?></td>
                                                    <td><span class="badge badge-<?php echo $dept_type->status == 'Active' ? 'success' : 'danger'; ?>"><?php echo $dept_type->status; ?></span></td>
                                                    <td>
                                                        <a href="dept_types.php?edit=<?php echo $dept_type->dept_type_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="dept_types.php?delete=<?php echo $dept_type->dept_type_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this department type?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>