<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_discharge_type'])) {
    $discharge_type_name = $_POST['discharge_type_name'];
    $discharge_type_notes = $_POST['discharge_type_notes'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_discharge_types (discharge_type_name, discharge_type_notes, status) VALUES (?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sss', $discharge_type_name, $discharge_type_notes, $status);
    
    if ($stmt->execute()) {
        $success = "Discharge type added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_discharge_type'])) {
    $discharge_type_id = $_POST['discharge_type_id'];
    $discharge_type_name = $_POST['discharge_type_name'];
    $discharge_type_notes = $_POST['discharge_type_notes'];
    $status = $_POST['status'];

    $query = "UPDATE his_discharge_types SET discharge_type_name = ?, discharge_type_notes = ?, status = ? WHERE discharge_type_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssi', $discharge_type_name, $discharge_type_notes, $status, $discharge_type_id);
    
    if ($stmt->execute()) {
        $success = "Discharge type updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $discharge_type_id = $_GET['delete'];
    $query = "DELETE FROM his_discharge_types WHERE discharge_type_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $discharge_type_id);
    
    if ($stmt->execute()) {
        $success = "Discharge type deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all discharge types
$discharge_types = [];
$ret = "SELECT * FROM his_discharge_types ORDER BY discharge_type_name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($discharge_type = $res->fetch_object()) {
    $discharge_types[] = $discharge_type;
}

// Get specific discharge type for editing
$edit_discharge_type = null;
if (isset($_GET['edit'])) {
    $discharge_type_id = $_GET['edit'];
    $ret = "SELECT * FROM his_discharge_types WHERE discharge_type_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $discharge_type_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_discharge_type = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Patient Management</a></li>
                                        <li class="breadcrumb-item active">Discharge Types</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Discharge Types</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_discharge_type) ? 'Edit Discharge Type' : 'Add New Discharge Type'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_discharge_type)) { ?>
                                            <input type="hidden" name="discharge_type_id" value="<?php echo $edit_discharge_type->discharge_type_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="discharge_type_name">Discharge Type Name *</label>
                                                    <input type="text" class="form-control" id="discharge_type_name" name="discharge_type_name" value="<?php echo isset($edit_discharge_type) ? $edit_discharge_type->discharge_type_name : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Status</label><br>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="status" id="status_active" value="Active" <?php echo (!isset($edit_discharge_type) || (isset($edit_discharge_type) && $edit_discharge_type->status == 'Active')) ? 'checked' : ''; ?> required>
                                                        <label class="form-check-label" for="status_active">Active</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="status" id="status_inactive" value="Inactive" <?php echo (isset($edit_discharge_type) && $edit_discharge_type->status == 'Inactive') ? 'checked' : ''; ?>>
                                                        <label class="form-check-label" for="status_inactive">Inactive</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="discharge_type_notes">Discharge Notes</label>
                                            <textarea class="form-control" id="discharge_type_notes" name="discharge_type_notes" rows="5"><?php echo isset($edit_discharge_type) ? $edit_discharge_type->discharge_type_notes : ''; ?></textarea>
                                        </div>
                                        <?php if(isset($edit_discharge_type)) { ?>
                                            <button type="submit" name="update_discharge_type" class="btn btn-primary">Update Discharge Type</button>
                                            <a href="discharge-types.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_discharge_type" class="btn btn-success">Add Discharge Type</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Discharge Types</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>Notes</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($discharge_types as $discharge_type) { ?>
                                                <tr>
                                                    <td><?php echo $discharge_type->discharge_type_name; ?></td>
                                                    <td><?php echo strlen($discharge_type->discharge_type_notes) > 100 ? substr($discharge_type->discharge_type_notes, 0, 100) . '...' : $discharge_type->discharge_type_notes; ?></td>
                                                    <td><span class="badge badge-<?php echo $discharge_type->status == 'Active' ? 'success' : 'danger'; ?>"><?php echo $discharge_type->status; ?></span></td>
                                                    <td>
                                                        <a href="discharge-types.php?edit=<?php echo $discharge_type->discharge_type_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="discharge-types.php?delete=<?php echo $discharge_type->discharge_type_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this discharge type?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- CKEditor CDN -->
  <script src="https://cdn.ckeditor.com/4.24.0/full/ckeditor.js"></script>

<script>
CKEDITOR.replace('discharge_type_notes', {
    toolbar: [
        { name: 'document', items: ['Source', '-', 'Save', 'NewPage', 'ExportPdf', 'Preview', 'Print', '-', 'Templates'] },
        { name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'] },
        { name: 'editing', items: ['Find', 'Replace', '-', 'SelectAll', '-', 'Scayt'] },
        { name: 'forms', items: ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField'] },
        '/',
        { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'CopyFormatting', 'RemoveFormat'] },
        { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl'] },
        { name: 'links', items: ['Link', 'Unlink', 'Anchor'] },
        { name: 'insert', items: ['Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe'] },
        '/',
        { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize'] },
        { name: 'colors', items: ['TextColor', 'BGColor'] },
        { name: 'tools', items: ['Maximize', 'ShowBlocks'] },
        { name: 'about', items: ['About'] }
    ],
    height: 300
});
</script>

</body>
</html>