<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

$id = intval($_GET['id']);

// Fetch department data
$query = "SELECT * FROM his_departments WHERE department_id = ?";
$stmt = $mysqli->prepare($query);
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$department = $res->fetch_object();

if (!$department) {
    $_SESSION['error'] = "Department not found";
    header("Location: settings.php#departments");
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $department_name = $_POST['department_name'];
    $department_type = $_POST['department_type'];
    $opd_fee = $_POST['opd_fee'];
    $ipd_fee = $_POST['ipd_fee'];
    $department_description = $_POST['department_description'];
    $ailment_name = $_POST['ailment_name'];
    
    $query = "UPDATE his_departments SET 
              department_name = ?, 
              department_type = ?, 
              opd_fee = ?, 
              ipd_fee = ?, 
              department_description = ?, 
              ailment_name = ? 
              WHERE department_id = ?";
    
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssddssi', 
        $department_name, $department_type, $opd_fee, $ipd_fee, 
        $department_description, $ailment_name, $id);
    $stmt->execute();
    
    $_SESSION['success'] = "Department updated successfully";
    header("Location: settings.php#departments");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

    <?php include('assets/inc/head.php');?>
  
<body>
       <div id="wrapper">
    <?php include('assets/inc/nav.php');?>
    <?php include("assets/inc/sidebar.php");?>

    <div class="content-page">
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Edit Department</h4>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <form action="edit_department.php?id=<?php echo $id; ?>" method="post">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="department_name">Department Name</label>
                                        <input type="text" class="form-control" id="department_name" name="department_name" 
                                               value="<?php echo htmlspecialchars($department->department_name); ?>" required>
                                    </div>
                                    
                                    <div class="form-group col-md-6">
                                        <label for="department_type">Department Type</label>
                                        <select class="form-control" id="department_type" name="department_type" required>
                                            <option value="OutPatient" <?php echo $department->department_type == 'OutPatient' ? 'selected' : ''; ?>>OPD</option>
                                            <option value="InPatient" <?php echo $department->department_type == 'InPatient' ? 'selected' : ''; ?>>IPD</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <label for="opd_fee">OPD Fee (if applicable)</label>
                                        <input type="number" step="0.01" class="form-control" id="opd_fee" name="opd_fee" 
                                               value="<?php echo htmlspecialchars($department->opd_fee); ?>">
                                    </div>
                                    
                                    <div class="form-group col-md-4">
                                        <label for="ipd_fee">IPD Fee (if applicable)</label>
                                        <input type="number" step="0.01" class="form-control" id="ipd_fee" name="ipd_fee" 
                                               value="<?php echo htmlspecialchars($department->ipd_fee); ?>">
                                    </div>
                                    
                                    <div class="form-group col-md-4">
                                        <label for="ailment_name">Common Ailment</label>
                                        <input type="text" class="form-control" id="ailment_name" name="ailment_name" 
                                               value="<?php echo htmlspecialchars($department->ailment_name); ?>">
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="department_description">Description</label>
                                    <textarea class="form-control" id="department_description" name="department_description" rows="3"><?php echo htmlspecialchars($department->department_description); ?></textarea>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Update Department</button>
                                <a href="settings.php#departments" class="btn btn-secondary">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div>
            </div></div>
        </div>
        <?php include('assets/inc/footer.php');?>
    </div>

    <?php include('assets/inc/footer-scripts.php');?>
</body>
</html>