<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Modern Background */
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4f0fb 100%);
            background-attachment: fixed;
            min-height: 100vh;
        }
        
        /* Content Wrapper */
        .content-page {
            background: rgba(255, 255, 255, 0.9);
            margin-left: 260px;
            min-height: 100vh;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
        }
        
        /* Custom CSS */
        .card-box {
            border-radius: 12px;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.05);
            padding: 25px;
            background: white;
            border: none;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .card-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }
        
        .table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
            background: white;
        }
        
        .table th {
            background-color: #4a8bfc;
            color: white;
            font-weight: 600;
            border: none;
            padding: 15px;
        }
        
        .table td {
            padding: 12px 15px;
            vertical-align: middle;
            border-bottom: 1px solid #f1f5fd;
            background: white;
        }
        
        .table tbody tr:hover {
            background-color: #f8faff;
        }
        
        .badge-success {
            background-color: #4a8bfc;
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 500;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            color: white;
            border: none;
        }
        
        .badge-success:hover {
            background-color: #3a7be4;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(74, 139, 252, 0.3);
            text-decoration: none;
        }
        
        .badge-success i {
            margin-right: 5px;
            font-size: 14px;
        }
        
        .page-title {
            color: #2c3e50;
            font-weight: 700;
            position: relative;
            display: inline-block;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 50px;
            height: 3px;
            background: #4a8bfc;
            border-radius: 3px;
        }
        
        .search-box {
            position: relative;
            margin-bottom: 20px;
        }
        
        .search-box .form-control {
            padding-left: 45px;
            border-radius: 25px;
            border: 1px solid #e0e6f5;
            height: 40px;
            box-shadow: none;
            transition: all 0.3s;
        }
        
        .search-box .form-control:focus {
            border-color: #4a8bfc;
            box-shadow: 0 0 0 0.2rem rgba(74, 139, 252, 0.25);
        }
        
        .search-box i {
            position: absolute;
            left: 15px;
            top: 11px;
            color: #7e98c7;
            z-index: 4;
        }
        
        .pagination-rounded .page-item.active .page-link {
            background-color: #4a8bfc;
            border-color: #4a8bfc;
        }
        
        .pagination-rounded .page-link {
            color: #4a8bfc;
            border-radius: 50% !important;
            margin: 0 3px;
            width: 36px;
            height: 36px;
            text-align: center;
            line-height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 1px solid #e0e6f5;
        }
        
        .header-title {
            color: #2c3e50;
            margin-bottom: 1.5rem;
            font-weight: 600;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: #4a8bfc;
            border-radius: 3px;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .content-page {
                margin-left: 0;
            }
            
            .table-responsive {
                border: 0;
            }
            
            .table thead {
                display: none;
            }
            
            .table tr {
                display: block;
                margin-bottom: 20px;
                border: 1px solid #e0e6f5;
                border-radius: 8px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            }
            
            .table td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                border-bottom: 1px solid #f1f5fd;
            }
            
            .table td:before {
                content: attr(data-label);
                font-weight: 600;
                margin-right: 15px;
                color: #4a8bfc;
            }
        }
    </style>
    <!-- FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                        <li class="breadcrumb-item active">Employee Vitals</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Vitals</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <h4 class="header-title mb-3">Employee List</h4>
                                
                                <!-- Search Box -->
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="search-box">
                                            <i class="fas fa-search"></i>
                                            <input id="demo-foo-search" type="text" placeholder="Search employees..." 
                                                   class="form-control form-control-sm" autocomplete="on">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-hover table-centered mb-0" data-page-size="7">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Name</th>
                                                <th data-hide="phone">Employee Number</th>
                                                <th data-hide="phone">Email</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $ret = "SELECT * FROM his_docs ORDER BY RAND()";
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()):
                                            ?>
                                            <tr>
                                                <td><?php echo $cnt; ?></td>
                                                <td><?php echo htmlspecialchars($row->doc_fname) . ' ' . htmlspecialchars($row->doc_lname); ?></td>
                                                <td><?php echo htmlspecialchars($row->doc_number); ?></td>
                                                <td><?php echo htmlspecialchars($row->doc_email); ?></td>
                                                <td>
                                                    <a href="add_single_employee_vitals.php?doc_number=<?php echo $row->doc_number; ?>" 
                                                       class="badge badge-success">
                                                       <i class="fas fa-heartbeat"></i> Capture Vitals
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php 
                                            $cnt++;
                                            endwhile; 
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="5">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>