<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Define expense categories
$categories = array('Medical Supplies', 'Medications', 'Equipment', 'Staff Salaries', 'Utilities', 'Maintenance', 'Administration', 'Other');

// Handle form submissions
if (isset($_POST['add_expense'])) {
    $expense_date = $_POST['expense_date'];
    $expense_category = $_POST['expense_category'];
    $expense_description = $_POST['expense_description'];
    $expense_amount = $_POST['expense_amount'];
    $payment_method = $_POST['payment_method'];
    $vendor_name = $_POST['vendor_name'];
    $vendor_contact = $_POST['vendor_contact'];
    $status = $_POST['status'];
    
    // Handle receipt upload
    $receipt_file = '';
    if (isset($_FILES['receipt_file']) && $_FILES['receipt_file']['error'] == 0) {
        $target_dir = "assets/uploads/expenses/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_extension = pathinfo($_FILES["receipt_file"]["name"], PATHINFO_EXTENSION);
        $receipt_file = uniqid() . '.' . $file_extension;
        $target_file = $target_dir . $receipt_file;
        
        move_uploaded_file($_FILES["receipt_file"]["tmp_name"], $target_file);
    }
    
    $query = "INSERT INTO his_expenses (expense_date, category, description, amount, payment_method, vendor_name, vendor_contact, status, receipt_file, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssdsssssi', $expense_date, $expense_category, $expense_description, $expense_amount, $payment_method, $vendor_name, $vendor_contact, $status, $receipt_file, $aid);
    
    if ($stmt->execute()) {
        $success = "Expense added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_expense'])) {
    $expense_id = $_POST['expense_id'];
    $expense_date = $_POST['expense_date'];
    $expense_category = $_POST['expense_category'];
    $expense_description = $_POST['expense_description'];
    $expense_amount = $_POST['expense_amount'];
    $payment_method = $_POST['payment_method'];
    $vendor_name = $_POST['vendor_name'];
    $vendor_contact = $_POST['vendor_contact'];
    $status = $_POST['status'];
    
    // Handle receipt upload
    $receipt_update = '';
    $receipt_file = '';
    if (isset($_FILES['receipt_file']) && $_FILES['receipt_file']['error'] == 0) {
        $target_dir = "assets/uploads/expenses/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_extension = pathinfo($_FILES["receipt_file"]["name"], PATHINFO_EXTENSION);
        $receipt_file = uniqid() . '.' . $file_extension;
        $target_file = $target_dir . $receipt_file;
        
        move_uploaded_file($_FILES["receipt_file"]["tmp_name"], $target_file);
        $receipt_update = ", receipt_file = ?";
        
        // Delete old receipt file if exists
        $ret = "SELECT receipt_file FROM his_expenses WHERE expense_id = ?";
        $stmt = $mysqli->prepare($ret);
        $stmt->bind_param('i', $expense_id);
        $stmt->execute();
        $res = $stmt->get_result();
        $old_expense = $res->fetch_object();
        
        if ($old_expense && !empty($old_expense->receipt_file) && file_exists("assets/uploads/expenses/" . $old_expense->receipt_file)) {
            unlink("assets/uploads/expenses/" . $old_expense->receipt_file);
        }
    }
    
    // Build dynamic query
    if (!empty($receipt_update)) {
        $query = "UPDATE his_expenses SET expense_date = ?, category = ?, description = ?, amount = ?, payment_method = ?, vendor_name = ?, vendor_contact = ?, status = ? $receipt_update WHERE expense_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('sssdsssssi', $expense_date, $expense_category, $expense_description, $expense_amount, $payment_method, $vendor_name, $vendor_contact, $status, $receipt_file, $expense_id);
    } else {
        $query = "UPDATE his_expenses SET expense_date = ?, category = ?, description = ?, amount = ?, payment_method = ?, vendor_name = ?, vendor_contact = ?, status = ? WHERE expense_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('sssdssssi', $expense_date, $expense_category, $expense_description, $expense_amount, $payment_method, $vendor_name, $vendor_contact, $status, $expense_id);
    }
    
    if ($stmt->execute()) {
        $success = "Expense updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $expense_id = $_GET['delete'];
    
    // First get the receipt file to delete it
    $ret = "SELECT receipt_file FROM his_expenses WHERE expense_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $expense_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $expense = $res->fetch_object();
    
    // Delete the receipt file if it exists
    if ($expense && !empty($expense->receipt_file) && file_exists("assets/uploads/expenses/" . $expense->receipt_file)) {
        unlink("assets/uploads/expenses/" . $expense->receipt_file);
    }
    
    $query = "DELETE FROM his_expenses WHERE expense_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $expense_id);
    
    if ($stmt->execute()) {
        $success = "Expense deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all expenses
$expenses = [];
$ret = "SELECT e.*, a.ad_fname, a.ad_lname 
        FROM his_expenses e 
        LEFT JOIN his_admin a ON e.created_by = a.ad_id 
        ORDER BY e.expense_date DESC";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($expense = $res->fetch_object()) {
    $expenses[] = $expense;
}

// Get expense summary by category
$expense_summary = [];
$ret = "SELECT category, COUNT(*) as count, SUM(amount) as total 
        FROM his_expenses 
        WHERE status = 'Approved' 
        GROUP BY category 
        ORDER BY total DESC";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($summary = $res->fetch_object()) {
    $expense_summary[] = $summary;
}

// Get total expenses
$total_expenses = 0;
$ret = "SELECT SUM(amount) as total FROM his_expenses WHERE status = 'Approved'";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
$total = $res->fetch_object();
if ($total) {
    $total_expenses = $total->total ? $total->total : 0;
}

// Get specific expense for editing
$edit_expense = null;
if (isset($_GET['edit'])) {
    $expense_id = $_GET['edit'];
    $ret = "SELECT * FROM his_expenses WHERE expense_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $expense_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_expense = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Finance</a></li>
                                        <li class="breadcrumb-item active">Expense Management</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Expense Management</h4>
                            </div>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row">
                        <div class="col-md-6 col-xl-3">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <h5 class="text-muted font-weight-normal mt-0 text-truncate">Total Expenses</h5>
                                            <h3 class="my-2 py-1">Ksh <?php echo number_format($total_expenses, 2); ?></h3>
                                        </div>
                                        <div class="col-6">
                                            <div class="text-right">
                                                <i class="mdi mdi-cash-multiple text-primary h2"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-3">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <h5 class="text-muted font-weight-normal mt-0 text-truncate">Total Records</h5>
                                            <h3 class="my-2 py-1"><?php echo count($expenses); ?></h3>
                                        </div>
                                        <div class="col-6">
                                            <div class="text-right">
                                                <i class="mdi mdi-file-document text-success h2"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-3">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <h5 class="text-muted font-weight-normal mt-0 text-truncate">Categories</h5>
                                            <h3 class="my-2 py-1"><?php echo count($categories); ?></h3>
                                        </div>
                                        <div class="col-6">
                                            <div class="text-right">
                                                <i class="mdi mdi-tag-multiple text-info h2"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-3">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <h5 class="text-muted font-weight-normal mt-0 text-truncate">This Month</h5>
                                            <h3 class="my-2 py-1">Ksh <?php 
                                                $current_month = date('Y-m');
                                                $ret = "SELECT SUM(amount) as total FROM his_expenses WHERE status = 'Approved' AND DATE_FORMAT(expense_date, '%Y-%m') = ?";
                                                $stmt = $mysqli->prepare($ret);
                                                $stmt->bind_param('s', $current_month);
                                                $stmt->execute();
                                                $res = $stmt->get_result();
                                                $month_total = $res->fetch_object();
                                                echo number_format($month_total->total ? $month_total->total : 0, 2);
                                            ?></h3>
                                        </div>
                                        <div class="col-6">
                                            <div class="text-right">
                                                <i class="mdi mdi-calendar-month text-warning h2"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_expense) ? 'Edit Expense' : 'Add New Expense'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post" enctype="multipart/form-data">
                                        <?php if(isset($edit_expense)) { ?>
                                            <input type="hidden" name="expense_id" value="<?php echo $edit_expense->expense_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="expense_date">Expense Date *</label>
                                                    <input type="date" class="form-control" id="expense_date" name="expense_date" value="<?php echo isset($edit_expense) ? $edit_expense->expense_date : date('Y-m-d'); ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="expense_category">Category *</label>
                                                    <select class="form-control" id="expense_category" name="expense_category" required>
                                                        <option value="">Select Category</option>
                                                        <?php foreach ($categories as $category) { ?>
                                                            <option value="<?php echo $category; ?>" <?php echo (isset($edit_expense) && $edit_expense->category == $category) ? 'selected' : ''; ?>>
                                                                <?php echo $category; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    <label for="expense_description">Description *</label>
                                                    <input type="text" class="form-control" id="expense_description" name="expense_description" value="<?php echo isset($edit_expense) ? $edit_expense->description : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="expense_amount">Amount (Ksh) *</label>
                                                    <input type="number" step="0.01" class="form-control" id="expense_amount" name="expense_amount" value="<?php echo isset($edit_expense) ? $edit_expense->amount : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="payment_method">Payment Method *</label>
                                                    <select class="form-control" id="payment_method" name="payment_method" required>
                                                        <option value="Cash" <?php echo (isset($edit_expense) && $edit_expense->payment_method == 'Cash') ? 'selected' : ''; ?>>Cash</option>
                                                        <option value="Bank Transfer" <?php echo (isset($edit_expense) && $edit_expense->payment_method == 'Bank Transfer') ? 'selected' : ''; ?>>Bank Transfer</option>
                                                        <option value="Cheque" <?php echo (isset($edit_expense) && $edit_expense->payment_method == 'Cheque') ? 'selected' : ''; ?>>Cheque</option>
                                                        <option value="Mobile Money" <?php echo (isset($edit_expense) && $edit_expense->payment_method == 'Mobile Money') ? 'selected' : ''; ?>>Mobile Money</option>
                                                        <option value="Credit Card" <?php echo (isset($edit_expense) && $edit_expense->payment_method == 'Credit Card') ? 'selected' : ''; ?>>Credit Card</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="vendor_name">Vendor Name</label>
                                                    <input type="text" class="form-control" id="vendor_name" name="vendor_name" value="<?php echo isset($edit_expense) ? $edit_expense->vendor_name : ''; ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="vendor_contact">Vendor Contact</label>
                                                    <input type="text" class="form-control" id="vendor_contact" name="vendor_contact" value="<?php echo isset($edit_expense) ? $edit_expense->vendor_contact : ''; ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="status">Status *</label>
                                                    <select class="form-control" id="status" name="status" required>
                                                        <option value="Pending" <?php echo (isset($edit_expense) && $edit_expense->status == 'Pending') ? 'selected' : ''; ?>>Pending</option>
                                                        <option value="Approved" <?php echo (isset($edit_expense) && $edit_expense->status == 'Approved') ? 'selected' : ''; ?>>Approved</option>
                                                        <option value="Rejected" <?php echo (isset($edit_expense) && $edit_expense->status == 'Rejected') ? 'selected' : ''; ?>>Rejected</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="receipt_file">Receipt File</label>
                                                    <input type="file" class="form-control-file" id="receipt_file" name="receipt_file">
                                                    <?php if(isset($edit_expense) && !empty($edit_expense->receipt_file)) { ?>
                                                        <div class="mt-2">
                                                            <a href="assets/uploads/expenses/<?php echo $edit_expense->receipt_file; ?>" target="_blank" class="btn btn-sm btn-info">View Current Receipt</a>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(isset($edit_expense)) { ?>
                                            <button type="submit" name="update_expense" class="btn btn-primary">Update Expense</button>
                                            <a href="expense.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_expense" class="btn btn-success">Add Expense</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Expenses</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Category</th>
                                                <th>Description</th>
                                                <th>Amount</th>
                                                <th>Payment Method</th>
                                                <th>Vendor</th>
                                                <th>Status</th>
                                                <th>Created By</th>
                                                <th>Receipt</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($expenses as $expense) { ?>
                                                <tr>
                                                    <td><?php echo date('M d, Y', strtotime($expense->expense_date)); ?></td>
                                                    <td><span class="badge badge-info"><?php echo $expense->category; ?></span></td>
                                                    <td><?php echo $expense->description; ?></td>
                                                    <td>Ksh <?php echo number_format($expense->amount, 2); ?></td>
                                                    <td><?php echo $expense->payment_method; ?></td>
                                                    <td><?php echo $expense->vendor_name; ?></td>
                                                    <td>
                                                        <span class="badge badge-<?php 
                                                            echo $expense->status == 'Approved' ? 'success' : 
                                                                ($expense->status == 'Pending' ? 'warning' : 'danger'); 
                                                        ?>">
                                                            <?php echo $expense->status; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo $expense->ad_fname . ' ' . $expense->ad_lname; ?></td>
                                                    <td>
                                                        <?php if(!empty($expense->receipt_file)) { ?>
                                                            <a href="assets/uploads/expenses/<?php echo $expense->receipt_file; ?>" target="_blank" class="btn btn-sm btn-info">View</a>
                                                        <?php } else { ?>
                                                            <span class="text-muted">No receipt</span>
                                                        <?php } ?>
                                                    </td>
                                                    <td>
                                                        <a href="expense.php?edit=<?php echo $expense->expense_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="expense.php?delete=<?php echo $expense->expense_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this expense?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Expense Summary -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Expense Summary by Category</h4>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Category</th>
                                                    <th>Number of Expenses</th>
                                                    <th>Total Amount</th>
                                                    <th>Percentage</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($expense_summary as $summary) { 
                                                    $percentage = $total_expenses > 0 ? ($summary->total / $total_expenses) * 100 : 0;
                                                ?>
                                                    <tr>
                                                        <td><?php echo $summary->category; ?></td>
                                                        <td><?php echo $summary->count; ?></td>
                                                        <td>Ksh <?php echo number_format($summary->total, 2); ?></td>
                                                        <td>
                                                            <div class="progress" style="height: 20px;">
                                                                <div class="progress-bar" role="progressbar" style="width: <?php echo $percentage; ?>%;" 
                                                                    aria-valuenow="<?php echo $percentage; ?>" aria-valuemin="0" aria-valuemax="100">
                                                                    <?php echo number_format($percentage, 1); ?>%
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>