<?php
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

error_reporting(0);
session_start();
include('assets/inc/config.php');

if(isset($_GET['pat_id'])) {
    $pat_id = $_GET['pat_id'];
    
    // Fetch patient
    $query = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $patient = $result->fetch_assoc();
    
    // Fetch doctor
    $doc_query = "SELECT * FROM his_docs WHERE doc_id = ?";
    $doc_stmt = $mysqli->prepare($doc_query);
    $doc_stmt->bind_param('s', $patient['doc_id']);
    $doc_stmt->execute();
    $doc_result = $doc_stmt->get_result();
    $doctor = $doc_result->fetch_assoc();
    
    // Settings
    $settings_query = "SELECT * FROM his_system_settings LIMIT 1";
    $settings_result = $mysqli->query($settings_query);
    $settings = $settings_result->fetch_assoc();
    
    // Prepare HTML
    $html = '
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .header { text-align: center; border-bottom: 3px solid #007BFF; margin-bottom: 20px; }
        .hospital-name { font-size: 22px; font-weight: bold; color: #007BFF; }
        h2 { color: #28a745; border-bottom: 2px solid #28a745; padding-bottom: 5px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background: #007BFF; color: #fff; }
        .footer { text-align: center; font-size: 11px; color: #666; margin-top: 20px; }
    </style>
    
    <div class="header">
        <div class="hospital-name">'.$settings['system_name'].'</div>
        <small>'.$settings['system_address'].' | Tel: '.$settings['system_phone'].'</small>
    </div>
    
    <h2>Invoice</h2>
    <table>
        <tr>
            <th>Name</th>
            <td>'.$patient['title'].' '.$patient['pat_fname'].' '.$patient['pat_lname'].'</td>
            <th>Reg Date</th>
            <td>'.date("d-M-Y", strtotime($patient['pat_date_joined'])).'</td>
        </tr>
        <tr>
            <th>Age/Gender/Aadhar</th>
            <td>'.$patient['pat_age'].' / '.$patient['gender'].' / '.$patient['card_no'].'</td>
            <th>Department</th>
            <td>'.$patient['dept'].'</td>
        </tr>
        <tr>
            <th>Doctor</th>
            <td>'.($doctor ? $doctor['doc_fname'].' '.$doctor['doc_lname'] : 'N/A').'</td>
            <th>UHID</th>
            <td>PCHS/'.date("y").'/'.sprintf("%05d",$patient['pat_id']).'</td>
        </tr>
        <tr>
            <th>Patient Type</th>
            <td>'.$patient['pat_type'].'</td>
            <th>Phone</th>
            <td>'.$patient['pat_phone'].'</td>
        </tr>
        <tr>
            <th>Insurance</th>
            <td colspan="3">'.($patient['insurance'] ?: '<span style="color:red;">No Scheme</span>').'</td>
        </tr>
        <tr>
            <th>Clinical History</th>
            <td colspan="3">'.$patient['pat_ailment'].'</td>
        </tr>
        <tr>
            <th>Address</th>
            <td colspan="3">'.$patient['pat_addr'].'</td>
        </tr>
    </table>
    
    <h2>Billing</h2>
    <table>
        <tr>
            <th>Invoice No</th>
            <td>INV-'.date("Y").'-'.sprintf("%05d",$patient['pat_id']).'</td>
            <th>Date</th>
            <td>'.date("d-M-Y").'</td>
        </tr>
        <tr>
            <th>Consultation Fee</th>
            <td>₹'.$patient['fee'].'</td>
            <th>Payment Status</th>
            <td>'.$patient['status'].'</td>
        </tr>
    </table>
    
    <h2>Vitals</h2>
    <table>
        <tr><th>Temp</th><td>..</td><th>BP</th><td>..</td></tr>
        <tr><th>SPO2</th><td>..</td><th>Pulse</th><td>..</td></tr>
        <tr><th>Height</th><td>..</td><th>Weight</th><td>..</td></tr>
    </table>
    
    <div class="footer">
        Printed on '.date("d-M-Y H:i").'<br/>
        Thank you for choosing '.$settings['system_name'].'
    </div>
    ';
    
    // PDF options
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('isRemoteEnabled', true);
    
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    
    // Output
    $dompdf->stream('invoice_'.$patient['pat_number'].'.pdf', ["Attachment" => false]);
}
?>
