
<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include('assets/inc/config.php');

// Get patient ID from URL
$patient_id = isset($_GET['pat_id']) ? $_GET['pat_id'] : null;

// Fetch patient details
$patient = null;
if ($patient_id) {
    $query = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $patient_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $patient = $result->fetch_assoc();
}

// Fetch medicine orders
$medicine_orders = [];
if ($patient_id) {
    $query = "SELECT * FROM his_medicine_orders WHERE pat_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $patient_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $medicine_orders[] = $row;
    }
}

// Calculate totals
$total_qty = 0;
$total_price = 0;
foreach ($medicine_orders as $order) {
    $total_qty += $order['qty'];
    $total_price += $order['total_price'];
}

// Fetch payment history
$payments = [];
if ($patient_id) {
    $query = "SELECT p.*, b.amount as bill_amount FROM his_payments p 
              LEFT JOIN his_bills b ON p.bill_id = b.bill_id 
              WHERE p.pat_id = ? ORDER BY p.payment_date DESC";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $patient_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $payments[] = $row;
    }
}

// Calculate payment totals
$total_paid = 0;
foreach ($payments as $payment) {
    $total_paid += floatval($payment['amount']);
}
$remaining_due = max(0, $total_price - $total_paid);

// Include Dompdf library
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$dompdf = new Dompdf();

// HTML content
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Patient Invoice</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif; /* includes ₹ glyph */
            margin: 20px;
            font-size: 12px;
        }
        .invoice-header {
            text-align: center;
            margin-bottom: 10px;
        }
        .patient-info {
            margin-bottom: 15px;
        }
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .invoice-table th, .invoice-table td {
            border: 1px solid #ddd;
            padding: 4px;
            line-height: 1.2;
            text-align: left;
            vertical-align: top;
        }
        .invoice-table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-right { text-align: right; }
        .total-row { font-weight: bold; }
        h3 {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="invoice-header">
        <h1>Patient Invoice</h1>
    </div>
    
    <div class="patient-info">
        <p><strong>Name:</strong> ' . htmlspecialchars($patient['title'] . ' ' . $patient['pat_fname'] . ' ' . $patient['pat_lname']) . '</p>
        <p><strong>Patient Number:</strong> ' . htmlspecialchars($patient['pat_number']) . '</p>
        <p><strong>Department:</strong> ' . htmlspecialchars($patient['dept']) . '</p>
    </div>

    <h3>Order Details</h3>
    <table class="invoice-table">
        <thead>
            <tr>
                <th>Srno</th>
                <th>Name</th>
                <th>Description</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Total Price</th>
            </tr>
        </thead>
        <tbody>';
$counter = 1;
foreach ($medicine_orders as $order) {
    $html .= '
            <tr>
                <td>' . $counter . '</td>
                <td>' . htmlspecialchars($order['name']) . '</td>
                <td>' . htmlspecialchars($order['description']) . '</td>
                <td>' . htmlspecialchars($order['qty']) . '</td>
                <td>₹' . number_format($order['price'], 2) . '</td>
                <td>₹' . number_format($order['total_price'], 2) . '</td>
            </tr>';
    $counter++;
}
$html .= '
            <tr class="total-row">
                <td colspan="5" class="text-right">Total</td>
                <td>₹' . number_format($total_price, 2) . '</td>
            </tr>
        </tbody>
    </table>';

$html .= '<h3>Payment History</h3>';

if (count($payments) > 0) {
    $html .= '
        <table class="invoice-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Reference</th>
                    <th>Method</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Bill Amount</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>';
    $counter = 1;
    foreach ($payments as $payment) {
        $html .= '
                <tr>
                    <td>' . $counter . '</td>
                    <td>' . htmlspecialchars($payment['payment_ref']) . '</td>
                    <td>' . htmlspecialchars($payment['payment_method'] ?: 'N/A') . '</td>
                    <td>' . date('Y-m-d H:i', strtotime($payment['payment_date'])) . '</td>
                    <td>₹' . number_format($payment['amount'], 2) . '</td>
                    <td>₹' . number_format($payment['bill_amount'], 2) . '</td>
                    <td>' . htmlspecialchars($payment['notes'] ?? '') . '</td>
                </tr>';
        $counter++;
    }
    $html .= '
            </tbody>
        </table>';
} else {
    $html .= '<p>No payment history found for this patient.</p>';
}

// Payment summary as a table
$html .= '
    <h3>Payment Summary</h3>
    <table class="invoice-table">
        <thead>
            <tr>
                <th>Total Amount</th>
                <th>Total Paid</th>
                <th>Remaining Due</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>₹' . number_format($total_price, 2) . '</td>
                <td>₹' . number_format($total_paid, 2) . '</td>
                <td>₹' . number_format($remaining_due, 2) . '</td>
            </tr>
        </tbody>
    </table>
</body>
</html>';

// Load HTML content
$dompdf->loadHtml($html);

// Set paper size and orientation
$dompdf->setPaper('A4', 'portrait');

// Render the HTML as PDF
$dompdf->render();

// Output the generated PDF
$dompdf->stream('patient_invoice_' . $patient_id . '.pdf', ['Attachment' => true]);
?>
