<?php
include('assets/inc/config.php');

// Chukua data zote kutoka table his_patient_ailments
$query = "SELECT ailment_id, ailment_name, fee, description, status 
          FROM his_patient_ailments";

$stmt = $mysqli->prepare($query);
$stmt->execute();
$result = $stmt->get_result();

$ailments = [];

while ($row = $result->fetch_assoc()) {
    $ailments[] = [
        'id'          => $row['ailment_id'],
        'ailment'     => $row['ailment_name'] ?? 'N/A',
        'fee'         => $row['fee'] ?? '0.00',
        'description' => $row['description'] ?? 'N/A',
        'status'      => $row['status'] ?? 'Inactive'
    ];
}

// Encode as JSON
header('Content-Type: application/json');
echo json_encode(['ailments' => $ailments]);
?>
