<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_insurance'])) {
    $insurance_name = $_POST['insurance_name'];
    
    $query = "INSERT INTO his_insurance (insurance_name) VALUES (?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('s', $insurance_name);
    
    if ($stmt->execute()) {
        $success = "Insurance added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_insurance'])) {
    $insurance_id = $_POST['insurance_id'];
    $insurance_name = $_POST['insurance_name'];
    
    $query = "UPDATE his_insurance SET insurance_name = ? WHERE insurance_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('si', $insurance_name, $insurance_id);
    
    if ($stmt->execute()) {
        $success = "Insurance updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $insurance_id = $_GET['delete'];
    $query = "DELETE FROM his_insurance WHERE insurance_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $insurance_id);
    
    if ($stmt->execute()) {
        $success = "Insurance deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all insurance companies
$insurances = [];
$ret = "SELECT * FROM his_insurance ORDER BY insurance_name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($insurance = $res->fetch_object()) {
    $insurances[] = $insurance;
}

// Get specific insurance for editing
$edit_insurance = null;
if (isset($_GET['edit'])) {
    $insurance_id = $_GET['edit'];
    $ret = "SELECT * FROM his_insurance WHERE insurance_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $insurance_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_insurance = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Insurance Management</a></li>
                                        <li class="breadcrumb-item active">Insurance Companies</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Insurance Companies</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_insurance) ? 'Edit Insurance Company' : 'Add New Insurance Company'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_insurance)) { ?>
                                            <input type="hidden" name="insurance_id" value="<?php echo $edit_insurance->insurance_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="insurance_name">Insurance Company Name *</label>
                                                    <input type="text" class="form-control" id="insurance_name" name="insurance_name" value="<?php echo isset($edit_insurance) ? $edit_insurance->insurance_name : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(isset($edit_insurance)) { ?>
                                            <button type="submit" name="update_insurance" class="btn btn-primary">Update Insurance</button>
                                            <a href="insurance.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_insurance" class="btn btn-success">Add Insurance</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Insurance Companies</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Insurance Name</th>
                                                <th>Created At</th>
                                                <th>Updated At</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($insurances as $insurance) { ?>
                                                <tr>
                                                    <td><?php echo $insurance->insurance_id; ?></td>
                                                    <td><?php echo $insurance->insurance_name; ?></td>
                                                    <td><?php echo date('M d, Y h:i A', strtotime($insurance->created_at)); ?></td>
                                                    <td><?php echo date('M d, Y h:i A', strtotime($insurance->updated_at)); ?></td>
                                                    <td>
                                                        <a href="insurance.php?edit=<?php echo $insurance->insurance_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="insurance.php?delete=<?php echo $insurance->insurance_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this insurance company?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>