<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle invoice actions
if(isset($_GET['action'])) {
    $id = intval($_GET['id']);
    $action = $_GET['action'];
    
    switch($action) {
        case 'edit_fee':
            if(isset($_POST['update_fee'])) {
                $new_fee = $_POST['new_fee'];
                $update = "UPDATE his_patients SET fee=? WHERE pat_id=?";
                $stmt = $mysqli->prepare($update);
                $stmt->bind_param('si', $new_fee, $id);
                $stmt->execute();
                
                if($stmt) {
                    $success = "Fee updated successfully";
                } else {
                    $err = "Failed to update fee";
                }
                $stmt->close();
            }
            break;
            
        case 'pay':
            $update = "UPDATE his_patients SET psataus='paid' WHERE pat_id=?";
            $stmt = $mysqli->prepare($update);
            $stmt->bind_param('i', $id);
            $stmt->execute();
            
            if($stmt) {
                $success = "Invoice marked as paid";
            } else {
                $err = "Failed to update invoice status";
            }
            $stmt->close();
            break;
            
        case 'cancel':
            $update = "UPDATE his_patients SET psataus='cancelled' WHERE pat_id=?";
            $stmt = $mysqli->prepare($update);
            $stmt->bind_param('i', $id);
            $stmt->execute();
            
            if($stmt) {
                $success = "Invoice cancelled";
            } else {
                $err = "Failed to cancel invoice";
            }
            $stmt->close();
            break;
            
        case 'reject':
            $update = "UPDATE his_patients SET psataus='rejected' WHERE pat_id=?";
            $stmt = $mysqli->prepare($update);
            $stmt->bind_param('i', $id);
            $stmt->execute();
            
            if($stmt) {
                $success = "Invoice rejected";
            } else {
                $err = "Failed to reject invoice";
            }
            $stmt->close();
            break;
    }
}

// Get financial summaries
$financials = array();
$ret = "SELECT 
        SUM(CASE WHEN psataus = 'paid' THEN CAST(fee AS DECIMAL(10,2)) ELSE 0 END) as total_income,
        SUM(CASE WHEN psataus = 'pending' THEN CAST(fee AS DECIMAL(10,2)) ELSE 0 END) as total_pending,
        COUNT(*) as total_invoices,
        SUM(CAST(fee AS DECIMAL(10,2))) as total_fees
        FROM his_patients";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
$financials = $res->fetch_assoc();

// Handle data export
if(isset($_GET['export'])) {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=invoices_export_'.date('Y-m-d').'.csv');
    
    $output = fopen('php://output', 'w');
    
    // Header row
    fputcsv($output, array(
        'Invoice ID', 
        'Patient Name', 
        'Patient ID',
        'Service Type',
        'Ailment',
        'Fee (USD)',
        'Status',
        'Date',
        'Insurance'
    ));
    
    // Data rows
    $ret = "SELECT * FROM his_patients ORDER BY pat_date_joined DESC"; 
    $stmt = $mysqli->prepare($ret);
    $stmt->execute();
    $res = $stmt->get_result();
    
    while($row = $res->fetch_assoc()) {
        fputcsv($output, array(
            $row['pat_id'],
            $row['pat_fname'].' '.$row['pat_lname'],
            $row['pat_number'],
            $row['pat_type'],
            $row['pat_ailment'],
            $row['fee'],
            $row['psataus'],
            $row['pat_date_joined'],
            $row['insurance']
        ));
    }
    
    fclose($output);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Billing</a></li>
                                        <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Manage Invoices</li>
                                    </ol>
                                </div>
                                <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                    <i class="fas fa-file-invoice-dollar mr-2"></i>Patient Invoices Management
                                </h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <!-- Financial Summary Cards -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="card border-primary" style="border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5 class="card-title text-muted mb-2">Total Income</h5>
                                            <h3 class="mb-0 text-success">$<?php echo number_format($financials['total_income'], 2); ?></h3>
                                        </div>
                                        <div class="bg-success bg-soft p-3 rounded">
                                            <i class="fas fa-dollar-sign text-success font-24"></i>
                                        </div>
                                    </div>
                                    <p class="text-muted mb-0 mt-2">
                                        <span class="text-success"><i class="mdi mdi-arrow-up"></i> All paid invoices</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-warning" style="border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5 class="card-title text-muted mb-2">Pending Payments</h5>
                                            <h3 class="mb-0 text-warning">$<?php echo number_format($financials['total_pending'], 2); ?></h3>
                                        </div>
                                        <div class="bg-warning bg-soft p-3 rounded">
                                            <i class="fas fa-clock text-warning font-24"></i>
                                        </div>
                                    </div>
                                    <p class="text-muted mb-0 mt-2">
                                        <span class="text-warning"><i class="mdi mdi-alert"></i> Unpaid invoices</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-info" style="border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5 class="card-title text-muted mb-2">Total Invoices</h5>
                                            <h3 class="mb-0 text-info"><?php echo $financials['total_invoices']; ?></h3>
                                        </div>
                                        <div class="bg-info bg-soft p-3 rounded">
                                            <i class="fas fa-file-invoice text-info font-24"></i>
                                        </div>
                                    </div>
                                    <p class="text-muted mb-0 mt-2">
                                        <span class="text-info"><i class="mdi mdi-file-document"></i> All invoices</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-danger" style="border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h5 class="card-title text-muted mb-2">Balance</h5>
                                            <h3 class="mb-0 text-danger">$<?php echo number_format($financials['total_fees'] - $financials['total_income'], 2); ?></h3>
                                        </div>
                                        <div class="bg-danger bg-soft p-3 rounded">
                                            <i class="fas fa-balance-scale text-danger font-24"></i>
                                        </div>
                                    </div>
                                    <p class="text-muted mb-0 mt-2">
                                        <span class="text-danger"><i class="mdi mdi-alert-circle"></i> Outstanding amount</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End Financial Summary Cards -->

                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h4 class="header-title mb-0" style="color: #4e73df; font-weight: 600; border-left: 4px solid #4e73df; padding-left: 10px;">
                                        <i class="fas fa-clipboard-list mr-2"></i>All Patient Invoices
                                    </h4>
                                    <div>
                                        <a href="?export=csv" class="btn btn-sm btn-dark" style="border-radius: 4px; margin-right: 5px;">
                                            <i class="mdi mdi-file-export"></i> Export CSV
                                        </a>
                                        <button class="btn btn-sm btn-secondary" style="border-radius: 4px;" onclick="window.print()">
                                            <i class="mdi mdi-printer"></i> Print Report
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group position-relative">
                                                <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                <input id="invoice-search" type="text" placeholder="Search invoices..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="invoice-table" class="table table-bordered toggle-circle mb-0" data-page-size="10" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                        <thead style="background: linear-gradient(to right, #4e73df, #224abe); color: white;">
                                            <tr>
                                                <th style="border: none; padding: 15px 10px;">#</th>
                                                <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Patient ID</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Service</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Fee (USD)</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Status</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Date</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                            $ret = "SELECT * FROM his_patients ORDER BY pat_date_joined DESC"; 
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            
                                            while($row = $res->fetch_object()) {
                                                // Determine status badge color
                                                $status_class = '';
                                                if($row->psataus == 'paid') {
                                                    $status_class = 'badge-success';
                                                } elseif($row->psataus == 'pending') {
                                                    $status_class = 'badge-warning';
                                                } elseif($row->psataus == 'cancelled') {
                                                    $status_class = 'badge-danger';
                                                } elseif($row->psataus == 'rejected') {
                                                    $status_class = 'badge-secondary';
                                                }
                                        ?>
                                            <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                <td style="padding: 15px 10px; border: none; font-weight: 600; color: #4e73df;">
                                                    <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>
                                                </td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number;?></td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                    <?php echo $row->pat_type; ?> - <?php echo $row->pat_ailment; ?>
                                                </td>
                                                <td style="padding: 15px 10px; border: none; font-weight: 600; color: #2ecc71;">
                                                    $<?php echo number_format($row->fee, 2); ?>
                                                </td>
                                                <td style="padding: 15px 10px; border: none;">
                                                    <span class="badge <?php echo $status_class; ?> badge-pill" style="padding: 5px 12px; font-size: 12px;">
                                                        <?php echo ucfirst($row->psataus); ?>
                                                    </span>
                                                </td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                    <?php echo date('d M Y', strtotime($row->pat_date_joined)); ?>
                                                </td>
                                                <td style="padding: 15px 10px; border: none;">
                                                    <div class="btn-group" role="group">
                                                        <!-- Edit Fee Modal Trigger -->
                                                        <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#editFeeModal<?php echo $row->pat_id; ?>" style="border-radius: 4px; margin-right: 5px;">
                                                            <i class="mdi mdi-cash-edit"></i> Edit Fee
                                                        </button>
                                                        
                                                        <!-- Pay Invoice -->
                                                        <a href="?action=pay&id=<?php echo $row->pat_id; ?>" class="btn btn-sm btn-success" style="border-radius: 4px; margin-right: 5px;" onclick="return confirm('Mark this invoice as paid?')">
                                                            <i class="mdi mdi-cash-check"></i> Pay
                                                        </a>
                                                        
                                                        <!-- Cancel Invoice -->
                                                        <a href="?action=cancel&id=<?php echo $row->pat_id; ?>" class="btn btn-sm btn-warning" style="border-radius: 4px; margin-right: 5px;" onclick="return confirm('Cancel this invoice?')">
                                                            <i class="mdi mdi-cancel"></i> Cancel
                                                        </a>
                                                        
                                                        <!-- Reject Invoice -->
                                                        <a href="?action=reject&id=<?php echo $row->pat_id; ?>" class="btn btn-sm btn-danger" style="border-radius: 4px; margin-right: 5px;" onclick="return confirm('Reject this invoice?')">
                                                            <i class="mdi mdi-close-thick"></i> Reject
                                                        </a>
                                                        
                                                        <!-- Print Invoice -->
                                                        <a href="print_invoice.php?pat_id=<?php echo $row->pat_id; ?>" class="btn btn-sm btn-primary" style="border-radius: 4px;" target="_blank">
                                                            <i class="mdi mdi-printer"></i> Print
                                                        </a>
                                                    </div>
                                                    
                                                    <!-- Edit Fee Modal -->
                                                    <div class="modal fade" id="editFeeModal<?php echo $row->pat_id; ?>" tabindex="-1" role="dialog" aria-labelledby="editFeeModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="editFeeModalLabel">Edit Fee for <?php echo $row->pat_fname; ?> <?php echo $row->pat_lname; ?></h5>
                                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                <form method="post" action="?action=edit_fee&id=<?php echo $row->pat_id; ?>">
                                                                    <div class="modal-body">
                                                                        <div class="form-group">
                                                                            <label for="new_fee">New Fee Amount (USD)</label>
                                                                            <input type="number" class="form-control" id="new_fee" name="new_fee" value="<?php echo $row->fee; ?>" step="0.01" min="0" required>
                                                                        </div>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                                        <button type="submit" name="update_fee" class="btn btn-primary">Update Fee</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php 
                                            $cnt = $cnt + 1; 
                                            } 
                                        ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="active">
                                                <td colspan="8" style="border: none;">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <script>
    $(document).ready(function() {
        // Initialize footable
        $('#invoice-table').footable();
        
        // Search functionality
        $('#invoice-search').keyup(function() {
            $('#invoice-table').trigger('footable_filter', {filter: $(this).val()});
        });
    });
    </script>
    
</body>
</html>