<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Define roles
$roles = array('Reception', 'MRD', 'LAB', 'BLOODBANK');

// Handle form submissions
if (isset($_POST['add_user'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $mobileno = $_POST['mobileno'];
    $password = sha1($_POST['password']);
    $role = $_POST['role'];
    $status = $_POST['status'];
    
    // Handle image upload
    $image = '';
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $target_dir = "assets/uploads/users/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_extension = pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION);
        $image = uniqid() . '.' . $file_extension;
        $target_file = $target_dir . $image;
        
        // Check if image file is an actual image
        $check = getimagesize($_FILES["image"]["tmp_name"]);
        if ($check !== false) {
            move_uploaded_file($_FILES["image"]["tmp_name"], $target_file);
        } else {
            $err = "File is not an image.";
        }
    }
    
    $query = "INSERT INTO his_users (name, email, mobileno, password, role, status, image) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssssss', $name, $email, $mobileno, $password, $role, $status, $image);
    
    if ($stmt->execute()) {
        $success = "User added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_user'])) {
    $user_id = $_POST['user_id'];
    $name = $_POST['name'];
    $email = $_POST['email'];
    $mobileno = $_POST['mobileno'];
    $role = $_POST['role'];
    $status = $_POST['status'];
    
    // Handle password update if provided
    $password_update = '';
    if (!empty($_POST['password'])) {
        $password = sha1($_POST['password']);
        $password_update = ", password = ?";
    }
    
    // Handle image upload
    $image_update = '';
    $image = '';
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $target_dir = "assets/uploads/users/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_extension = pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION);
        $image = uniqid() . '.' . $file_extension;
        $target_file = $target_dir . $image;
        
        // Check if image file is an actual image
        $check = getimagesize($_FILES["image"]["tmp_name"]);
        if ($check !== false) {
            move_uploaded_file($_FILES["image"]["tmp_name"], $target_file);
            $image_update = ", image = ?";
        } else {
            $err = "File is not an image.";
        }
    }
    
    // Build dynamic query based on what's being updated
    if (!empty($password_update) && !empty($image_update)) {
        $query = "UPDATE his_users SET name = ?, email = ?, mobileno = ?, role = ?, status = ? $password_update $image_update WHERE user_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('sssssssi', $name, $email, $mobileno, $role, $status, $password, $image, $user_id);
    } elseif (!empty($password_update)) {
        $query = "UPDATE his_users SET name = ?, email = ?, mobileno = ?, role = ?, status = ? $password_update WHERE user_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('ssssssi', $name, $email, $mobileno, $role, $status, $password, $user_id);
    } elseif (!empty($image_update)) {
        $query = "UPDATE his_users SET name = ?, email = ?, mobileno = ?, role = ?, status = ? $image_update WHERE user_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('ssssssi', $name, $email, $mobileno, $role, $status, $image, $user_id);
    } else {
        $query = "UPDATE his_users SET name = ?, email = ?, mobileno = ?, role = ?, status = ? WHERE user_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('sssssi', $name, $email, $mobileno, $role, $status, $user_id);
    }
    
    if ($stmt->execute()) {
        $success = "User updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $user_id = $_GET['delete'];
    
    // First get the image path to delete the file
    $ret = "SELECT image FROM his_users WHERE user_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $user = $res->fetch_object();
    
    // Delete the image file if it exists
    if ($user && !empty($user->image) && file_exists("assets/uploads/users/" . $user->image)) {
        unlink("assets/uploads/users/" . $user->image);
    }
    
    $query = "DELETE FROM his_users WHERE user_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $user_id);
    
    if ($stmt->execute()) {
        $success = "User deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all users
$users = [];
$ret = "SELECT * FROM his_users ORDER BY name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($user = $res->fetch_object()) {
    $users[] = $user;
}

// Get specific user for editing
$edit_user = null;
if (isset($_GET['edit'])) {
    $user_id = $_GET['edit'];
    $ret = "SELECT * FROM his_users WHERE user_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_user = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">User Management</a></li>
                                        <li class="breadcrumb-item active">Login Master</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Users</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_user) ? 'Edit User' : 'Add New User'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post" enctype="multipart/form-data">
                                        <?php if(isset($edit_user)) { ?>
                                            <input type="hidden" name="user_id" value="<?php echo $edit_user->user_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="name">Full Name *</label>
                                                    <input type="text" class="form-control" id="name" name="name" value="<?php echo isset($edit_user) ? $edit_user->name : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="email">Email Address *</label>
                                                    <input type="email" class="form-control" id="email" name="email" value="<?php echo isset($edit_user) ? $edit_user->email : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="mobileno">Mobile Number *</label>
                                                    <input type="text" class="form-control" id="mobileno" name="mobileno" value="<?php echo isset($edit_user) ? $edit_user->mobileno : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="password">Password <?php echo isset($edit_user) ? '(Leave blank to keep current)' : '*'; ?></label>
                                                    <input type="password" class="form-control" id="password" name="password" <?php echo isset($edit_user) ? '' : 'required'; ?>>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="role">Role *</label>
                                                    <select class="form-control" id="role" name="role" required>
                                                        <option value="">Select Role</option>
                                                        <?php foreach ($roles as $role) { ?>
                                                            <option value="<?php echo $role; ?>" <?php echo (isset($edit_user) && $edit_user->role == $role) ? 'selected' : ''; ?>>
                                                                <?php echo $role; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="status">Status *</label>
                                                    <select class="form-control" id="status" name="status" required>
                                                        <option value="Active" <?php echo (isset($edit_user) && $edit_user->status == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                        <option value="Inactive" <?php echo (isset($edit_user) && $edit_user->status == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="image">Profile Image</label>
                                                    <input type="file" class="form-control-file" id="image" name="image">
                                                    <?php if(isset($edit_user) && !empty($edit_user->image)) { ?>
                                                        <div class="mt-2">
                                                            <img src="assets/uploads/users/<?php echo $edit_user->image; ?>" alt="Profile Image" style="max-width: 100px; max-height: 100px;">
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(isset($edit_user)) { ?>
                                            <button type="submit" name="update_user" class="btn btn-primary">Update User</button>
                                            <a href="loginmaster.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_user" class="btn btn-success">Add User</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Users</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Image</th>
                                                <th>Name</th>
                                                <th>Email</th>
                                                <th>Mobile No</th>
                                                <th>Role</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($users as $user) { ?>
                                                <tr>
                                                    <td>
                                                        <?php if(!empty($user->image)) { ?>
                                                            <img src="assets/uploads/users/<?php echo $user->image; ?>" alt="Profile Image" style="width: 50px; height: 50px; object-fit: cover;">
                                                        <?php } else { ?>
                                                            <div style="width: 50px; height: 50px; background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
                                                                <i class="mdi mdi-account" style="font-size: 24px;"></i>
                                                            </div>
                                                        <?php } ?>
                                                    </td>
                                                    <td><?php echo $user->name; ?></td>
                                                    <td><?php echo $user->email; ?></td>
                                                    <td><?php echo $user->mobileno; ?></td>
                                                    <td><span class="badge badge-info"><?php echo $user->role; ?></span></td>
                                                    <td><span class="badge badge-<?php echo $user->status == 'Active' ? 'success' : 'danger'; ?>"><?php echo $user->status; ?></span></td>
                                                    <td>
                                                        <a href="loginmaster.php?edit=<?php echo $user->user_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="loginmaster.php?delete=<?php echo $user->user_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>