<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['delete_mdr_number']))
  {
        $id=intval($_GET['delete_mdr_number']);
        $adn="DELETE FROM his_medical_records WHERE mdr_number = ?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();     
  
          if($stmt)
          {
            $success = "Medical Records Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Medical Records</a></li>
                                            <li class="breadcrumb-item active">Manage Medical Records</li>
                                        </ol>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="page-title">Manage Medical Records</h4>
                                        <div class="search-box">
                                            <div class="form-group mb-0">
                                                <input id="demo-foo-search" type="text" placeholder="Search records..." class="form-control form-control-sm" autocomplete="on">
                                                <i class="fas fa-search search-icon"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <?php if(isset($success)) { ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo $success; ?>
                            </div>
                        <?php } ?>
                        
                        <?php if(isset($err)) { ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo $err; ?>
                            </div>
                        <?php } ?>

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="table-responsive">
                                        <table id="medical-records-table" class="table table-hover table-striped table-bordered mb-0" data-page-size="7">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th width="5%">#</th>
                                                <th>Patient Name</th>
                                                <th data-hide="phone">Patient ID</th>
                                                <th data-hide="phone">Address</th>
                                                <th data-hide="phone">Ailment</th>
                                                <th data-hide="phone">Age</th>
                                                <th width="20%">Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $ret="SELECT * FROM his_medical_records ORDER BY RAND()"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object()):
                                            ?>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm mr-2">
                                                                <span class="avatar-title bg-soft-primary rounded">
                                                                    <?php echo strtoupper(substr($row->mdr_pat_name, 0, 1)); ?>
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-0"><?php echo $row->mdr_pat_name;?></h6>
                                                                <small class="text-muted">ID: <?php echo $row->mdr_pat_number;?></small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $row->mdr_pat_number;?></td>
                                                    <td>
                                                        <span class="d-inline-block text-truncate" style="max-width: 150px;" 
                                                              title="<?php echo $row->mdr_pat_adr; ?>">
                                                            <?php echo $row->mdr_pat_adr; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="d-inline-block text-truncate" style="max-width: 200px;" 
                                                              title="<?php echo $row->mdr_pat_ailment; ?>">
                                                            <?php echo $row->mdr_pat_ailment; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-soft-info p-2">
                                                            <?php echo $row->mdr_pat_age;?> Years
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="btn-group btn-group-sm" role="group">
                                                            <a href="view_single_medical_record.php?mdr_id=<?php echo $row->mdr_id;?>&&mdr_number=<?php echo $row->mdr_number;?>" 
                                                               class="btn btn-primary" title="View">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                            <a href="upate_single_medical_record.php?mdr_number=<?php echo $row->mdr_number;?>" 
                                                               class="btn btn-warning" title="Update">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <a href="manage_medical_record.php?delete_mdr_number=<?php echo $row->mdr_number;?>" 
                                                               class="btn btn-danger" title="Delete"
                                                               onclick="return confirm('Are you sure you want to delete this record?')">
                                                                <i class="fas fa-trash-alt"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php 
                                                $cnt++;
                                                endwhile;
                                            ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="7">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="dataTables_info">
                                                            Showing <?php echo max(1, $cnt-1); ?> records
                                                        </div>
                                                        <div>
                                                            <ul class="pagination pagination-rounded justify-content-end mb-0"></ul>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- SweetAlert js -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Custom styling */
            .avatar-sm {
                width: 32px;
                height: 32px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
            }
            
            .avatar-title {
                display: flex;
                align-items: center;
                justify-content: center;
                width: 100%;
                height: 100%;
                font-weight: bold;
                color: #fff;
            }
            
            .search-box {
                position: relative;
                width: 250px;
            }
            
            .search-box .search-icon {
                position: absolute;
                right: 10px;
                top: 8px;
                color: #98a6ad;
            }
            
            #medical-records-table thead th {
                position: sticky;
                top: 0;
                background-color: #343a40;
                color: white;
                font-weight: 500;
            }
            
            #medical-records-table tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.05);
            }
            
            .badge-soft-info {
                color: #3bafda;
                background-color: rgba(59, 175, 218, 0.1);
            }
            
            .text-truncate {
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }
            
            .btn-group-sm > .btn {
                padding: 0.25rem 0.5rem;
                font-size: 0.75rem;
            }
            
            .dataTables_info {
                font-size: 0.9rem;
                color: #6c757d;
            }
        </style>
        
        <script>
        // Confirm before deletion
        function confirmDelete() {
            return confirm('Are you sure you want to delete this medical record?');
        }
        </script>
    </body>
</html>