<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

if(isset($_GET['delete_pharm_cat'])) {
    $id = intval($_GET['delete_pharm_cat']);
    $adn = "DELETE FROM his_pharmaceuticals_categories WHERE pharm_cat_id=?";
    $stmt = $mysqli->prepare($adn);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $stmt->close();     
  
    if($stmt) {
        $success = "Pharmaceutical Category Records Deleted";
    } else {
        $err = "Try Again Later";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<style>
    /* Enhanced Table Styling */
    .table {
        border-collapse: separate;
        border-spacing: 0;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    }
    
    .table th {
        background-color: #4361ee;
        color: white;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        font-size: 0.85rem;
    }
    
    .table td, .table th {
        padding: 12px 15px;
        vertical-align: middle;
        border-top: 1px solid #e9ecef;
    }
    
    .table tbody tr:hover {
        background-color: rgba(67, 97, 238, 0.05);
    }
    
    /* Badge Styling */
    .badge {
        padding: 6px 10px;
        font-weight: 500;
        letter-spacing: 0.3px;
        font-size: 0.75rem;
        margin-right: 5px;
        transition: all 0.2s;
    }
    
    .badge-success {
        background-color: #00b46e;
    }
    
    .badge-warning {
        background-color: #ff9e00;
    }
    
    .badge-danger {
        background-color: #dc3545;
    }
    
    .badge:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }
    
    /* Search Box Styling */
    #demo-foo-search {
        border-radius: 20px;
        padding-left: 15px;
        border: 1px solid #e0e3ff;
        box-shadow: none;
    }
    
    #demo-foo-search:focus {
        border-color: #4361ee;
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    /* Card Header Styling */
    .card-box {
        border-radius: 10px;
        box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
        border: none;
    }
    
    /* Page Title Styling */
    .page-title {
        color: #2b2d42;
        font-weight: 600;
    }
    
    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .table td, .table th {
            padding: 8px 10px;
        }
        
        .badge {
            display: block;
            margin-bottom: 5px;
            width: 100%;
        }
    }
</style>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">Manage Pharmaceutical Category</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Pharmaceutical Categories</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <h4 class="header-title"></h4>
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group mr-2" style="display:none">
                                                <select id="demo-foo-filter-status" class="custom-select custom-select-sm">
                                                    <option value="">Show all</option>
                                                    <option value="Discharged">Discharged</option>
                                                    <option value="OutPatients">OutPatients</option>
                                                    <option value="InPatients">InPatients</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <input id="demo-foo-search" type="text" placeholder="Search..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="7">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th data-toggle="true">Category Name</th>
                                            <th data-hide="phone">Category Vendor</th>
                                            <th data-hide="phone">Actions</th>
                                        </tr>
                                        </thead>
                                        <?php
                                        /*
                                            *get details of allpatients
                                            *
                                        */
                                            $ret = "SELECT * FROM his_pharmaceuticals_categories ORDER BY RAND()"; 
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()) {
                                        ?>

                                            <tbody>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td><?php echo htmlspecialchars($row->pharm_cat_name);?></td>
                                                <td><?php echo htmlspecialchars($row->pharm_cat_vendor);?></td>
                                                <td>
                                                    <a href="view_single_pharm_category.php?pharm_cat_id=<?php echo $row->pharm_cat_id;?>" class="badge badge-success"><i class="far fa-eye"></i> View</a>
                                                    <a href="update_single_pharm_category.php?pharm_cat_name=<?php echo $row->pharm_cat_name;?>" class="badge badge-warning"><i class="fas fa-clipboard-check"></i> Update</a>
                                                    <a href="manage_pharm_cat.php?delete_pharm_cat=<?php echo $row->pharm_cat_id;?>" class="badge badge-danger" onclick="return confirm('Are you sure you want to delete this category?');"><i class="fas fa-trash-alt"></i> Delete</a>
                                                </td>
                                            </tr>
                                            </tbody>
                                        <?php $cnt = $cnt + 1; } ?>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="8">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>

</html>