<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

if(isset($_GET['delete_pres_number'])) {
    $id = intval($_GET['delete_pres_number']);
    $adn = "DELETE FROM his_prescriptions WHERE pres_number=?";
    $stmt = $mysqli->prepare($adn);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $stmt->close();     
  
    if($stmt) {
        $success = "Prescription deleted successfully";
    } else {
        $err = "Error deleting prescription. Please try again.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }
        
        body {
            background-color: var(--light);
            font-family: 'Inter', sans-serif;
        }
        
        .card-box {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark);
            font-weight: 700;
            position: relative;
            display: inline-block;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: -8px;
            width: 60px;
            height: 3px;
            background: var(--primary);
            border-radius: 3px;
        }
        
        .table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        
        .table th {
            background-color: var(--primary);
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85rem;
            position: sticky;
            top: 0;
        }
        
        .table td, .table th {
            padding: 12px 15px;
            vertical-align: middle;
            border-top: 1px solid #e9ecef;
        }
        
        .table tbody tr:hover {
            background-color: rgba(67, 97, 238, 0.05);
        }
        
        .badge {
            padding: 8px 12px;
            font-weight: 500;
            letter-spacing: 0.3px;
            font-size: 0.75rem;
            margin-right: 5px;
            border-radius: 6px;
            transition: all 0.2s;
        }
        
        .badge-success {
            background-color: var(--success);
        }
        
        .badge-warning {
            background-color: var(--warning);
            color: #fff;
        }
        
        .badge-danger {
            background-color: var(--danger);
        }
        
        .badge:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            opacity: 0.9;
        }
        
        #demo-foo-search {
            border-radius: 20px;
            padding: 8px 15px;
            border: 1px solid var(--border);
            box-shadow: none;
            transition: all 0.3s;
        }
        
        #demo-foo-search:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
            width: 250px;
        }
        
        .patient-type {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .patient-type.inpatient {
            background-color: rgba(220, 53, 69, 0.1);
            color: var(--danger);
        }
        
        .patient-type.outpatient {
            background-color: rgba(0, 180, 110, 0.1);
            color: var(--success);
        }
        
        @media (max-width: 768px) {
            .table-responsive {
                border: 0;
            }
            
            .table thead {
                display: none;
            }
            
            .table tr {
                margin-bottom: 15px;
                display: block;
                border: 1px solid #e9ecef;
                border-radius: 8px;
            }
            
            .table td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                border-bottom: 1px solid #e9ecef;
            }
            
            .table td:before {
                content: attr(data-label);
                font-weight: 600;
                color: var(--dark);
                margin-right: 15px;
            }
            
            .badge {
                margin-top: 5px;
                display: block;
                width: 100%;
            }
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Pharmacy</a></li>
                                        <li class="breadcrumb-item active">Manage Prescriptions</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Prescription Management</h4>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group">
                                                <input id="demo-foo-search" type="text" placeholder="Search prescriptions..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="10">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th data-toggle="true">Patient Name</th>
                                            <th data-hide="phone">Patient Number</th>
                                            <th data-hide="phone">Ailment</th>
                                            <th data-hide="phone">Age</th>
                                            <th data-hide="phone">Category</th>
                                            <th data-hide="phone">Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                            $ret = "SELECT * FROM his_prescriptions ORDER BY pres_pat_name";
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()) {
                                                $patientTypeClass = strtolower($row->pres_pat_type) === 'inpatient' ? 'inpatient' : 'outpatient';
                                        ?>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td><?php echo htmlspecialchars($row->pres_pat_name);?></td>
                                                <td><?php echo htmlspecialchars($row->pres_pat_number);?></td>
                                                <td><?php echo htmlspecialchars($row->pres_pat_ailment);?></td>
                                                <td><?php echo htmlspecialchars($row->pres_pat_age);?> Years</td>
                                                <td>
                                                    <span class="patient-type <?php echo $patientTypeClass; ?>">
                                                        <?php echo htmlspecialchars($row->pres_pat_type);?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-wrap">
                                                        <a href="view_single_pres.php?pres_number=<?php echo $row->pres_number;?>" class="badge badge-success mr-1 mb-1">
                                                            <i class="fas fa-eye mr-1"></i> View
                                                        </a>
                                                        <a href="upate_single_pres.php?pres_number=<?php echo $row->pres_number;?>" class="badge badge-warning mr-1 mb-1">
                                                            <i class="fas fa-edit mr-1"></i> Update
                                                        </a>
                                                        <a href="manage_presc.php?delete_pres_number=<?php echo $row->pres_number;?>" class="badge badge-danger mb-1" onclick="return confirm('Are you sure you want to delete this prescription?');">
                                                            <i class="fas fa-trash-alt mr-1"></i> Delete
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php $cnt = $cnt + 1; } ?>
                                        </tbody>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="7">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- Font Awesome -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>