<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_mrd'])) {
    $mrd_number = $_POST['mrd_number'];
    $pat_name = $_POST['pat_name'];
    $pat_adr = $_POST['pat_adr'];
    $pat_age = $_POST['pat_age'];
    $pat_ailment = $_POST['pat_ailment'];
    $pat_number = $_POST['pat_number'];
    $pat_prescr = $_POST['pat_prescr'];
    
    $query = "INSERT INTO his_medical_records (mrd_number, mdr_pat_name, mdr_pat_adr, mdr_pat_age, mdr_pat_ailment, mdr_pat_number, mdr_pat_prescr) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssssss', $mrd_number, $pat_name, $pat_adr, $pat_age, $pat_ailment, $pat_number, $pat_prescr);
    
    if ($stmt->execute()) {
        $success = "Medical record added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_mrd'])) {
    $mrd_id = $_POST['mrd_id'];
    $mrd_number = $_POST['mrd_number'];
    $pat_name = $_POST['pat_name'];
    $pat_adr = $_POST['pat_adr'];
    $pat_age = $_POST['pat_age'];
    $pat_ailment = $_POST['pat_ailment'];
    $pat_number = $_POST['pat_number'];
    $pat_prescr = $_POST['pat_prescr'];
    
    $query = "UPDATE his_medical_records SET mrd_number = ?, mdr_pat_name = ?, mdr_pat_adr = ?, mdr_pat_age = ?, mdr_pat_ailment = ?, mdr_pat_number = ?, mdr_pat_prescr = ? WHERE mdr_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssssssi', $mrd_number, $pat_name, $pat_adr, $pat_age, $pat_ailment, $pat_number, $pat_prescr, $mrd_id);
    
    if ($stmt->execute()) {
        $success = "Medical record updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $mrd_id = $_GET['delete'];
    $query = "DELETE FROM his_medical_records WHERE mdr_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $mrd_id);
    
    if ($stmt->execute()) {
        $success = "Medical record deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Handle PDF generation requests
if (isset($_GET['generate_invoice'])) {
    generatePDF($_GET['generate_invoice'], 'invoice');
}

if (isset($_GET['generate_report'])) {
    generatePDF($_GET['generate_report'], 'report');
}

if (isset($_GET['generate_combined'])) {
    generateCombinedPDF($_GET['generate_combined']);
}

// Get all medical records
$medical_records = [];
$ret = "SELECT * FROM his_medical_records ORDER BY mdr_date_rec DESC";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($record = $res->fetch_object()) {
    $medical_records[] = $record;
}

// Get patients for dropdown
$patients = [];
$ret = "SELECT pat_id, pat_fname, pat_lname, pat_number FROM his_patients ORDER BY pat_fname";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($patient = $res->fetch_object()) {
    $patients[] = $patient;
}

// Get specific medical record for editing
$edit_record = null;
if (isset($_GET['edit'])) {
    $mrd_id = $_GET['edit'];
    $ret = "SELECT * FROM his_medical_records WHERE mdr_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $mrd_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_record = $res->fetch_object();
}

// Generate unique MRD number
function generateMrdNumber() {
    return substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 5);
}

// PDF Generation Functions
function generatePDF($mrd_id, $type) {
    global $mysqli;
    
    require_once 'vendor/autoload.php';
    $dompdf = new Dompdf\Dompdf();
    
    $ret = "SELECT * FROM his_medical_records WHERE mdr_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $mrd_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $record = $res->fetch_object();
    
    if ($type == 'invoice') {
        $html = generateInvoiceHTML($record);
        $filename = "Invoice_{$record->mrd_number}.pdf";
    } else {
        $html = generateReportHTML($record);
        $filename = "Medical_Report_{$record->mrd_number}.pdf";
    }
    
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    
    $dompdf->stream($filename, array("Attachment" => true));
    exit;
}

function generateCombinedPDF($mrd_id) {
    global $mysqli;
    
    require_once 'vendor/autoload.php';
    $dompdf = new Dompdf\Dompdf();
    
    $ret = "SELECT * FROM his_medical_records WHERE mdr_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $mrd_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $record = $res->fetch_object();
    
    $html = generateInvoiceHTML($record) . '<div style="page-break-before: always;"></div>' . generateReportHTML($record);
    
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    
    $filename = "Combined_{$record->mrd_number}.pdf";
    $dompdf->stream($filename, array("Attachment" => true));
    exit;
}

function generateInvoiceHTML($record) {
    $html = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="utf-8">
        <title>Invoice - ' . $record->mrd_number . '</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 40px; }
            .header { text-align: center; margin-bottom: 30px; }
            .section { margin-bottom: 20px; }
            .bordered { border: 1px solid #000; padding: 15px; margin: 10px 0; }
            table { width: 100%; border-collapse: collapse; }
            th, td { border: 1px solid #000; padding: 8px; text-align: left; }
            .text-right { text-align: right; }
            .total { font-weight: bold; }
        </style>
    </head>
    <body>
        <div class="header">
            <h1>MEDICAL INVOICE</h1>
            <p>Invoice #: ' . $record->mrd_number . '</p>
            <p>Date: ' . date('M d, Y', strtotime($record->mdr_date_rec)) . '</p>
        </div>
        
        <div class="section">
            <h3>Patient Information</h3>
            <div class="bordered">
                <p><strong>Name:</strong> ' . $record->mdr_pat_name . '</p>
                <p><strong>Age:</strong> ' . $record->mdr_pat_age . '</p>
                <p><strong>Address:</strong> ' . $record->mdr_pat_adr . '</p>
                <p><strong>Patient ID:</strong> ' . $record->mdr_pat_number . '</p>
            </div>
        </div>
        
        <div class="section">
            <h3>Billing Details</h3>
            <table>
                <thead>
                    <tr>
                        <th>Description</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Consultation Fee</td>
                        <td>1</td>
                        <td>$50.00</td>
                        <td>$50.00</td>
                    </tr>
                    <tr>
                        <td>Medical Treatment</td>
                        <td>1</td>
                        <td>$75.00</td>
                        <td>$75.00</td>
                    </tr>
                    <tr>
                        <td>Medication</td>
                        <td>1</td>
                        <td>$35.00</td>
                        <td>$35.00</td>
                    </tr>
                    <tr class="total">
                        <td colspan="3" class="text-right">Total Amount:</td>
                        <td>$160.00</td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="section">
            <p><strong>Payment Terms:</strong> Due upon receipt</p>
            <p><strong>Thank you for your business!</strong></p>
        </div>
    </body>
    </html>';
    
    return $html;
}

function generateReportHTML($record) {
    $html = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="utf-8">
        <title>Medical Report - ' . $record->mrd_number . '</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 40px; }
            .header { text-align: center; margin-bottom: 30px; }
            .section { margin-bottom: 20px; }
            .bordered { border: 1px solid #000; padding: 15px; margin: 10px 0; }
            .diagnosis { background-color: #f5f5f5; padding: 15px; }
        </style>
    </head>
    <body>
        <div class="header">
            <h1>MEDICAL REPORT</h1>
            <p>Report #: ' . $record->mrd_number . '</p>
            <p>Date: ' . date('M d, Y', strtotime($record->mdr_date_rec)) . '</p>
        </div>
        
        <div class="section">
            <h3>Patient Information</h3>
            <div class="bordered">
                <p><strong>Name:</strong> ' . $record->mdr_pat_name . '</p>
                <p><strong>Age:</strong> ' . $record->mdr_pat_age . '</p>
                <p><strong>Address:</strong> ' . $record->mdr_pat_adr . '</p>
                <p><strong>Patient ID:</strong> ' . $record->mdr_pat_number . '</p>
            </div>
        </div>
        
        <div class="section">
            <h3>Diagnosis</h3>
            <div class="diagnosis">
                <p><strong>Ailment:</strong> ' . $record->mdr_pat_ailment . '</p>
                <p><strong>Date of Diagnosis:</strong> ' . date('M d, Y', strtotime($record->mdr_date_rec)) . '</p>
            </div>
        </div>
        
        <div class="section">
            <h3>Treatment Plan</h3>
            <div class="bordered">
                ' . nl2br(htmlspecialchars($record->mdr_pat_prescr)) . '
            </div>
        </div>
        
        <div class="section">
            <h3>Doctor\'s Notes</h3>
            <p>Patient presented with symptoms consistent with the diagnosed condition. The prescribed treatment plan should be followed diligently. Follow-up appointment recommended in two weeks.</p>
        </div>
        
        <div class="section">
            <p><strong>Doctor\'s Signature:</strong> _________________________</p>
            <p><strong>Date:</strong> ' . date('M d, Y') . '</p>
        </div>
    </body>
    </html>';
    
    return $html;
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Medical Records</a></li>
                                        <li class="breadcrumb-item active">M.R.D Management</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Medical Records Department (M.R.D)</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_record) ? 'Edit Medical Record' : 'Add New Medical Record'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_record)) { ?>
                                            <input type="hidden" name="mrd_id" value="<?php echo $edit_record->mdr_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="mrd_number">MRD Number *</label>
                                                    <input type="text" class="form-control" id="mrd_number" name="mrd_number" value="<?php echo isset($edit_record) ? $edit_record->mrd_number : generateMrdNumber(); ?>" required readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_number">Patient *</label>
                                                    <select class="form-control" id="pat_number" name="pat_number" required onchange="fetchPatientDetails(this.value)">
                                                        <option value="">Select Patient</option>
                                                        <?php foreach ($patients as $patient) { 
                                                            $fullName = $patient->pat_fname . ' ' . $patient->pat_lname;
                                                        ?>
                                                            <option value="<?php echo $patient->pat_number; ?>" <?php echo (isset($edit_record) && $edit_record->mdr_pat_number == $patient->pat_number) ? 'selected' : ''; ?>>
                                                                <?php echo $fullName . ' (' . $patient->pat_number . ')'; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_name">Patient Name *</label>
                                                    <input type="text" class="form-control" id="pat_name" name="pat_name" value="<?php echo isset($edit_record) ? $edit_record->mdr_pat_name : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_age">Patient Age *</label>
                                                    <input type="number" class="form-control" id="pat_age" name="pat_age" value="<?php echo isset($edit_record) ? $edit_record->mdr_pat_age : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_adr">Patient Address *</label>
                                                    <textarea class="form-control" id="pat_adr" name="pat_adr" rows="2" required><?php echo isset($edit_record) ? $edit_record->mdr_pat_adr : ''; ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pat_ailment">Ailment/Diagnosis *</label>
                                                    <input type="text" class="form-control" id="pat_ailment" name="pat_ailment" value="<?php echo isset($edit_record) ? $edit_record->mdr_pat_ailment : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="pat_prescr">Prescription/Treatment *</label>
                                            <textarea class="form-control" id="pat_prescr" name="pat_prescr" rows="4" required><?php echo isset($edit_record) ? $edit_record->mdr_pat_prescr : ''; ?></textarea>
                                        </div>
                                        <?php if(isset($edit_record)) { ?>
                                            <button type="submit" name="update_mrd" class="btn btn-primary">Update Record</button>
                                            <a href="mrd.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_mrd" class="btn btn-success">Add Record</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Medical Records</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>MRD Number</th>
                                                <th>Patient Name</th>
                                                <th>Age</th>
                                                <th>Ailment</th>
                                                <th>Patient Number</th>
                                                <th>Date Recorded</th>
                                                <th>Actions</th>
                                                <th>PDF Export</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($medical_records as $record) { ?>
                                                <tr>
                                                    <td>#</td>
                                                    <td><?php echo $record->mdr_pat_name; ?></td>
                                                    <td><?php echo $record->mdr_pat_age; ?></td>
                                                    <td><?php echo $record->mdr_pat_ailment; ?></td>
                                                    <td><?php echo $record->mdr_pat_number; ?></td>
                                                    <td><?php echo date('M d, Y h:i A', strtotime($record->mdr_date_rec)); ?></td>
                                                    <td>
                                                        <a href="mrd.php?edit=<?php echo $record->mdr_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="mrd.php?delete=<?php echo $record->mdr_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this medical record?')">Delete</a>
                                                        <a href="mrd-view.php?id=<?php echo $record->mdr_id; ?>" class="btn btn-sm btn-info">View</a>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="mrd.php?generate_invoice=<?php echo $record->mdr_id; ?>" class="btn btn-sm btn-warning">Invoice</a>
                                                            <a href="mrd.php?generate_report=<?php echo $record->mdr_id; ?>" class="btn btn-sm btn-success">Report</a>
                                                            <a href="mrd.php?generate_combined=<?php echo $record->mdr_id; ?>" class="btn btn-sm btn-primary">Combined</a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <script>
    function fetchPatientDetails(patientNumber) {
        if (patientNumber) {
            // AJAX request to fetch patient details
            fetch('get_patient_details.php?pat_number=' + patientNumber)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('pat_name').value = data.patient.pat_fname + ' ' + data.patient.pat_lname;
                        document.getElementById('pat_age').value = data.patient.pat_age;
                        document.getElementById('pat_adr').value = data.patient.pat_addr;
                    }
                })
                .catch(error => console.error('Error:', error));
        }
    }
    </script>
</body>
</html>