<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['delete']))
  {
        $id=intval($_GET['delete']);
        $adn="delete from his_patients where pat_id=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();  
  
          if($stmt)
          {
            $success = "Patient Records Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <meta charset="utf-8">
    <title>OPD Patients Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description">
    <meta content="Coderthemes" name="author">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- Bootstrap css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <!-- App css -->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css">
    <!-- icons -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css">
    <!-- Footable css -->
    <link href="assets/libs/footable/footable.core.min.css" rel="stylesheet" type="text/css">
    
    <style>
        body {
            background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%);
            font-family: 'Poppins', sans-serif;
        }
        
        .opd-header {
            background: linear-gradient(45deg, #11998e 0%, #38ef7d 100%);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 8px 20px rgba(17, 153, 142, 0.2);
            color: white;
            margin-bottom: 25px;
        }
        
        .card-opd {
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
            overflow: hidden;
            border-left: 4px solid #11998e;
        }
        
        .table-opd thead {
            background: linear-gradient(to right, #11998e, #38ef7d);
            color: white;
        }
        
        .badge-opd {
            background: linear-gradient(to right, #11998e, #38ef7d);
            padding: 5px 12px;
            font-size: 12px;
        }
        
        .search-box {
            position: relative;
        }
        
        .search-box .fas {
            position: absolute;
            left: 15px;
            top: 10px;
            color: #6c757d;
        }
        
        .search-box input {
            border-radius: 8px;
            border: 1px solid #d1d3e2;
            padding-left: 35px;
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box opd-header">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                        <li class="breadcrumb-item active" style="color: white; font-weight: 600;">OPD Patients</li>
                                    </ol>
                                </div>
                                <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                    <i class="fas fa-user-md mr-2"></i>Outpatient Department (OPD) Management
                                </h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box card-opd">
                                <h4 class="header-title mb-4" style="color: #11998e; font-weight: 600; padding-left: 10px;">
                                    <i class="fas fa-clipboard-list mr-2"></i>OPD Patient Records
                                </h4>
                                
                                <div class="mb-3">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group search-box">
                                                <i class="fas fa-search"></i>
                                                <input id="demo-foo-search-opd" type="text" placeholder="Search OPD patients..." class="form-control form-control-sm" autocomplete="on" style="width: 250px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering-opd" class="table table-bordered toggle-circle mb-0" data-page-size="7">
                                        <thead>
                                        <tr>
                                            <th style="border: none; padding: 15px 10px;">#</th>
                                            <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient Name</th>
                                            <th data-hide="phone" style="border: none; padding: 15px 10px;">Phone Number</th>
                                            <th data-hide="phone" style="border: none; padding: 15px 10px;">Address</th>
                                            <th data-hide="phone" style="border: none; padding: 15px 10px;">Last Visit</th>
                                            <th data-hide="phone" style="border: none; padding: 15px 10px;">Visits</th>
                                            <th data-hide="phone" style="border: none; padding: 15px 10px;">Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                            // Fetch only OPD patients from the database
                                            $ret = "SELECT * FROM his_patients WHERE pat_type = 'OutPatient' ORDER BY pat_id DESC"; 
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            
                                            while($row = $res->fetch_object()) {
                                        ?>
                                            <tr>
                                                <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt; ?></td>
                                                <td style="padding: 15px 10px; border: none; font-weight: 600; color: #11998e;">
                                                    <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname; ?> <?php echo $row->pat_lname; ?>
                                                </td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number; ?></td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_addr; ?></td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                    <?php 
                                                        // Generate a random date for last visit (for demonstration)
                                                        echo date("Y-m-d", strtotime("-" . rand(1, 30) . " days")); 
                                                    ?>
                                                </td>
                                                <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                    <?php echo rand(1, 10); ?> visits
                                                </td>
                                                <td style="padding: 15px 10px; border: none;">
                                                    <div class="btn-group" role="group">
                                                        <a href="manage_patient.php?delete=<?php echo $row->pat_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this patient?')">
                                                            <i class="mdi mdi-trash-can-outline"></i> Delete
                                                        </a>
                                                        <a href="view_single_patient.php?pat_id=<?php echo $row->pat_id; ?>&pat_number=<?php echo $row->pat_number; ?>" class="btn btn-sm btn-success">
                                                            <i class="mdi mdi-eye"></i> View
                                                        </a>
                                                        <a href="update_single_patient.php?pat_id=<?php echo $row->pat_id; ?>" class="btn btn-sm btn-primary">
                                                            <i class="mdi mdi-pencil-outline"></i> Edit
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php 
                                            $cnt++;
                                            } 
                                        ?>
                                        </tbody>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="7">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php'); ?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <script>
    $(document).ready(function() {
        // Initialize footable for OPD table
        $('#demo-foo-filtering-opd').footable();
        
        // Search functionality for OPD patients
        $('#demo-foo-search-opd').keyup(function() {
            $('#demo-foo-filtering-opd').trigger('footable_filter', {filter: $(this).val()});
        });
    });
    </script>
    
</body>
</html>