<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_ailment'])) {
    $ailment_name = $_POST['ailment_name'];
    $fee = $_POST['fee'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_patient_ailments (ailment_name, fee, description, status) VALUES (?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sdss', $ailment_name, $fee, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Ailment added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_ailment'])) {
    $ailment_id = $_POST['ailment_id'];
    $ailment_name = $_POST['ailment_name'];
    $fee = $_POST['fee'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_patient_ailments SET ailment_name = ?, fee = ?, description = ?, status = ? WHERE ailment_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sdssi', $ailment_name, $fee, $description, $status, $ailment_id);
    
    if ($stmt->execute()) {
        $success = "Ailment updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $ailment_id = $_GET['delete'];
    $query = "DELETE FROM his_patient_ailments WHERE ailment_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $ailment_id);
    
    if ($stmt->execute()) {
        $success = "Ailment deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all ailments
$ailments = [];
$ret = "SELECT * FROM his_patient_ailments ORDER BY ailment_name";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($ailment = $res->fetch_object()) {
    $ailments[] = $ailment;
}

// Get specific ailment for editing
$edit_ailment = null;
if (isset($_GET['edit'])) {
    $ailment_id = $_GET['edit'];
    $ret = "SELECT * FROM his_patient_ailments WHERE ailment_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $ailment_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_ailment = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Patient Management</a></li>
                                        <li class="breadcrumb-item active">Patient Ailments</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Patient Ailments</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_ailment) ? 'Edit Ailment' : 'Add New Ailment'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_ailment)) { ?>
                                            <input type="hidden" name="ailment_id" value="<?php echo $edit_ailment->ailment_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ailment_name">Ailment Name *</label>
                                                    <input type="text" class="form-control" id="ailment_name" name="ailment_name" value="<?php echo isset($edit_ailment) ? $edit_ailment->ailment_name : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="fee">Fee *</label>
                                                    <input type="number" step="0.01" class="form-control" id="fee" name="fee" value="<?php echo isset($edit_ailment) ? $edit_ailment->fee : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo isset($edit_ailment) ? $edit_ailment->description : ''; ?></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="status">Status</label>
                                            <select class="form-control" id="status" name="status" required>
                                                <option value="Active" <?php echo (isset($edit_ailment) && $edit_ailment->status == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                <option value="Inactive" <?php echo (isset($edit_ailment) && $edit_ailment->status == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                            </select>
                                        </div>
                                        <?php if(isset($edit_ailment)) { ?>
                                            <button type="submit" name="update_ailment" class="btn btn-primary">Update Ailment</button>
                                            <a href="patient_ailments.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_ailment" class="btn btn-success">Add Ailment</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Ailments</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Ailment Name</th>
                                                <th>Fee</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($ailments as $ailment) { ?>
                                                <tr>
                                                    <td><?php echo $ailment->ailment_name; ?></td>
                                                    <td><?php echo number_format($ailment->fee, 2); ?></td>
                                                    <td><?php echo $ailment->description; ?></td>
                                                    <td><span class="badge badge-<?php echo $ailment->status == 'Active' ? 'success' : 'danger'; ?>"><?php echo $ailment->status; ?></span></td>
                                                    <td>
                                                        <a href="patient_ailments.php?edit=<?php echo $ailment->ailment_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="patient_ailments.php?delete=<?php echo $ailment->ailment_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this ailment?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>