<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box bg-gradient-primary animated fadeInDown">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                            <li class="breadcrumb-item active text-white">Add Laboratory Test</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title text-white" style="font-size: 1.8rem;">Laboratory Test Management</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <!-- Category Tabs -->
                        <div class="row mb-3 animated fadeIn">
                            <div class="col-12">
                                <ul class="nav nav-tabs nav-justified bg-light" id="patientTabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active font-weight-bold" id="all-tab" data-toggle="tab" href="#all" role="tab" style="font-size: 1.1rem;">
                                            <i class="mdi mdi-account-multiple mr-1"></i> All Patients
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link font-weight-bold" id="inpatient-tab" data-toggle="tab" href="#inpatient" role="tab" style="font-size: 1.1rem;">
                                            <i class="mdi mdi-hospital-building mr-1"></i> In Patients
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link font-weight-bold" id="outpatient-tab" data-toggle="tab" href="#outpatient" role="tab" style="font-size: 1.1rem;">
                                            <i class="mdi mdi-account-arrow-right mr-1"></i> Out Patients
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="row animated fadeInUp">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h4 class="header-title" style="font-size: 1.3rem;">Patient Records</h4>
                                        <div class="btn-group float-right">
                                            <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fas fa-download mr-1"></i> Export
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="#" onclick="exportToExcel()">Excel</a>
                                                <a class="dropdown-item" href="#" onclick="exportToCSV()">CSV</a>
                                                <a class="dropdown-item" href="#" onclick="exportToPDF()">PDF</a>
                                                <a class="dropdown-item" href="#" onclick="printTable()">Print</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="tab-content" id="patientTabsContent">
                                            <div class="tab-pane fade show active" id="all" role="tabpanel">
                                                <?php includePatientTable(""); ?>
                                            </div>
                                            <div class="tab-pane fade" id="inpatient" role="tabpanel">
                                                <?php includePatientTable("InPatients"); ?>
                                            </div>
                                            <div class="tab-pane fade" id="outpatient" role="tabpanel">
                                                <?php includePatientTable("OutPatients"); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <!-- Export functionality -->
        <script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/file-saver@2.0.5/dist/FileSaver.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.25/jspdf.plugin.autotable.min.js"></script>
        
        <style>
            /* Animation Classes */
            .animated {
                animation-duration: 0.5s;
                animation-fill-mode: both;
            }
            @keyframes fadeIn {
                from { opacity: 0; }
                to { opacity: 1; }
            }
            @keyframes fadeInDown {
                from { 
                    opacity: 0; 
                    transform: translateY(-20px);
                }
                to { 
                    opacity: 1; 
                    transform: translateY(0);
                }
            }
            @keyframes fadeInUp {
                from { 
                    opacity: 0; 
                    transform: translateY(20px);
                }
                to { 
                    opacity: 1; 
                    transform: translateY(0);
                }
            }
            .fadeIn { animation-name: fadeIn; }
            .fadeInDown { animation-name: fadeInDown; }
            .fadeInUp { animation-name: fadeInUp; }
            
            /* Color Scheme */
            .bg-gradient-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                border-radius: 0.25rem;
                box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(102, 126, 234, .4);
            }
            
            /* Card Styling */
            .card {
                border: none;
                box-shadow: 0 1px 15px rgba(0,0,0,0.1);
                transition: transform 0.3s ease, box-shadow 0.3s ease;
            }
            .card:hover {
                transform: translateY(-5px);
                box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            }
            
            /* Table Styling */
            .table-hover tbody tr {
                transition: all 0.3s ease;
            }
            .table-hover tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.1);
                transform: scale(1.01);
            }
            
            /* Badge Styling */
            .badge-inpatient {
                background-color: #5b69bc;
                color: white;
                animation: pulse 2s infinite;
            }
            .badge-outpatient {
                background-color: #0acf97;
                color: white;
            }
            
            @keyframes pulse {
                0% { box-shadow: 0 0 0 0 rgba(91, 105, 188, 0.7); }
                70% { box-shadow: 0 0 0 10px rgba(91, 105, 188, 0); }
                100% { box-shadow: 0 0 0 0 rgba(91, 105, 188, 0); }
            }
            
            /* Button Styling */
            .btn-test {
                font-size: 0.9rem;
                transition: all 0.3s ease;
            }
            .btn-test:hover {
                transform: translateY(-2px);
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            }
            
            /* Tab Styling */
            .nav-tabs .nav-link {
                font-size: 1rem;
                transition: all 0.3s ease;
            }
            .nav-tabs .nav-link:hover {
                transform: translateY(-2px);
            }
            .nav-tabs .nav-link.active {
                font-weight: bold;
                border-bottom: 3px solid #667eea;
            }
            
            @media print {
                body * {
                    visibility: hidden;
                }
                .card, .card * {
                    visibility: visible;
                }
                .card {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    border: none;
                    box-shadow: none;
                }
                .no-print, .dropdown-menu, .btn-group, .nav-tabs {
                    display: none !important;
                }
            }
        </style>
        
        <script>
            // Export to Excel function
            function exportToExcel() {
                const activeTable = document.querySelector('.tab-pane.active table');
                const wb = XLSX.utils.table_to_book(activeTable, {sheet:"Patient Data"});
                XLSX.writeFile(wb, "Lab_Patients.xlsx");
            }
            
            // Export to CSV function
            function exportToCSV() {
                const activeTable = document.querySelector('.tab-pane.active table');
                const ws = XLSX.utils.table_to_sheet(activeTable);
                const csv = XLSX.utils.sheet_to_csv(ws);
                const blob = new Blob([csv], {type: "text/csv;charset=utf-8;"});
                saveAs(blob, "Lab_Patients.csv");
            }
            
            // Export to PDF function
            function exportToPDF() {
                const { jsPDF } = window.jspdf;
                const doc = new jsPDF();
                const activeTable = document.querySelector('.tab-pane.active table');
                
                doc.autoTable({
                    html: activeTable,
                    theme: 'grid',
                    headStyles: {
                        fillColor: [102, 126, 234],
                        textColor: 255
                    },
                    styles: {
                        cellPadding: 3,
                        fontSize: 10,
                        valign: 'middle'
                    },
                    margin: { top: 20 },
                    didDrawPage: function (data) {
                        doc.text('Laboratory Patient Records', data.settings.margin.left, 10);
                    }
                });
                
                doc.save('Lab_Patients.pdf');
            }
            
            // Print function
            function printTable() {
                window.print();
            }
            
            // Initialize footable for each tab
            $(document).ready(function() {
                $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
                    $($(e.target).attr('href')).find('table').trigger('footable_redraw');
                });
            });
        </script>
    </body>
</html>

<?php
function includePatientTable($type = "") {
    global $mysqli;
    
    $query = "SELECT * FROM his_patients";
    if ($type) {
        $query .= " WHERE pat_type = '$type'";
    }
    $query .= " ORDER BY pat_fname ASC";
    
    $stmt = $mysqli->prepare($query);
    $stmt->execute();
    $res = $stmt->get_result();
    $cnt = 1;
?>
<div class="mb-2">
    <div class="row">
        <div class="col-12">
            <input type="text" placeholder="Search in <?php echo $type ? $type : 'All'; ?> patients..." class="form-control search-input" data-table="patients-<?php echo strtolower($type ?: 'all'); ?>">
        </div>
    </div>
</div>
<div class="table-responsive">
    <table class="table table-hover table-bordered toggle-circle mb-0 patients-<?php echo strtolower($type ?: 'all'); ?>" data-page-size="10">
        <thead class="thead-light">
        <tr>
            <th>#</th>
            <th data-toggle="true">Patient Name</th>
            <th data-hide="phone">Patient Number</th>
            <th data-hide="phone">Patient Address</th>
            <th data-hide="phone">Patient Ailment</th>
            <th data-hide="phone">Patient Age</th>
            <th data-hide="phone">Patient Category</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        <?php while($row = $res->fetch_object()): ?>
        <tr>
            <td><?php echo $cnt; ?></td>
            <td style="font-size: 1.05rem;"><?php echo $row->pat_fname; ?> <?php echo $row->pat_lname; ?></td>
            <td><?php echo $row->pat_number; ?></td>
            <td><?php echo $row->pat_addr; ?></td>
            <td><?php echo $row->pat_ailment; ?></td>
            <td><?php echo $row->pat_age; ?> Years</td>
            <td>
                <span class="badge <?php echo $row->pat_type == 'InPatients' ? 'badge-inpatient' : 'badge-outpatient'; ?>">
                    <?php echo $row->pat_type; ?>
                </span>
            </td>
            <td>
                <a href="add_single_lab_test.php?pat_number=<?php echo $row->pat_number; ?>" class="btn btn-sm btn-success btn-test">
                    <i class="mdi mdi-beaker mr-1"></i> Add Test
                </a>
            </td>
        </tr>
        <?php $cnt++; endwhile; ?>
        </tbody>
        <tfoot>
        <tr class="active">
            <td colspan="8">
                <div class="text-right">
                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                </div>
            </td>
        </tr>
        </tfoot>
    </table>
</div>
<?php
}
?>