<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Custom CSS */
        .card-box {
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            padding: 20px;
        }
        .table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .table th {
            background-color: #f8f9fa;
            color: #495057;
            font-weight: 600;
            border-top: 1px solid #dee2e6;
        }
        .table td, .table th {
            padding: 12px 15px;
            vertical-align: middle;
            border-bottom: 1px solid #dee2e6;
        }
        .table tbody tr:hover {
            background-color: rgba(0, 0, 0, 0.02);
        }
        .badge-success {
            background-color: #28a745;
            padding: 8px 12px;
            border-radius: 4px;
            font-weight: 500;
            transition: all 0.3s;
        }
        .badge-success:hover {
            background-color: #218838;
            transform: translateY(-2px);
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }
        .badge-success i {
            margin-right: 5px;
        }
        .page-title {
            color: #2c3e50;
            font-weight: 700;
        }
        .form-control-sm {
            border-radius: 4px;
            padding: 5px 10px;
        }
        .pagination-rounded .page-item.active .page-link {
            background-color: #28a745;
            border-color: #28a745;
        }
        .pagination-rounded .page-link {
            color: #28a745;
            border-radius: 50% !important;
            margin: 0 3px;
            width: 36px;
            height: 36px;
            text-align: center;
            line-height: 24px;
        }
        .search-box {
            position: relative;
            margin-bottom: 20px;
        }
        .search-box .form-control {
            padding-left: 40px;
            border-radius: 20px;
        }
        .search-box i {
            position: absolute;
            left: 15px;
            top: 10px;
            color: #6c757d;
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                        <li class="breadcrumb-item active">Patient Vitals</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Patient Vitals</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <h4 class="header-title mb-3">Patient List</h4>
                                
                                <!-- Search Box -->
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="search-box">
                                            <i class="fas fa-search"></i>
                                            <input id="demo-foo-search" type="text" placeholder="Search patients..." class="form-control form-control-sm" autocomplete="on">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-hover table-centered mb-0" data-page-size="7">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Patient Name</th>
                                                <th data-hide="phone">Patient Number</th>
                                                <th data-hide="phone">Address</th>
                                                <th data-hide="phone">Ailment</th>
                                                <th data-hide="phone">Age</th>
                                                <th data-hide="phone">Category</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $ret = "SELECT * FROM his_patients ORDER BY RAND()";
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()):
                                            ?>
                                            <tr>
                                                <td><?php echo $cnt; ?></td>
                                                <td><?php echo htmlspecialchars($row->pat_fname) . ' ' . htmlspecialchars($row->pat_lname); ?></td>
                                                <td><?php echo htmlspecialchars($row->pat_number); ?></td>
                                                <td><?php echo htmlspecialchars($row->pat_addr); ?></td>
                                                <td><?php echo htmlspecialchars($row->pat_ailment); ?></td>
                                                <td><?php echo htmlspecialchars($row->pat_age); ?> Years</td>
                                                <td>
                                                    <span class="badge 
                                                        <?php echo $row->pat_type == 'InPatients' ? 'badge-primary' : 'badge-info'; ?>">
                                                        <?php echo htmlspecialchars($row->pat_type); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="add_single_patient_vitals.php?pat_number=<?php echo $row->pat_number; ?>" 
                                                       class="badge badge-success">
                                                       <i class="mdi mdi-beaker"></i> Capture Vitals
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php 
                                            $cnt++;
                                            endwhile; 
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="8">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- FontAwesome for search icon -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>