<?php
error_reporting(0);
session_start();
include('assets/inc/config.php');
require_once 'vendor/autoload.php'; // make sure dompdf is installed via composer

use Dompdf\Dompdf;

if(isset($_GET['pat_id'])) {
    $pat_id = intval($_GET['pat_id']); 
    
    // Fetch patient
    $query = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $patient = $result->fetch_assoc();

    if(!$patient){
        die("Patient not found.");
    }

    // Fetch doctor
    $doctor = null;
    if (!empty($patient['doc_id'])) {
        $doc_query = "SELECT * FROM his_docs WHERE doc_id = ?";
        $doc_stmt = $mysqli->prepare($doc_query);
        $doc_stmt->bind_param('s', $patient['doc_id']);
        $doc_stmt->execute();
        $doc_result = $doc_stmt->get_result();
        $doctor = $doc_result->fetch_assoc();
    }

    // Fetch system settings
    $settings_query = "SELECT * FROM his_system_settings LIMIT 1";
    $settings_result = $mysqli->query($settings_query);
    $settings = $settings_result->fetch_assoc();

    // Build HTML
    $html = '
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; margin: 20px; background: #f9f9f9; }
            .header { text-align: center; margin-bottom: 20px; border-bottom: 4px solid #007BFF; padding-bottom: 10px; }
            .hospital-name { font-size: 28px; font-weight: bold; color: #007BFF; }
            .header small { color: #555; }
            
            h2 { color: #28a745; border-bottom: 2px solid #28a745; padding-bottom: 5px; }
            h3 { color: #17a2b8; border-left: 5px solid #17a2b8; padding-left: 8px; }

            .patient-details { width: 100%; border-collapse: collapse; margin-bottom: 20px; background: #fff; }
            .patient-details th, .patient-details td { border: 1px solid #ccc; padding: 10px; text-align: left; }
            .patient-details th { background-color: #007BFF; color: #fff; }
            .patient-details tr:nth-child(even) { background-color: #f2f2f2; }

            .footer { margin-top: 30px; text-align: right; font-size: 12px; color: #666; }
        </style>
    </head>
    <body>
        <div class="header">
            <div class="hospital-name">'.htmlspecialchars($settings['system_name']).'</div>
            <small>'.htmlspecialchars($settings['system_address']).' | Tel: '.htmlspecialchars($settings['system_phone']).'</small>
        </div>
        
        <h2>Patient Details</h2>
        <table class="patient-details">
            <tr>
                <th>Name</th>
                <td>'.htmlspecialchars($patient['title'].' '.$patient['pat_fname'].' '.$patient['pat_lname']).'</td>
                <th>Registration Date</th>
                <td>'.date('d-M-Y', strtotime($patient['pat_date_joined'])).'</td>
            </tr>
            <tr>
                <th>Age / Gender / Aadhar</th>
                <td>'.htmlspecialchars($patient['pat_age'].' / '.$patient['gender'].' / '.$patient['card_no']).'</td>
                <th>Department</th>
                <td>'.htmlspecialchars($patient['dept']).'</td>
            </tr>
            <tr>
                <th>Mobile No</th>
                <td>'.htmlspecialchars($patient['pat_phone']).'</td>
                <th>Doctor</th>
                <td>'.($doctor ? htmlspecialchars($doctor['doc_fname'].' '.$doctor['doc_lname']) : 'N/A').'</td>
            </tr>
            <tr>
                <th>UHID</th>
                <td>PCHS/'.date('y').'/'.sprintf('%05d', $patient['pat_id']).'</td>
                <th>Patient Type</th>
                <td>'.htmlspecialchars($patient['pat_type']).'</td>
            </tr>
            <tr>
                <th>Clinical History</th>
                <td colspan="3">'.nl2br(htmlspecialchars($patient['pat_ailment'])).'</td>
            </tr>
            <tr>
                <th>Address</th>
                <td colspan="3">'.htmlspecialchars($patient['pat_addr']).'</td>
            </tr>
            <tr>
                <th>Insurance Company</th>
                <td colspan="3">'.($patient['insurance'] ? htmlspecialchars($patient['insurance']) : '<span style="color:red;">No Scheme</span>').'</td>
            </tr>
        </table>
        
        <h3>Vitals</h3>
        <table class="patient-details">
            <tr>
                <th>Temperature</th><td>..</td>
                <th>Blood Pressure</th><td>..</td>
            </tr>
            <tr>
                <th>SPO2</th><td>..</td>
                <th>Pulse</th><td>..</td>
            </tr>
            <tr>
                <th>Height</th><td>..</td>
                <th>Weight</th><td>..</td>
            </tr>
        </table>
        
        <div class="footer">
            <p>Generated on: '.date('d-M-Y H:i').'</p>
        </div>
    </body>
    </html>';

    // Initialize Dompdf
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);

    // Setup paper size and orientation
    $dompdf->setPaper('A4', 'portrait');

    // Render the HTML as PDF
    $dompdf->render();

    // Output the generated PDF (inline in browser)
    $dompdf->stream("patient_".$patient['pat_id'].".pdf", ["Attachment" => false]);
} else {
    die("Invalid Request.");
}
