<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'vendor/autoload.php'; // mPDF
session_start();
include('assets/inc/config.php');

$patient_id = $_GET['pat_id'] ?? null;

// Patient
$patient = null;
if ($patient_id) {
    $stmt = $mysqli->prepare("SELECT * FROM his_patients WHERE pat_id = ?");
    $stmt->bind_param('i', $patient_id);
    $stmt->execute();
    $patient = $stmt->get_result()->fetch_assoc();
}

// Settings
$settings = $mysqli->query("SELECT * FROM his_system_settings WHERE id = 1")->fetch_assoc();

// Doctor
$doctor = null;
if (!empty($patient['doc_id'])) {
    $doc_stmt = $mysqli->prepare("SELECT * FROM his_docs WHERE doc_id = ?");
    $doc_stmt->bind_param('i', $patient['doc_id']);
    $doc_stmt->execute();
    $doctor = $doc_stmt->get_result()->fetch_assoc();
}

// Prescription
$prescription = null;
if ($patient) {
    $pres_stmt = $mysqli->prepare("SELECT * FROM his_prescriptions WHERE pres_pat_number = ? ORDER BY pres_date DESC LIMIT 1");
    $pres_stmt->bind_param('s', $patient['pat_number']);
    $pres_stmt->execute();
    $prescription = $pres_stmt->get_result()->fetch_assoc();
}

// Vitals
$vitals = null;
if ($patient) {
    $vit_stmt = $mysqli->prepare("SELECT * FROM his_vitals WHERE vit_pat_number = ? ORDER BY vit_daterec DESC LIMIT 1");
    $vit_stmt->bind_param('s', $patient['pat_number']);
    $vit_stmt->execute();
    $vitals = $vit_stmt->get_result()->fetch_assoc();
}

// Prepare logo path
$logo = htmlspecialchars($settings['system_logo']); // from DB
// absolute path for mPDF (important!)
$logoPath = (strpos($logo, 'http') === 0) ? $logo : __DIR__ . '/' . ltrim($logo, '/');

// mPDF init
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'default_font_size' => 10,
    'default_font' => 'helvetica',
    'margin_left' => 10,
    'margin_right' => 10,
    'margin_top' => 10,
    'margin_bottom' => 40,
    'margin_header' => 5,
    'margin_footer' => 15
]);

// WATERMARK (optional faint logo)$mpdf->SetWatermarkImage($logo, 1.0, '', [0, 0], true);  // now 8% of page width
$mpdf->showWatermarkImage = true;

// FOOTER NOTE
$footerHTML = '
<div style="
background: linear-gradient(to right, #0d6efd, #00b4d8);
color: #fff; 
padding:8px; 
font-size:9pt; 
text-align:center;">
<strong>NOTE:</strong> 
*OD : One time a day | 
*BD : Two times a day | 
*TDS : Three Times a day | 
*QID : Four times a day | 
*HS : Night one time a day | 
*A/D : One time alternate day | 
*ODAC: Morning one time a day empty stomach | 
*SOS : Emergency as and when needed | 
*LE : Left Eye | 
*RE : Right Eye | 
*BE : Both Eye | 
*NA : Not Applicable
</div>';
$mpdf->SetHTMLFooter($footerHTML);

// HTML CONTENT
$html = '
<style>
body { font-family: helvetica; font-size: 12pt; }

/* HEADER BOX */
.header-box {
  background-color:skyblue; 
  border:1px solid #b87333; 
  padding:15px; 
  margin-bottom:10px;
  color:black;
}
.hospital-name { font-size: 22pt; font-weight: bold; color:red; margin-bottom:5px; text-align:center; }
.hospital-details { font-size: 11pt; color:black; line-height:1.4; text-align:center; }
.reg-no { color:red; font-weight:bold; text-align:right; font-size:12pt; }

/* PATIENT BOX */
.details-box {
  border:1px solid #b87333; 
  padding:10px; 
  margin-bottom:10px;
}
.details-table { width:100%; border-collapse:collapse; }
.details-table td { padding:5px; vertical-align:top; font-size:11pt; }

/* HEADINGS */
.section-header { font-weight:bold; margin-bottom:5px; font-size:14pt; color:#b87333; }

/* RX / LOGO / VITALS layout */
.left-column {
  width:40%;
  float:left;
}
.center-column {
  width:20%;
  float:left;
  text-align:center;
}
.right-column {
  width:40%;
  float:right;
}
.right-column table {
  width:100%;
  border-collapse:collapse;
}
.right-column td {
  padding:15px; 
  border:1px solid #ddd;
  font-size:11pt;
  line-height:1.6;
}
.clear { clear:both; }
</style>

<!-- HEADER -->
<div class="header-box">
  <table width="100%">
    <tr>
      <td width="15%" align="left">
       <img src="' . $logoPath . '" width="50">
      </td>
      <td width="70%" align="center">
        <div class="hospital-name">' . htmlspecialchars($settings['system_name'] ?? 'AFLUX HOSPITALS') . '</div>
        <div class="hospital-details">
            <strong>Add:</strong> ' . htmlspecialchars($settings['system_address'] ?? 'Jankipuram, Lucknow') . ' | 
            <strong>Mob No:</strong> ' . htmlspecialchars($settings['system_phone'] ?? '+91 9721474721') . ' | 
            <strong>Email:</strong> ' . htmlspecialchars($settings['system_email'] ?? 'admin@afluxkey.com') . '
        </div>
      </td>
      <td width="15%" align="right" class="reg-no">
        Reg. No- 0009
      </td>
    </tr>
  </table>
</div>

<!-- PATIENT DETAILS -->
<div class="details-box">
<table class="details-table">
    <tr>
        <td width="15%"><strong>Name</strong></td>
        <td width="35%">: ' . htmlspecialchars($patient['title'] . ' ' . $patient['pat_fname'] . ' ' . $patient['pat_lname']) . '</td>
        <td width="15%"><strong>Reg. Date</strong></td>
        <td width="35%">: ' . ($patient ? date('d-M-Y', strtotime($patient['pat_date_joined'])) : 'N/A') . '</td>
    </tr>
    <tr>
        <td><strong>Age/Gender/Adhaar</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_age']) . ' / ' . htmlspecialchars($patient['gender']) . ' / No</td>
        <td><strong>Department</strong></td>
        <td>: ' . htmlspecialchars($patient['dept']) . '</td>
    </tr>
    <tr>
        <td><strong>Mobile No</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_phone']) . '</td>
        <td><strong>Doctor</strong></td>
        <td>: ' . ($doctor ? 'DR. ' . htmlspecialchars($doctor['doc_fname'] . ' ' . $doctor['doc_lname']) : 'DR. AZAZAHMAD') . '</td>
    </tr>
    <tr>
        <td><strong>UHID</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_number']) . '</td>
        <td><strong>Patient Type</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_type']) . '</td>
    </tr>
    <tr>
        <td><strong>OPD ID</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_number']) . '</td>
        <td><strong>Clinical History</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_ailment']) . '</td>
    </tr>
    <tr>
        <td><strong>Address</strong></td>
        <td>: ' . htmlspecialchars($patient['pat_addr']) . '</td>
        <td><strong>Insurance company</strong></td>
        <td>: ' . htmlspecialchars($patient['insurance']) . '</td>
    </tr>
</table>
</div>

<!-- THREE COLUMNS: Rx, Logo, Vitals -->
<div class="left-column">
  <div class="section-header">Rx</div>
  ' . ($prescription ? nl2br(htmlspecialchars($prescription['pres_ins'])) : '<p>No prescription available.</p>') . '
</div>

<div class="center-column">
  <img src="' . $logoPath . '" width="60" style="margin-top:30px;">
</div>

<div class="right-column">
  <div class="section-header">Vitals</div>
  <table>
    <tr><td><strong>Temp:</strong> ' . ($vitals['vit_bodytemp'] ?? '..') . '</td></tr>
    <tr><td><strong>BP:</strong> ' . ($vitals['vit_bloodpress'] ?? '..') . '</td></tr>
    <tr><td><strong>SP02:</strong> ..</td></tr>
    <tr><td><strong>Pulse:</strong> ' . ($vitals['vit_heartpulse'] ?? '..') . '</td></tr>
    <tr><td><strong>Height:</strong> ..</td></tr>
    <tr><td><strong>Weight:</strong> ..</td></tr>
  </table>
</div>

<div class="clear"></div>
';

// Output PDF
$mpdf->WriteHTML($html);
$mpdf->Output('medical_report_' . $patient_id . '.pdf', 'D');
exit;
?>
