<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_room'])) {
    $room_number = $_POST['room_number'];
    $room_name = $_POST['room_name'];
    $ward_id = $_POST['ward_id'];
    $room_type = $_POST['room_type'];
    $capacity = $_POST['capacity'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_rooms (room_number, room_name, ward_id, room_type, capacity, description, status) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssisiss', $room_number, $room_name, $ward_id, $room_type, $capacity, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Room added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_room'])) {
    $room_id = $_POST['room_id'];
    $room_number = $_POST['room_number'];
    $room_name = $_POST['room_name'];
    $ward_id = $_POST['ward_id'];
    $room_type = $_POST['room_type'];
    $capacity = $_POST['capacity'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_rooms SET room_number = ?, room_name = ?, ward_id = ?, room_type = ?, capacity = ?, description = ?, status = ? WHERE room_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssisissi', $room_number, $room_name, $ward_id, $room_type, $capacity, $description, $status, $room_id);
    
    if ($stmt->execute()) {
        $success = "Room updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $room_id = $_GET['delete'];
    $query = "DELETE FROM his_rooms WHERE room_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $room_id);
    
    if ($stmt->execute()) {
        $success = "Room deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all rooms with ward information
$rooms = [];
$ret = "SELECT r.*, w.ward_number, w.ward_name 
        FROM his_rooms r 
        LEFT JOIN his_wards w ON r.ward_id = w.ward_id 
        ORDER BY r.room_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($room = $res->fetch_object()) {
    $rooms[] = $room;
}

// Get all wards for dropdown
$wards = [];
$ret = "SELECT * FROM his_wards WHERE status = 'Active' ORDER BY ward_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($ward = $res->fetch_object()) {
    $wards[] = $ward;
}

// Get specific room for editing
$edit_room = null;
if (isset($_GET['edit'])) {
    $room_id = $_GET['edit'];
    $ret = "SELECT * FROM his_rooms WHERE room_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $room_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_room = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Room Management</a></li>
                                        <li class="breadcrumb-item active">Rooms</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Rooms</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_room) ? 'Edit Room' : 'Add New Room'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_room)) { ?>
                                            <input type="hidden" name="room_id" value="<?php echo $edit_room->room_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="room_number">Room Number *</label>
                                                    <input type="text" class="form-control" id="room_number" name="room_number" value="<?php echo isset($edit_room) ? $edit_room->room_number : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="room_name">Room Name *</label>
                                                    <input type="text" class="form-control" id="room_name" name="room_name" value="<?php echo isset($edit_room) ? $edit_room->room_name : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ward_id">Ward *</label>
                                                    <select class="form-control" id="ward_id" name="ward_id" required>
                                                        <option value="">Select Ward</option>
                                                        <?php foreach ($wards as $ward) { ?>
                                                            <option value="<?php echo $ward->ward_id; ?>" <?php echo (isset($edit_room) && $edit_room->ward_id == $ward->ward_id) ? 'selected' : ''; ?>>
                                                                <?php echo $ward->ward_number . ' - ' . $ward->ward_name; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="room_type">Room Type</label>
                                                    <select class="form-control" id="room_type" name="room_type" required>
                                                        <option value="General" <?php echo (isset($edit_room) && $edit_room->room_type == 'General') ? 'selected' : ''; ?>>General</option>
                                                        <option value="Private" <?php echo (isset($edit_room) && $edit_room->room_type == 'Private') ? 'selected' : ''; ?>>Private</option>
                                                        <option value="ICU" <?php echo (isset($edit_room) && $edit_room->room_type == 'ICU') ? 'selected' : ''; ?>>ICU</option>
                                                        <option value="Emergency" <?php echo (isset($edit_room) && $edit_room->room_type == 'Emergency') ? 'selected' : ''; ?>>Emergency</option>
                                                        <option value="Maternity" <?php echo (isset($edit_room) && $edit_room->room_type == 'Maternity') ? 'selected' : ''; ?>>Maternity</option>
                                                        <option value="Pediatric" <?php echo (isset($edit_room) && $edit_room->room_type == 'Pediatric') ? 'selected' : ''; ?>>Pediatric</option>
                                                        <option value="Other" <?php echo (isset($edit_room) && $edit_room->room_type == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="capacity">Capacity *</label>
                                                    <input type="number" class="form-control" id="capacity" name="capacity" value="<?php echo isset($edit_room) ? $edit_room->capacity : '1'; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" id="status" name="status" required>
                                                        <option value="Active" <?php echo (isset($edit_room) && $edit_room->status == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                        <option value="Inactive" <?php echo (isset($edit_room) && $edit_room->status == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                                        <option value="Maintenance" <?php echo (isset($edit_room) && $edit_room->status == 'Maintenance') ? 'selected' : ''; ?>>Maintenance</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo isset($edit_room) ? $edit_room->description : ''; ?></textarea>
                                        </div>
                                        <?php if(isset($edit_room)) { ?>
                                            <button type="submit" name="update_room" class="btn btn-primary">Update Room</button>
                                            <a href="roomno.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_room" class="btn btn-success">Add Room</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Rooms</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Room Number</th>
                                                <th>Room Name</th>
                                                <th>Ward</th>
                                                <th>Type</th>
                                                <th>Capacity</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($rooms as $room) { ?>
                                                <tr>
                                                    <td><?php echo $room->room_number; ?></td>
                                                    <td><?php echo $room->room_name; ?></td>
                                                    <td><?php echo $room->ward_number . ' - ' . $room->ward_name; ?></td>
                                                    <td><?php echo $room->room_type; ?></td>
                                                    <td><?php echo $room->capacity; ?></td>
                                                    <td><?php echo $room->description; ?></td>
                                                    <td><span class="badge badge-<?php echo $room->status == 'Active' ? 'success' : ($room->status == 'Inactive' ? 'danger' : 'warning'); ?>"><?php echo $room->status; ?></span></td>
                                                    <td>
                                                        <a href="roomno.php?edit=<?php echo $room->room_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="roomno.php?delete=<?php echo $room->room_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this room?')">Delete</a>
                                                        <a href="bedno.php?room_id=<?php echo $room->room_id; ?>" class="btn btn-sm btn-info">View Beds</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>