<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <!-- Buttons extension -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* Add your existing styles here */
        .settings-tabs {
            margin-bottom: 20px;
        }
        .settings-tabs .nav-link {
            font-weight: 600;
            color: var(--gray);
            padding: 12px 20px;
            border-radius: 8px 8px 0 0;
        }
        .settings-tabs .nav-link.active {
            color: var(--primary);
            background-color: white;
            border-color: var(--border) var(--border) white var(--border);
        }
        .tab-content {
            background: white;
            padding: 25px;
            border-radius: 0 8px 8px 8px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
        }
        .logo-preview {
            max-width: 200px;
            max-height: 100px;
            margin-top: 10px;
            border: 1px dashed var(--border);
            padding: 5px;
            border-radius: 4px;
        }
        .form-section {
            margin-bottom: 30px;
        }
        .form-section h5 {
            border-bottom: 1px solid var(--border);
            padding-bottom: 10px;
            margin-bottom: 20px;
            color: var(--primary);
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item active">System Settings</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">System Configuration</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <ul class="nav nav-tabs settings-tabs" id="settingsTabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="general-tab" data-toggle="tab" href="#general" role="tab">General</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="departments-tab" data-toggle="tab" href="#departments" role="tab">Departments</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="insurance-tab" data-toggle="tab" href="#insurance" role="tab">Insurance</a>
                                    </li>
                                </ul>

                                <div class="tab-content" id="settingsTabsContent">
                                    <!-- General Settings Tab -->
                                    <div class="tab-pane fade show active" id="general" role="tabpanel">
                                        <?php include('settings_general.php'); ?>
                                    </div>
                                    
                                    <!-- Departments Tab -->
                                    <div class="tab-pane fade" id="departments" role="tabpanel">
                                        <?php include('settings_departments.php'); ?>
                                    </div>
                                    
                                    <!-- Insurance Tab -->
                                    <div class="tab-pane fade" id="insurance" role="tabpanel">
                                        <?php include('settings_insurance.php'); ?>
                                    </div>
                                </div>
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- DataTables JS -->
    <script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize DataTables for departments and insurance
            $('#departments-table, #insurance-table').DataTable({
                dom: '<"top"Bf>rt<"bottom"lip><"clear">',
                buttons: [
                    {
                        extend: 'copy',
                        text: '<i class="far fa-copy"></i> Copy',
                        className: 'btn btn-sm btn-light',
                    },
                    {
                        extend: 'excel',
                        text: '<i class="far fa-file-excel"></i> Excel',
                        className: 'btn btn-sm btn-light',
                    },
                    {
                        extend: 'pdf',
                        text: '<i class="far fa-file-pdf"></i> PDF',
                        className: 'btn btn-sm btn-light',
                    },
                    {
                        extend: 'print',
                        text: '<i class="fas fa-print"></i> Print',
                        className: 'btn btn-sm btn-light',
                        customize: function (win) {
                            $(win.document.body).find('h1').css('text-align','center');
                            $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                        }
                    }
                ],
                pageLength: 10,
                responsive: true
            });

            // Logo preview functionality
            $('#system_logo').change(function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        $('#logo-preview').attr('src', e.target.result).show();
                    }
                    reader.readAsDataURL(file);
                }
            });

            // Tab persistence
            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                localStorage.setItem('lastTab', $(e.target).attr('href'));
            });
            
            var lastTab = localStorage.getItem('lastTab');
            if (lastTab) {
                $('[href="' + lastTab + '"]').tab('show');
            }
        });
    </script>
</body>
</html>