<div class="form-section">
    <h5>Add New Insurance Provider</h5>
    <form action="update_settings.php" method="post">
        <input type="hidden" name="setting_type" value="insurance_add">
        
        <div class="form-group">
            <label for="insurance_name">Insurance Provider Name</label>
            <input type="text" class="form-control" id="insurance_name" name="insurance_name" required>
        </div>
        
        <button type="submit" class="btn btn-primary">Add Insurance</button>
    </form>
</div>

<div class="form-section">
    <h5>Manage Insurance Providers</h5>
    <div class="table-responsive">
        <table id="insurance-table" class="table table-bordered mb-0" style="width:100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Insurance Provider</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $ret = "SELECT * FROM his_insurance ORDER BY insurance_name";
                $stmt = $mysqli->prepare($ret);
                $stmt->execute();
                $res = $stmt->get_result();
                $cnt = 1;
                while($row = $res->fetch_object()):
                ?>
                <tr>
                    <td><?php echo $cnt; ?></td>
                    <td><?php echo htmlspecialchars($row->insurance_name); ?></td>
                    <td><?php echo date('M d, Y', strtotime($row->created_at)); ?></td>
                    <td>
                        <div class="d-flex" style="gap: 5px;">
                            <a href="edit_insurance.php?id=<?php echo $row->insurance_id; ?>" class="badge badge-primary">
                                <i class="fas fa-edit mr-1"></i> Edit
                            </a>
                            <a href="update_settings.php?action=delete_insurance&id=<?php echo $row->insurance_id; ?>" 
                               class="badge badge-danger" onclick="return confirm('Are you sure you want to delete this insurance provider?');">
                                <i class="fas fa-trash-alt mr-1"></i> Delete
                            </a>
                        </div>
                    </td>
                </tr>
                <?php $cnt++; endwhile; ?>
            </tbody>
        </table>
    </div>
</div>