<!--Server side code to handle Patient Registration-->
<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['add_patient']))
    {
        $s_pat_number = $_POST['s_pat_number'];
        $s_number=$_POST['s_number'];
        $s_pat_name=$_POST['s_pat_name'];
        $s_pat_status=$_POST['s_pat_status'];
        $s_pat_ailment = $_POST['s_pat_ailment'];
        $s_doc = $_POST['s_doc'];
        
        $query="INSERT INTO his_surgery (s_pat_number, s_number, s_pat_name, s_pat_status, s_pat_ailment, s_doc) VALUES(?,?,?,?,?,?)";
        $stmt = $mysqli->prepare($query);
        $rc=$stmt->bind_param('ssssss', $s_pat_number, $s_number, $s_pat_name, $s_pat_status, $s_pat_ailment, $s_doc);
        $stmt->execute();
        
        if($stmt)
        {
            $success = "Surgery Patient Added Successfully";
        }
        else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!--End Server Side-->
<!--End Patient Registration-->
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Surgery | Theatre</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Add Patient</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-procedures mr-2"></i>Add Surgery Patient
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        
                        <!-- Form row -->
                        <?php
                            $pat_id=$_GET['pat_id'];
                            $ret="SELECT * FROM his_patients WHERE pat_id=?";
                            $stmt= $mysqli->prepare($ret);
                            $stmt->bind_param('i',$pat_id);
                            $stmt->execute();
                            $res=$stmt->get_result();
                            while($row=$res->fetch_object())
                            {
                        ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="card" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <div class="card-body" style="padding: 2rem;">
                                        <h4 class="header-title" style="color: #4e73df; border-bottom: 2px solid #f8f9fc; padding-bottom: 10px; margin-bottom: 20px;">
                                            <i class="fas fa-user-injured mr-2"></i>Patient Details
                                        </h4>
                                        
                                        <!-- Surgery Patient Form -->
                                        <form method="post">
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputEmail4" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Patient Name</label>
                                                    <input type="text" readonly required="required" value="<?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>" name="s_pat_name" class="form-control" id="inputEmail4" placeholder="Patient's Name" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Patient full name</small>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="inputPassword4" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Patient Ailment</label>
                                                    <input readonly required="required" type="text" value="<?php echo $row->pat_ailment;?>" name="s_pat_ailment" class="form-control" id="inputPassword4" placeholder="Patient's Ailment" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Primary medical condition</small>
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputEmail4" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Patient Number</label>
                                                    <input readonly type="text" required="required" value="<?php echo $row->pat_number;?>" name="s_pat_number" class="form-control" id="inputEmail4" placeholder="Patient Number" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; background-color: #f8f9fc;">
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Unique patient identifier</small>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="inputState" class="col-form-label" style="font-weight: 600; color: #5a5c69;">Surgeon</label>
                                                    <select id="inputState" required="required" name="s_doc" class="form-control" style="border-radius: 8px; border: 1px solid #d1d3e2; padding: 12px 15px; height: auto; background-color: #f8f9fc; appearance: none; background-image: url('data:image/svg+xml;utf8,<svg fill="%235a5c69" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>'); background-repeat: no-repeat; background-position: right 10px center;">
                                                        <option value="" disabled selected>Select Surgeon</option>
                                                        <?php
                                                            $ret="SELECT * FROM his_docs WHERE doc_dept = 'Surgery | Theatre' ORDER BY doc_fname"; 
                                                            $stmt= $mysqli->prepare($ret);
                                                            $stmt->execute();
                                                            $res=$stmt->get_result();
                                                            while($doc=$res->fetch_object())
                                                            {
                                                        ?>
                                                        <option value="<?php echo $doc->doc_fname.' '.$doc->doc_lname;?>">Dr. <?php echo $doc->doc_fname.' '.$doc->doc_lname;?></option>
                                                        <?php } ?>
                                                    </select>
                                                    <small class="form-text text-muted" style="font-size: 0.8rem; color: #858796;">Select attending surgeon</small>
                                                </div>
                                                <div class="form-group col-md-6" style="display:none">
                                                    <label for="inputPassword4" class="col-form-label">Surgery Status</label>
                                                    <input required="required" type="text" value="Undergoing" name="s_pat_status" class="form-control" id="inputPassword4">
                                                </div>
                                            </div>

                                            <div class="form-row" style="display:none">
                                                <div class="form-group col-md-2">
                                                    <?php 
                                                        $length = 5;    
                                                        $s_number = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                                    ?>
                                                    <label for="inputZip" class="col-form-label">Surgery Record Number</label>
                                                    <input type="text" name="s_number" value="<?php echo $s_number;?>" class="form-control" id="inputZip">
                                                </div>
                                            </div>

                                            <div class="text-right mt-4">
                                                <button type="submit" name="add_patient" class="ladda-button btn btn-success" data-style="expand-right" style="background: linear-gradient(to right, #11998e, #38ef7d); border: none; padding: 12px 30px; font-weight: 600; border-radius: 8px; box-shadow: 0 4px 15px rgba(17, 153, 142, 0.3); transition: all 0.3s; position: relative; overflow: hidden;">
                                                    <span class="ladda-label" style="position: relative; z-index: 2;">
                                                        <i class="fas fa-save mr-2"></i>Add to Surgery
                                                    </span>
                                                    <span class="ladda-spinner"></span>
                                                </button>
                                            </div>
                                        </form>
                                        <!--End Surgery Patient Form-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <?php } ?>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>

        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
        
    </body>

</html>