<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['setting_type'])) {
        switch ($_POST['setting_type']) {
            case 'general':
                // Handle general settings update
                $system_name = $_POST['system_name'];
                $system_email = $_POST['system_email'];
                $system_phone = $_POST['system_phone'];
                $system_address = $_POST['system_address'];
                $system_mission = $_POST['system_mission'];
                
                // Handle file upload
                $logo_path = '';
                if (isset($_FILES['system_logo']) && $_FILES['system_logo']['error'] === UPLOAD_ERR_OK) {
                    $target_dir = "assets/uploads/";
                    $file_name = "logo_" . time() . "_" . basename($_FILES['system_logo']['name']);
                    $target_file = $target_dir . $file_name;
                    
                    // Check if image file is a actual image
                    $check = getimagesize($_FILES['system_logo']['tmp_name']);
                    if ($check !== false) {
                        if (move_uploaded_file($_FILES['system_logo']['tmp_name'], $target_file)) {
                            $logo_path = $target_file;
                        }
                    }
                }
                
                // Update query
                $query = "UPDATE his_system_settings SET 
                          system_name = ?, 
                          system_email = ?, 
                          system_phone = ?, 
                          system_address = ?, 
                          system_mission = ?" . 
                          ($logo_path ? ", system_logo = ?" : "") . " 
                          WHERE id = 1";
                
                $stmt = $mysqli->prepare($query);
                
                if ($logo_path) {
                    $stmt->bind_param('ssssss', 
                        $system_name, $system_email, $system_phone, 
                        $system_address, $system_mission, $logo_path);
                } else {
                    $stmt->bind_param('sssss', 
                        $system_name, $system_email, $system_phone, 
                        $system_address, $system_mission);
                }
                
                $stmt->execute();
                
                $_SESSION['success'] = "General settings updated successfully";
                header("Location: settings.php");
                exit();
                break;
                
            case 'department_add':
                // Handle department addition
                $department_name = $_POST['department_name'];
                $department_type = $_POST['department_type'];
         // Chukua values kutoka form
$opd_fee = !empty($_POST['opd_fee']) ? $_POST['opd_fee'] : '0';
$ipd_fee = !empty($_POST['ipd_fee']) ? $_POST['ipd_fee'] : '0';
$department_description = !empty($_POST['department_description']) ? $_POST['department_description'] : 'N/A';
$ailment_name = !empty($_POST['ailment_name']) ? $_POST['ailment_name'] : 'N/A';

                
                $query = "INSERT INTO his_departments (
                          department_name, department_type, opd_fee, ipd_fee, 
                          department_description, ailment_name
                          ) VALUES (?, ?, ?, ?, ?, ?)";
                
                $stmt = $mysqli->prepare($query);
                $stmt->bind_param('ssddss', 
                    $department_name, $department_type, $opd_fee, $ipd_fee, 
                    $department_description, $ailment_name);
                $stmt->execute();
                
                $_SESSION['success'] = "Department added successfully";
                header("Location: settings.php#departments");
                exit();
                break;
                
            case 'insurance_add':
                // Handle insurance addition
                $insurance_name = $_POST['insurance_name'];
                
                $query = "INSERT INTO his_insurance (insurance_name) VALUES (?)";
                $stmt = $mysqli->prepare($query);
                $stmt->bind_param('s', $insurance_name);
                $stmt->execute();
                
                $_SESSION['success'] = "Insurance provider added successfully";
                header("Location: settings.php#insurance");
                exit();
                break;
        }
    }
} elseif (isset($_GET['action'])) {
    // Handle delete actions
    switch ($_GET['action']) {
        case 'delete_department':
            $id = intval($_GET['id']);
            $query = "DELETE FROM his_departments WHERE department_id = ?";
            $stmt = $mysqli->prepare($query);
            $stmt->bind_param('i', $id);
            $stmt->execute();
            
            $_SESSION['success'] = "Department deleted successfully";
            header("Location: settings.php#departments");
            exit();
            break;
            
        case 'delete_insurance':
            $id = intval($_GET['id']);
            $query = "DELETE FROM his_insurance WHERE insurance_id = ?";
            $stmt = $mysqli->prepare($query);
            $stmt->bind_param('i', $id);
            $stmt->execute();
            
            $_SESSION['success'] = "Insurance provider deleted successfully";
            header("Location: settings.php#insurance");
            exit();
            break;
    }
}

// If no action matched, redirect back
header("Location: settings.php");
exit();