<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['update_pharmaceutical_category'])) {
    $pharm_cat_name = $_GET['pharm_cat_name'];
    $pharm_cat_vendor = $_POST['pharm_cat_vendor'];
    $pharm_cat_desc = $_POST['pharm_cat_desc'];
    
    //sql to update captured values
    $query = "UPDATE his_pharmaceuticals_categories SET pharm_cat_vendor=?, pharm_cat_desc=? WHERE pharm_cat_name = ?";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sss', $pharm_cat_vendor, $pharm_cat_desc, $pharm_cat_name);
    $stmt->execute();
    
    if($stmt) {
        $success = "Pharmaceutical Category Updated Successfully";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-light: #eef2ff;
            --secondary-color: #3a0ca3;
            --success-color: #00b46e;
            --danger-color: #dc3545;
            --warning-color: #ff9e00;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark-text);
            font-weight: 700;
            position: relative;
            display: inline-block;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: -8px;
            width: 60px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .form-control {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 12px 15px;
            height: auto;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
        }
        
        label {
            font-weight: 600;
            color: var(--dark-text);
            margin-bottom: 8px;
            display: block;
        }
        
        .btn-update {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-update:hover {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(67, 97, 238, 0.2);
        }
        
        .header-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 60px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        /* CKEditor 5 Custom Styling */
        .ck.ck-editor {
            border-radius: 8px !important;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .ck.ck-toolbar {
            border-radius: 8px 8px 0 0 !important;
            background-color: var(--primary-light) !important;
            border-bottom: 1px solid var(--form-border) !important;
        }
        
        .ck.ck-content {
            min-height: 200px;
            border-radius: 0 0 8px 8px !important;
            border: 1px solid var(--form-border) !important;
            border-top: none !important;
        }
        
        @media (max-width: 768px) {
            .form-group {
                margin-bottom: 20px;
            }
            
            .btn-update {
                width: 100%;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $pharm_cat_name = $_GET['pharm_cat_name'];
            $ret = "SELECT * FROM his_pharmaceuticals_categories WHERE pharm_cat_name=?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('s', $pharm_cat_name);
            $stmt->execute();
            $res = $stmt->get_result();
            while($row = $res->fetch_object()) {
        ?>
        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">Manage Pharmaceutical Category</li>
                                    </ol>
                                </div>
                                <h4 class="page-title"><?php echo htmlspecialchars($row->pharm_cat_name);?></h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Update Pharmaceutical Category</h4>
                                    
                                    <!-- Update Form -->
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6" style="display:none">
                                                <label for="pharm_cat_name" class="col-form-label">Pharmaceutical Category Name</label>
                                                <input type="text" value="<?php echo htmlspecialchars($row->pharm_cat_name);?>" required name="pharm_cat_name" class="form-control" id="pharm_cat_name">
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label for="pharm_cat_vendor" class="col-form-label">Pharmaceutical Category Vendor</label>
                                                <input required value="<?php echo htmlspecialchars($row->pharm_cat_vendor);?>" type="text" name="pharm_cat_vendor" class="form-control" id="pharm_cat_vendor" placeholder="Enter vendor name">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="editor" class="col-form-label">Pharmaceutical Category Description</label>
                                            <textarea required class="form-control" name="pharm_cat_desc" id="editor" placeholder="Enter category description"><?php echo htmlspecialchars($row->pharm_cat_desc);?></textarea>
                                        </div>

                                        <button type="submit" name="update_pharmaceutical_category" class="ladda-button btn btn-update" data-style="expand-right">
                                            <span class="ladda-label">
                                                <i class="fas fa-save mr-1"></i> Update Category
                                            </span>
                                        </button>

                                    </form>
                                 
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
            <?php }?>

    </div>
    <!-- END wrapper -->
    
    <!-- Load CKEditor 5 from CDN -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <script>
        // Initialize CKEditor 5
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'undo', 'redo', '|',
                        'blockQuote', 'insertTable'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                        { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' }
                    ]
                },
                table: {
                    contentToolbar: [ 'tableColumn', 'tableRow', 'mergeTableCells' ]
                },
                licenseKey: ''
            })
            .then(editor => {
                window.editor = editor;
            })
            .catch(error => {
                console.error('Oops, something went wrong!');
                console.error('Please, report the following error on https://github.com/ckeditor/ckeditor5/issues with the build id and the error stack trace:');
                console.warn('Build id: 4tb8wqta9vmp-5jv7u4qj5j5s');
                console.error(error);
            });
    </script>
   
    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
    <!-- Font Awesome for icons -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>

</html>