<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
    <html lang="en">

    <?php include('assets/inc/head.php');?>

    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
             <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <!--Get Details Of A Single User And Display Them Here-->
            <?php
                $pat_number=$_GET['pat_number'];
                $pat_id=$_GET['pat_id'];
                $ret="SELECT  * FROM his_patients WHERE pat_id=?";
                $stmt= $mysqli->prepare($ret) ;
                $stmt->bind_param('i',$pat_id);
                $stmt->execute() ;//ok
                $res=$stmt->get_result();
                //$cnt=1;
                while($row=$res->fetch_object())
            {
                $mysqlDateTime = $row->pat_date_joined;
            ?>
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Patient Profile</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-user-injured mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>'s Profile
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end page title -->

                        <div class="row">
                            <div class="col-lg-4 col-xl-4">
                                <div class="card-box text-center" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <div style="background: linear-gradient(to right, #4e73df, #224abe); padding: 20px 0; margin-bottom: 20px;">
                                        <img src="assets/images/users/patient.png" class="rounded-circle avatar-xl img-thumbnail shadow"
                                            alt="profile-image" style="border: 5px solid rgba(255,255,255,0.3);">
                                    </div>
                                    
                                    <div class="text-left mt-3" style="padding: 0 20px;">
                                        <h4 class="mb-3" style="color: #4e73df; border-bottom: 2px solid #f8f9fc; padding-bottom: 10px;">
                                            <i class="fas fa-id-card mr-2"></i>Personal Details
                                        </h4>
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-user mr-2" style="color: #4e73df;"></i>Full Name:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?></span>
                                        </p>
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-mobile-alt mr-2" style="color: #4e73df;"></i>Mobile:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo $row->pat_phone;?></span>
                                        </p>
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-map-marker-alt mr-2" style="color: #4e73df;"></i>Address:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo $row->pat_addr;?></span>
                                        </p>
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-birthday-cake mr-2" style="color: #4e73df;"></i>Date Of Birth:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo $row->pat_dob;?></span>
                                        </p>
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-calendar-alt mr-2" style="color: #4e73df;"></i>Age:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo $row->pat_age;?> Years</span>
                                        </p>
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-disease mr-2" style="color: #4e73df;"></i>Ailment:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo $row->pat_ailment;?></span>
                                        </p>
                                        
                                        <hr style="border-top: 1px dashed #d1d3e2;">
                                        
                                        <p class="mb-3" style="display: flex; align-items: center;">
                                            <span style="flex: 0 0 120px; font-weight: 600; color: #5a5c69;">
                                                <i class="fas fa-calendar-check mr-2" style="color: #4e73df;"></i>Date Recorded:
                                            </span> 
                                            <span style="color: #4e73df; font-weight: 500;"><?php echo date("d/m/Y - h:m", strtotime($mysqlDateTime));?></span>
                                        </p>
                                        
                                        <hr style="border-top: 1px dashed #d1d3e2;">

                                    </div>

                                </div> <!-- end card-box -->

                            </div> <!-- end col-->
                            
                            <?php }?>
                            <div class="col-lg-8 col-xl-8">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <ul class="nav nav-pills navtab-bg nav-justified" style="background: #f8f9fc; border-radius: 10px 10px 0 0;">
                                        <li class="nav-item">
                                            <a href="#aboutme" data-toggle="tab" aria-expanded="false" class="nav-link active" style="color: #4e73df; font-weight: 600; border-radius: 8px 8px 0 0;">
                                                <i class="fas fa-prescription-bottle-alt mr-1"></i> Prescription
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#timeline" data-toggle="tab" aria-expanded="true" class="nav-link" style="color: #4e73df; font-weight: 600; border-radius: 8px 8px 0 0;">
                                                <i class="fas fa-heartbeat mr-1"></i> Vitals
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#settings" data-toggle="tab" aria-expanded="false" class="nav-link" style="color: #4e73df; font-weight: 600; border-radius: 8px 8px 0 0;">
                                                <i class="fas fa-flask mr-1"></i> Lab Records
                                            </a>
                                        </li>
                                    </ul>
                                    <!--Medical History-->
                                    <div class="tab-content" style="padding: 20px;">
                                        <div class="tab-pane show active" id="aboutme">
                                             <ul class="list-unstyled timeline-sm">
                                                <?php
                                                    $pres_pat_number =$_GET['pat_number'];
                                                    $ret="SELECT  * FROM his_prescriptions WHERE pres_pat_number ='$pres_pat_number'";
                                                    $stmt= $mysqli->prepare($ret) ;
                                                    $stmt->execute() ;//ok
                                                    $res=$stmt->get_result();
                                                    
                                                    while($row=$res->fetch_object())
                                                        {
                                                    $mysqlDateTime = $row->pres_date;
                                                ?>
                                                    <li class="timeline-sm-item" style="background: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); border-left: 4px solid #4e73df;">
                                                        <span class="timeline-sm-date" style="background: #4e73df; color: white; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 600;">
                                                            <?php echo date("Y-m-d", strtotime($mysqlDateTime));?>
                                                        </span>
                                                        <h5 class="mt-3 mb-2" style="color: #4e73df; font-weight: 600;">
                                                            <i class="fas fa-disease mr-2"></i><?php echo $row->pres_pat_ailment;?>
                                                        </h5>
                                                        <div style="background: #f8f9fc; padding: 15px; border-radius: 8px; margin-top: 10px;">
                                                            <h6 style="color: #5a5c69; font-weight: 600; margin-bottom: 10px;">
                                                                <i class="fas fa-prescription mr-2"></i>Prescription Instructions:
                                                            </h6>
                                                            <p class="text-muted mt-2" style="color: #6c757d;">
                                                                <?php echo $row->pres_ins;?>
                                                            </p>
                                                        </div>
                                                    </li>
                                                <?php }?>
                                            </ul>
                                           
                                        </div> <!-- end tab-pane -->
                                        <!-- end Prescription section content -->

                                        <div class="tab-pane show" id="timeline">
                                            <div class="table-responsive">
                                                <table class="table table-borderless mb-0" style="border-collapse: separate; border-spacing: 0 10px;">
                                                    <thead class="thead-light" style="background: linear-gradient(to right, #4e73df, #224abe); color: white;">
                                                        <tr>
                                                            <th style="border: none; padding: 15px; border-radius: 8px 0 0 0;">Body Temperature</th>
                                                            <th style="border: none; padding: 15px;">Heart Rate/Pulse</th>
                                                            <th style="border: none; padding: 15px;">Respiratory Rate</th>
                                                            <th style="border: none; padding: 15px;">Blood Pressure</th>
                                                            <th style="border: none; padding: 15px; border-radius: 0 8px 0 0;">Date Recorded</th>
                                                        </tr>
                                                    </thead>
                                                    <?php
                                                        $vit_pat_number =$_GET['pat_number'];
                                                        $ret="SELECT  * FROM his_vitals WHERE vit_pat_number ='$vit_pat_number'";
                                                        $stmt= $mysqli->prepare($ret) ;
                                                        $stmt->execute() ;//ok
                                                        $res=$stmt->get_result();
                                                        
                                                        while($row=$res->fetch_object())
                                                            {
                                                        $mysqlDateTime = $row->vit_daterec;
                                                    ?>
                                                        <tbody>
                                                            <tr style="background: white; box-shadow: 0 4px 12px rgba(0,0,0,0.05); border-radius: 8px;">
                                                                <td style="border: none; padding: 15px; font-weight: 600; color: #ff6b6b;"><?php echo $row->vit_bodytemp;?>°C</td>
                                                                <td style="border: none; padding: 15px; font-weight: 600; color: #4e73df;"><?php echo $row->vit_heartpulse;?>BPM</td>
                                                                <td style="border: none; padding: 15px; font-weight: 600; color: #20c997;"><?php echo $row->vit_resprate;?>bpm</td>
                                                                <td style="border: none; padding: 15px; font-weight: 600; color: #f783ac;"><?php echo $row->vit_bloodpress;?>mmHg</td>
                                                                <td style="border: none; padding: 15px; color: #5a5c69;"><?php echo date("Y-m-d", strtotime($mysqlDateTime));?></td>
                                                            </tr>
                                                        </tbody>
                                                    <?php }?>
                                                </table>
                                            </div>
                                        </div>
                                        <!-- end vitals content-->

                                        <div class="tab-pane" id="settings">
                                            <ul class="list-unstyled timeline-sm">
                                                <?php
                                                    $lab_pat_number =$_GET['pat_number'];
                                                    $ret="SELECT  * FROM his_laboratory WHERE lab_pat_number  = '$lab_pat_number'";
                                                    $stmt= $mysqli->prepare($ret) ;
                                                    $stmt->execute() ;//ok
                                                    $res=$stmt->get_result();
                                                    
                                                    while($row=$res->fetch_object())
                                                        {
                                                    $mysqlDateTime = $row->lab_date_rec;
                                                ?>
                                                    <li class="timeline-sm-item" style="background: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); border-left: 4px solid #4e73df;">
                                                        <span class="timeline-sm-date" style="background: #4e73df; color: white; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 600;">
                                                            <?php echo date("Y-m-d", strtotime($mysqlDateTime));?>
                                                        </span>
                                                        <h3 class="mt-3 mb-2" style="color: #4e73df; font-weight: 600;">
                                                            <i class="fas fa-disease mr-2"></i><?php echo $row->lab_pat_ailment;?>
                                                        </h3>
                                                        <hr style="border-top: 1px dashed #d1d3e2;">
                                                        
                                                        <div style="background: #f8f9fc; padding: 15px; border-radius: 8px; margin-bottom: 15px;">
                                                            <h5 style="color: #5a5c69; font-weight: 600;">
                                                                <i class="fas fa-vial mr-2"></i>Laboratory Tests
                                                            </h5>
                                                            <p class="text-muted mt-2" style="color: #6c757d;">
                                                                <?php echo $row->lab_pat_tests;?>
                                                            </p>
                                                        </div>
                                                        
                                                        <div style="background: #f8f9fc; padding: 15px; border-radius: 8px;">
                                                            <h5 style="color: #5a5c69; font-weight: 600;">
                                                                <i class="fas fa-microscope mr-2"></i>Laboratory Results
                                                            </h5>
                                                            <p class="text-muted mt-2" style="color: #6c757d;">
                                                                <?php echo $row->lab_pat_results;?>
                                                            </p>
                                                        </div>
                                                    </li>
                                                <?php }?>
                                            </ul>
                                        </div>
                                        <!-- end lab records content-->

                                    </div> <!-- end tab-content -->
                                </div> <!-- end card-box-->

                            </div> <!-- end col -->
                        </div>
                        <!-- end row-->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>
            

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>

    </body>


</html>