<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_ward'])) {
    $ward_number = $_POST['ward_number'];
    $ward_name = $_POST['ward_name'];
    $floor_id = $_POST['floor_id'];
    $ward_type = $_POST['ward_type'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_wards (ward_number, ward_name, floor_id, ward_type, description, status) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssisss', $ward_number, $ward_name, $floor_id, $ward_type, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Ward added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_ward'])) {
    $ward_id = $_POST['ward_id'];
    $ward_number = $_POST['ward_number'];
    $ward_name = $_POST['ward_name'];
    $floor_id = $_POST['floor_id'];
    $ward_type = $_POST['ward_type'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_wards SET ward_number = ?, ward_name = ?, floor_id = ?, ward_type = ?, description = ?, status = ? WHERE ward_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssisssi', $ward_number, $ward_name, $floor_id, $ward_type, $description, $status, $ward_id);
    
    if ($stmt->execute()) {
        $success = "Ward updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $ward_id = $_GET['delete'];
    $query = "DELETE FROM his_wards WHERE ward_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $ward_id);
    
    if ($stmt->execute()) {
        $success = "Ward deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all wards with floor information
$wards = [];
$ret = "SELECT w.*, f.floor_number, f.floor_name 
        FROM his_wards w 
        LEFT JOIN his_floors f ON w.floor_id = f.floor_id 
        ORDER BY w.ward_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($ward = $res->fetch_object()) {
    $wards[] = $ward;
}

// Get all floors for dropdown
$floors = [];
$ret = "SELECT * FROM his_floors WHERE status = 'Active' ORDER BY floor_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($floor = $res->fetch_object()) {
    $floors[] = $floor;
}

// Get specific ward for editing
$edit_ward = null;
if (isset($_GET['edit'])) {
    $ward_id = $_GET['edit'];
    $ret = "SELECT * FROM his_wards WHERE ward_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $ward_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_ward = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Ward Management</a></li>
                                        <li class="breadcrumb-item active">Wards</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Wards</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_ward) ? 'Edit Ward' : 'Add New Ward'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_ward)) { ?>
                                            <input type="hidden" name="ward_id" value="<?php echo $edit_ward->ward_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ward_number">Ward Number *</label>
                                                    <input type="text" class="form-control" id="ward_number" name="ward_number" value="<?php echo isset($edit_ward) ? $edit_ward->ward_number : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ward_name">Ward Name *</label>
                                                    <input type="text" class="form-control" id="ward_name" name="ward_name" value="<?php echo isset($edit_ward) ? $edit_ward->ward_name : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="floor_id">Floor *</label>
                                                    <select class="form-control" id="floor_id" name="floor_id" required>
                                                        <option value="">Select Floor</option>
                                                        <?php foreach ($floors as $floor) { ?>
                                                            <option value="<?php echo $floor->floor_id; ?>" <?php echo (isset($edit_ward) && $edit_ward->floor_id == $floor->floor_id) ? 'selected' : ''; ?>>
                                                                <?php echo $floor->floor_number . ' - ' . $floor->floor_name; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ward_type">Ward Type</label>
                                                    <select class="form-control" id="ward_type" name="ward_type" required>
                                                        <option value="General" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'General') ? 'selected' : ''; ?>>General</option>
                                                        <option value="Private" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'Private') ? 'selected' : ''; ?>>Private</option>
                                                        <option value="ICU" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'ICU') ? 'selected' : ''; ?>>ICU</option>
                                                        <option value="Emergency" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'Emergency') ? 'selected' : ''; ?>>Emergency</option>
                                                        <option value="Maternity" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'Maternity') ? 'selected' : ''; ?>>Maternity</option>
                                                        <option value="Pediatric" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'Pediatric') ? 'selected' : ''; ?>>Pediatric</option>
                                                        <option value="Other" <?php echo (isset($edit_ward) && $edit_ward->ward_type == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo isset($edit_ward) ? $edit_ward->description : ''; ?></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="status">Status</label>
                                            <select class="form-control" id="status" name="status" required>
                                                <option value="Active" <?php echo (isset($edit_ward) && $edit_ward->status == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                <option value="Inactive" <?php echo (isset($edit_ward) && $edit_ward->status == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                            </select>
                                        </div>
                                        <?php if(isset($edit_ward)) { ?>
                                            <button type="submit" name="update_ward" class="btn btn-primary">Update Ward</button>
                                            <a href="wardno.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_ward" class="btn btn-success">Add Ward</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Wards</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Ward Number</th>
                                                <th>Ward Name</th>
                                                <th>Floor</th>
                                                <th>Type</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($wards as $ward) { ?>
                                                <tr>
                                                    <td><?php echo $ward->ward_number; ?></td>
                                                    <td><?php echo $ward->ward_name; ?></td>
                                                    <td><?php echo $ward->floor_number . ' - ' . $ward->floor_name; ?></td>
                                                    <td><?php echo $ward->ward_type; ?></td>
                                                    <td><?php echo $ward->description; ?></td>
                                                    <td><span class="badge badge-<?php echo $ward->status == 'Active' ? 'success' : 'danger'; ?>"><?php echo $ward->status; ?></span></td>
                                                    <td>
                                                        <a href="wardno.php?edit=<?php echo $ward->ward_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="wardno.php?delete=<?php echo $ward->ward_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this ward?')">Delete</a>
                                                        <a href="roomno.php?ward_id=<?php echo $ward->ward_id; ?>" class="btn btn-sm btn-info">View Rooms</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>