<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_emp_vitals'])) {
    $vit_number = $_POST['vit_number'];
    $vit_pat_number = $_POST['vit_pat_number'];
    $vit_bodytemp  = $_POST['vit_bodytemp'];
    $vit_heartpulse = $_POST['vit_heartpulse'];
    $vit_resprate  = $_POST['vit_resprate'];
    $vit_bloodpress = $_POST['vit_bloodpress'];
    
    $query = "INSERT INTO his_vitals (vit_number, vit_pat_number, vit_bodytemp, vit_heartpulse, vit_resprate, vit_bloodpress) VALUES(?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('ssssss', $vit_number, $vit_pat_number, $vit_bodytemp, $vit_heartpulse, $vit_resprate, $vit_bloodpress);
    $stmt->execute();
    
    if($stmt) {
        $success = "Employee Vitals Added Successfully";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Modern Healthcare Color Scheme */
        :root {
            --primary: #3a7bd5;
            --secondary: #00d2ff;
            --accent: #ff6b6b;
            --light: #f8f9fa;
            --dark: #343a40;
        }
        
        /* Animated Gradient Background */
        body {
            background: linear-gradient(-45deg, #f5f7fa, #e4f0fb, #f0f5ff, #e6f7ff);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            min-height: 100vh;
        }
        
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        /* Content Wrapper */
        .content-page {
            background: rgba(255, 255, 255, 0.95);
            margin-left: 260px;
            min-height: 100vh;
            box-shadow: 0 0 40px rgba(0, 0, 0, 0.08);
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Card Styling */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            animation: cardEnter 0.6s ease-out;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.12);
        }
        
        @keyframes cardEnter {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        
        /* Form Elements */
        .form-control {
            border-radius: 8px;
            padding: 12px 15px;
            border: 1px solid #e0e6f5;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(58, 123, 213, 0.25);
        }
        
        .form-control[readonly] {
            background-color: #f8fafc;
        }
        
        /* Button Styling */
        .btn-success {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            border-radius: 30px;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
            z-index: 1;
        }
        
        .btn-success:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 0;
            height: 100%;
            background: linear-gradient(to right, var(--secondary), var(--primary));
            transition: all 0.3s;
            z-index: -1;
        }
        
        .btn-success:hover:before {
            width: 100%;
        }
        
        .btn-success:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(58, 123, 213, 0.3);
        }
        
        /* Header Styling */
        .page-title {
            color: var(--dark);
            font-weight: 700;
            position: relative;
            display: inline-block;
            animation: titleEnter 0.8s ease-out;
        }
        
        @keyframes titleEnter {
            from { opacity: 0; transform: translateX(-20px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 0;
            width: 60px;
            height: 4px;
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border-radius: 3px;
        }
        
        .header-title {
            color: var(--dark);
            margin-bottom: 1.5rem;
            font-weight: 600;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 50px;
            height: 3px;
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border-radius: 3px;
        }
        
        /* Input Group Animations */
        .form-group {
            transition: all 0.3s;
        }
        
        .form-group:hover {
            transform: translateX(5px);
        }
        
        /* Vital Input Fields */
        .vital-input {
            position: relative;
        }
        
        .vital-input input {
            padding-right: 50px;
        }
        
        .vital-unit {
            position: absolute;
            right: 15px;
            top: 38px;
            color: var(--primary);
            font-weight: 600;
        }
        
        /* Success/Error Messages */
        .alert {
            border-radius: 8px;
            border: none;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            animation: alertEnter 0.5s ease-out;
        }
        
        @keyframes alertEnter {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }
        
        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .content-page {
                margin-left: 0;
            }
            
            .form-group:hover {
                transform: none;
            }
        }
    </style>
    <!-- Animate.css for additional animations -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <!-- FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $doc_number = $_GET['doc_number'];
            $ret = "SELECT * FROM his_docs WHERE doc_number=?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('s', $doc_number);
            $stmt->execute();
            $res = $stmt->get_result();
            while($row = $res->fetch_object()):
        ?>
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box animate__animated animate__fadeIn">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                            <li class="breadcrumb-item active">Capture Vitals</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Capture <?php echo htmlspecialchars($row->doc_fname); ?> <?php echo htmlspecialchars($row->doc_lname); ?> Vitals</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        
                        <!-- Success/Error Messages -->
                        <?php if(isset($success)): ?>
                            <div class="alert alert-success alert-dismissible fade show animate__animated animate__bounceIn">
                                <i class="fas fa-check-circle mr-2"></i>
                                <?php echo $success; ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        <?php if(isset($err)): ?>
                            <div class="alert alert-danger alert-dismissible fade show animate__animated animate__shakeX">
                                <i class="fas fa-exclamation-circle mr-2"></i>
                                <?php echo $err; ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Form row -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card animate__animated animate__zoomIn">
                                    <div class="card-body">
                                        <h4 class="header-title">Employee Vitals Information</h4>
                                        
                                        <!--Add Vitals Form-->
                                        <form method="post">
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label>Employee Name</label>
                                                    <input type="text" readonly class="form-control" 
                                                           value="<?php echo htmlspecialchars($row->doc_fname) . ' ' . htmlspecialchars($row->doc_lname); ?>">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label>Employee Department</label>
                                                    <input type="text" readonly class="form-control" 
                                                           value="<?php echo htmlspecialchars($row->doc_dept); ?>">
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="vit_pat_number">Employee Number</label>
                                                    <input type="text" required readonly name="vit_pat_number" 
                                                           value="<?php echo htmlspecialchars($row->doc_number); ?>" 
                                                           class="form-control" id="vit_pat_number">
                                                </div>
                                            </div>

                                            <hr>
                                            
                                            <!-- Hidden vital number field -->
                                            <div class="form-group" style="display:none">
                                                <?php 
                                                    $length = 5;    
                                                    $vit_no = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                                ?>
                                                <input type="text" name="vit_number" value="<?php echo $vit_no; ?>" class="form-control">
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-3 vital-input">
                                                    <label for="vit_bodytemp">Body Temperature</label>
                                                    <input type="text" required name="vit_bodytemp" class="form-control" 
                                                           id="vit_bodytemp" placeholder="36.5">
                                                    <span class="vital-unit">°C</span>
                                                </div>

                                                <div class="form-group col-md-3 vital-input">
                                                    <label for="vit_heartpulse">Heart Pulse/Beat</label>
                                                    <input type="text" required name="vit_heartpulse" class="form-control" 
                                                           id="vit_heartpulse" placeholder="72">
                                                    <span class="vital-unit">BPM</span>
                                                </div>

                                                <div class="form-group col-md-3 vital-input">
                                                    <label for="vit_resprate">Respiratory Rate</label>
                                                    <input type="text" required name="vit_resprate" class="form-control" 
                                                           id="vit_resprate" placeholder="16">
                                                    <span class="vital-unit">bpm</span>
                                                </div>

                                                <div class="form-group col-md-3 vital-input">
                                                    <label for="vit_bloodpress">Blood Pressure</label>
                                                    <input type="text" required name="vit_bloodpress" class="form-control" 
                                                           id="vit_bloodpress" placeholder="120/80">
                                                    <span class="vital-unit">mmHg</span>
                                                </div>
                                            </div>

                                            <div class="text-center mt-4">
                                                <button type="submit" name="add_emp_vitals" class="ladda-button btn btn-success" data-style="expand-right">
                                                    <span class="ladda-label">
                                                        <i class="fas fa-heartbeat mr-2"></i> Save Vitals
                                                    </span>
                                                </button>
                                            </div>
                                        </form>
                                        <!--End Vitals Form-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->
                    </div> <!-- container -->
                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->
            </div>
        <?php endwhile; ?>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
    <!-- Input validation -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add input validation for numeric fields
            document.getElementById('vit_bodytemp').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9.]/g, '');
            });
            
            document.getElementById('vit_heartpulse').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
            
            document.getElementById('vit_resprate').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
            
            document.getElementById('vit_bloodpress').addEventListener('input', function(e) {
                // Allow numbers and forward slash for blood pressure
                this.value = this.value.replace(/[^0-9\/]/g, '');
            });
        });
    </script>
</body>
</html>