<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['add_patient_mdr']))
    {
        $mdr_pat_name = $_POST['mdr_pat_name'];
        $mdr_pat_number = $_POST['mdr_pat_number'];
        $mdr_pat_adr = $_POST['mdr_pat_adr'];
        $mdr_pat_age = $_POST['mdr_pat_age'];
        $mdr_number = $_POST['mdr_number'];
        $mdr_pat_prescr = $_POST['mdr_pat_prescr'];
        $mdr_pat_ailment = $_POST['mdr_pat_ailment'];
        
        $query="INSERT INTO his_medical_records (mdr_pat_name, mdr_pat_number, mdr_pat_adr, mdr_pat_age, mdr_number, mdr_pat_prescr, mdr_pat_ailment) VALUES(?,?,?,?,?,?,?)";
        $stmt = $mysqli->prepare($query);
        $rc=$stmt->bind_param('sssssss', $mdr_pat_name, $mdr_pat_number, $mdr_pat_adr, $mdr_pat_age, $mdr_number, $mdr_pat_prescr, $mdr_pat_ailment);
        $stmt->execute();
        
        if($stmt)
        {
            $success = "Patient Medical Record Added";
        }
        else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $pat_number = $_GET['pat_number'];
                $ret="SELECT * FROM his_patients WHERE pat_number=?";
                $stmt= $mysqli->prepare($ret);
                $stmt->bind_param('s',$pat_number);
                $stmt->execute();
                $res=$stmt->get_result();
                while($row=$res->fetch_object())
                {
            ?>
                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Medical Records</a></li>
                                                <li class="breadcrumb-item active">Add Medical Record</li>
                                            </ol>
                                        </div>
                                        <h4 class="page-title">Add Medical Record</h4>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 
                            
                            <!-- Alert Messages -->
                            <?php if(isset($success)) { ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                    <?php echo $success; ?>
                                </div>
                            <?php } ?>
                            
                            <?php if(isset($err)) { ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                    <?php echo $err; ?>
                                </div>
                            <?php } ?>

                            <!-- Form row -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <h4 class="header-title">Patient Medical Record Form</h4>
                                            
                                            <!--Add Patient Form-->
                                            <form method="post">
                                                <div class="form-row">
                                                    <div class="form-group col-md-4">
                                                        <label class="col-form-label">Patient Name</label>
                                                        <input type="text" required readonly name="mdr_pat_name" value="<?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>" class="form-control" placeholder="Patient's Name">
                                                    </div>

                                                    <div class="form-group col-md-4">
                                                        <label class="col-form-label">Patient Age</label>
                                                        <input required type="text" readonly name="mdr_pat_age" value="<?php echo $row->pat_age;?>" class="form-control" placeholder="Patient's Age">
                                                    </div>

                                                    <div class="form-group col-md-4">
                                                        <label class="col-form-label">Patient Address</label>
                                                        <input required type="text" readonly name="mdr_pat_adr" value="<?php echo $row->pat_addr;?>" class="form-control" placeholder="Patient's Address">
                                                    </div>
                                                </div>

                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                        <label class="col-form-label">Patient Number</label>
                                                        <input type="text" required readonly name="mdr_pat_number" value="<?php echo $row->pat_number;?>" class="form-control" placeholder="Patient Number">
                                                    </div>

                                                    <div class="form-group col-md-6">
                                                        <label class="col-form-label">Patient Ailment</label>
                                                        <input required type="text" readonly name="mdr_pat_ailment" value="<?php echo $row->pat_ailment;?>" class="form-control" placeholder="Patient's Ailment">
                                                    </div>
                                                </div>
                                                <?php }?>
                                                
                                                <hr>
                                                
                                                <div class="form-row" style="display:none">
                                                    <div class="form-group col-md-2">
                                                        <?php 
                                                            $length = 5;    
                                                            $pres_no = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                                        ?>
                                                        <label class="col-form-label">Medical Record Number</label>
                                                        <input type="text" name="mdr_number" value="<?php echo $pres_no;?>" class="form-control">
                                                    </div>
                                                </div>
                                                
                                                <?php
                                                    $pres_pat_number = $_GET['pat_number'];
                                                    $ret="SELECT * FROM his_prescriptions WHERE pres_pat_number = ?";
                                                    $stmt= $mysqli->prepare($ret);
                                                    $stmt->bind_param('s',$pres_pat_number);
                                                    $stmt->execute();
                                                    $res=$stmt->get_result();
                                                    while($row=$res->fetch_object())
                                                    {
                                                ?>
                                                <div class="form-group">
                                                    <label class="col-form-label">Patient's Prescription</label>
                                                    <textarea required type="text" class="form-control" name="mdr_pat_prescr" id="prescription-editor"><?php echo $row->pres_ins;?></textarea>
                                                </div>
                                                <?php }?>

                                                <div class="form-group text-right mt-4">
                                                    <button type="submit" name="add_patient_mdr" class="btn btn-primary btn-lg">
                                                        <i class="fas fa-save mr-2"></i> Save Medical Record
                                                    </button>
                                                </div>
                                            </form>
                                            <!--End Patient Form-->
                                        </div> <!-- end card-body -->
                                    </div> <!-- end card-->
                                </div> <!-- end col -->
                            </div>
                            <!-- end row -->

                        </div> <!-- container -->

                    </div> <!-- content -->

                    <!-- Footer Start -->
                    <?php include('assets/inc/footer.php');?>
                    <!-- end Footer -->

                </div>
            

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- TinyMCE Text Editor -->
        <script src="https://cdn.tiny.cloud/1/YOUR_API_KEY/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
        <script>
            tinymce.init({
                selector: '#prescription-editor',
                plugins: 'advlist autolink lists link image charmap print preview anchor',
                toolbar: 'undo redo | formatselect | bold italic | alignleft aligncenter alignright | bullist numlist outdent indent',
                menubar: false,
                height: 300,
                content_style: 'body { font-family: Arial, sans-serif; font-size: 14px }'
            });
        </script>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Custom styling */
            .card {
                border-radius: 10px;
                box-shadow: 0 0 15px rgba(0,0,0,0.1);
            }
            
            .card-body {
                padding: 2rem;
            }
            
            .form-control[readonly] {
                background-color: #f8f9fa;
                border-color: #e9ecef;
            }
            
            .header-title {
                color: #3bafda;
                margin-bottom: 1.5rem;
                font-weight: 600;
            }
            
            .btn-lg {
                padding: 0.5rem 1.5rem;
                font-size: 1.05rem;
            }
            
            .tox-tinymce {
                border-radius: 5px !important;
                border: 1px solid #ced4da !important;
            }
            
            hr {
                margin: 1.5rem 0;
                border-color: rgba(0,0,0,0.1);
            }
        </style>
        
    </body>
</html>