<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['assaign_dept'])) {
        $doc_dept = $_POST['doc_dept'];
        $doc_number = $_GET['doc_number'];

        $query = "UPDATE his_docs SET doc_dept=? WHERE doc_number = ?";
        $stmt = $mysqli->prepare($query);
        $rc = $stmt->bind_param('ss', $doc_dept, $doc_number);
        $stmt->execute();
        
        if($stmt) {
            $success = "Employee Assigned Department";
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --success-color: #00b46e;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .profile-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 25px 0;
            border-radius: 12px 12px 0 0;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .profile-card {
            background: white;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
            transition: all 0.3s ease;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .profile-card:hover {
            box-shadow: 0 10px 30px rgba(67, 97, 238, 0.15);
        }
        
        .profile-img-container {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 4px solid white;
            overflow: hidden;
            margin: -50px auto 20px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            background-color: #f0f4ff;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-color);
            font-size: 2rem;
            font-weight: bold;
        }
        
        .form-section {
            padding: 30px;
        }
        
        .section-title {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 50px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .form-control {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s ease;
            background-color: #f8f9fc;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.1);
            background-color: white;
        }
        
        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%234361ee' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            background-size: 12px;
        }
        
        .btn-assign {
            background: var(--primary-color);
            border: none;
            padding: 12px 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            border-radius: 8px;
            width: 100%;
            max-width: 250px;
            margin: 20px auto 0;
            display: block;
        }
        
        .btn-assign:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }
        
        .readonly-field {
            background-color: #f0f4ff;
            color: var(--medium-text);
        }
        
        @media (max-width: 768px) {
            .profile-img-container {
                width: 80px;
                height: 80px;
                margin-top: -40px;
                font-size: 1.5rem;
            }
            
            .form-section {
                padding: 20px;
            }
            
            .btn-assign {
                width: 100%;
                max-width: none;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Employee</a></li>
                                        <li class="breadcrumb-item active">Assign Department</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Department Assignment</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <?php
                        $doc_number = $_GET['doc_number'];
                        $ret = "SELECT * FROM his_docs WHERE doc_number=?";
                        $stmt = $mysqli->prepare($ret);
                        $stmt->bind_param('i', $doc_number);
                        $stmt->execute();
                        $res = $stmt->get_result();
                        $row = $res->fetch_object();
                    ?>
                    
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="profile-card">
                                <div class="profile-header">
                                    <h3>Assign Department</h3>
                                </div>
                                
                                <div class="profile-img-container">
                                    <?php echo strtoupper(substr($row->doc_fname, 0, 1)) . strtoupper(substr($row->doc_lname, 0, 1)); ?>
                                </div>
                                
                                <div class="form-section">
                                    <h4 class="section-title">Employee Information</h4>
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>First Name</label>
                                                <input type="text" required readonly value="<?php echo $row->doc_fname; ?>" class="form-control readonly-field">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Last Name</label>
                                                <input required type="text" readonly value="<?php echo $row->doc_lname; ?>" class="form-control readonly-field">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Email Address</label>
                                            <input required type="email" readonly value="<?php echo $row->doc_email; ?>" class="form-control readonly-field">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Department</label>
                                            <select required name="doc_dept" class="form-control">
                                                <option value="">Select Department</option>
                                                <option value="Patient Registration" <?php echo ($row->doc_dept == 'Patient Registration') ? 'selected' : ''; ?>>Patient Registration</option>
                                                <option value="Laboratory" <?php echo ($row->doc_dept == 'Laboratory') ? 'selected' : ''; ?>>Laboratory</option>
                                                <option value="Pharmacy" <?php echo ($row->doc_dept == 'Pharmacy') ? 'selected' : ''; ?>>Pharmacy</option>
                                                <option value="Accounting" <?php echo ($row->doc_dept == 'Accounting') ? 'selected' : ''; ?>>Accounting</option>
                                                <option value="Surgery | Theatre" <?php echo ($row->doc_dept == 'Surgery | Theatre') ? 'selected' : ''; ?>>Surgery | Theatre</option>
                                            </select>
                                        </div>                                         

                                        <button type="submit" name="assaign_dept" class="btn btn-assign">
                                            <i class="mdi mdi-check-circle-outline mr-1"></i> Assign Department
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>
</html>