<?php
    session_start();
    include('assets/inc/config.php'); // Get configuration file
    
    // Fetch system settings
    $query = "SELECT * FROM his_system_settings LIMIT 1";
    $result = $mysqli->query($query);
    $settings = $result->fetch_assoc();

    if(isset($_POST['admin_login']))
    {
        $ad_email = $_POST['ad_email'];
        $ad_pwd = sha1(md5($_POST['ad_pwd'])); // Double encrypt to increase security
        $stmt = $mysqli->prepare("SELECT ad_email, ad_pwd, ad_id FROM his_admin WHERE ad_email=? AND ad_pwd=? "); // SQL to log in user
        $stmt->bind_param('ss', $ad_email, $ad_pwd); // Bind fetched parameters
        $stmt->execute(); // Execute bind
        $stmt->bind_result($ad_email, $ad_pwd, $ad_id); // Bind result
        $rs = $stmt->fetch();
        $_SESSION['ad_id'] = $ad_id; // Assign session to admin id
        
        if($rs) {
            // If successful
            header("location:dashboard.php");
        } else {
            $err = "Access Denied Please Check Your Credentials";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <meta charset="utf-8" />
    <title><?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Management System'); ?> - Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Management System'); ?>" name="description" />
    <meta content="" name="MartDevelopers" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="../../image/favicon.png">

    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!--Load Sweet Alert Javascript-->
    <script src="assets/js/swal.js"></script>
    
    <!--Inject SWAL-->
    <?php if(isset($success)) {?>
    <!--This code for injecting an alert-->
    <script>
        setTimeout(function () { 
            swal("Success","<?php echo $success;?>","success");
        }, 100);
    </script>
    <?php } ?>

    <?php if(isset($err)) {?>
    <!--This code for injecting an alert-->
    <script>
        setTimeout(function () { 
            swal("Failed","<?php echo $err;?>","Failed");
        }, 100);
    </script>
    <?php } ?>
</head>

<body class="authentication-bg authentication-bg-pattern" style="background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), 
                    url('../../image/pro4.jpg') no-repeat center center fixed;
        background-size: cover;">

    <div class="account-pages mt-5 mb-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card bg-pattern">
                        <div class="card-body p-4">
                            <div class="text-center w-75 m-auto">
                                <a href="index.php">
                                    <span>
                                        <?php if(!empty($settings['system_logo'])): ?>
                                            <img src="<?php echo htmlspecialchars($settings['system_logo']); ?>" alt="<?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Logo'); ?>" height="100">
                                        <?php else: ?>
                                            <img src="../../image/logo.png" alt="Default Logo" height="100">
                                        <?php endif; ?>
                                    </span>
                                </a>
                                <h4 class="mt-3 mb-3"><?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Management System'); ?></h4>
                                <p class="text-muted mb-4">Enter your email address and password to access admin panel.</p>
                            </div>

                            <form method='post'>
                                <!-- Email Field -->
                                <div class="form-group mb-4">
                                    <label for="emailaddress" class="form-label fw-semibold" style="color: #495057; margin-bottom: 8px;">Email Address</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light border-end-0" style="border-radius: 8px 0 0 8px; padding: 0 15px;">
                                            <i class="mdi mdi-email-outline text-muted"></i>
                                        </span>
                                        <input class="form-control" 
                                               name="ad_email" 
                                               type="email" 
                                               id="emailaddress" 
                                               required 
                                               placeholder="Enter your email"
                                               style="padding: 12px 15px;
                                                      border-radius: 0 8px 8px 0;
                                                      border-left: 0;
                                                      transition: all 0.3s ease;
                                                      height: 46px;">
                                    </div>
                                    <small class="text-muted mt-1 d-block" style="font-size: 12px;">We'll never share your email</small>
                                </div>

                                <!-- Password Field with Toggle -->
                                <div class="form-group mb-4">
                                    <label for="password" class="form-label fw-semibold" style="color: #495057; margin-bottom: 8px;">Password</label>
                                    <div class="input-group password-toggle-group">
                                        <span class="input-group-text bg-light border-end-0" style="border-radius: 8px 0 0 8px; padding: 0 15px;">
                                            <i class="mdi mdi-lock-outline text-muted"></i>
                                        </span>
                                        <input class="form-control" 
                                               name="ad_pwd" 
                                               type="password" 
                                               id="password" 
                                               required 
                                               placeholder="Enter your password"
                                               style="padding: 12px 15px;
                                                      border-radius: 0 8px 8px 0;
                                                      border-left: 0;
                                                      transition: all 0.3s ease;
                                                      height: 46px;">
                                        <button type="button" class="input-group-text bg-light border-start-0 password-toggle-btn" 
                                                style="border-radius: 0 8px 8px 0; cursor: pointer;">
                                            <i class="mdi mdi-eye-off-outline text-muted"></i>
                                        </button>
                                    </div>
                                    <div class="d-flex justify-content-end mt-1">
                                        <a href="pwd_reset.php" class="text-decoration-none" style="font-size: 13px; color: #6c757d;">Forgot password?</a>
                                    </div>
                                </div>

                                <!-- Login Button -->
                                <div class="form-group mb-0 text-center">
                                    <button class="btn btn-primary btn-block" 
                                            name="admin_login" 
                                            type="submit"
                                            style="padding: 12px;
                                                   border-radius: 8px;
                                                   font-weight: 600;
                                                   letter-spacing: 0.5px;
                                                   transition: all 0.3s ease;
                                                   height: 46px;">
                                        <i class="mdi mdi-login mr-2"></i> Admin Log In
                                    </button>
                                </div>
                            </form>

                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

                    <div class="row mt-3">
                        <div class="col-12 text-center">
                            <p> <a href="pwd_reset.php" class="text-white-50 ml-1">Forgot your password?</a></p>
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->

    <?php include ("assets/inc/footer1.php");?>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- JavaScript for Password Toggle -->
    <script>
        document.querySelector('.password-toggle-btn').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const icon = this.querySelector('i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.replace('mdi-eye-off-outline', 'mdi-eye-outline');
            } else {
                passwordInput.type = 'password';
                icon.classList.replace('mdi-eye-outline', 'mdi-eye-off-outline');
            }
        });
    </script>

    <style>
        #emailaddress:focus, #password:focus {
            border-color: #6658dd;
            box-shadow: 0 0 0 0.2rem rgba(102, 88, 221, 0.25);
            outline: 0;
        }
        .input-group-text {
            transition: all 0.3s ease;
        }
        #emailaddress:focus ~ .input-group-text,
        #password:focus ~ .input-group-text {
            border-color: #6658dd;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 88, 221, 0.25);
        }
        .password-toggle-btn:hover {
            background-color: #e9ecef !important;
        }
    </style>
</body>
</html>