
<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];

// Initialize variables
$system_name = $system_email = $system_phone = $system_address = $system_logo = $system_mission = '';
$insurance_name = $insurance_id = '';
$department_type = $department_name = $opd_fee = $ipd_fee = $department_description = $ailment_name = '';
$errors = [];

if(isset($_POST['update_department'])) {
    $department_id = intval($_POST['department_id']);
    $department_type = trim($_POST['department_type']);
    $department_name = trim($_POST['department_name']);
    $opd_fee = ($department_type == 'OutPatient') ? trim($_POST['opd_fee']) : 0;
    $ipd_fee = ($department_type == 'InPatient') ? trim($_POST['ipd_fee']) : 0;
    $department_description = trim($_POST['department_description']);
    $ailment_name = trim($_POST['ailment_name']);

    if(empty($department_name)) {
        $errors['department_name'] = 'Department name is required';
    }

    if(empty($errors)) {
        $query = "UPDATE his_departments SET 
                 department_type = ?, 
                 department_name = ?, 
                 opd_fee = ?, 
                 ipd_fee = ?,
                 department_description = ?, 
                 ailment_name = ?
                 WHERE department_id = ?";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('ssddssi', $department_type, $department_name, $opd_fee, $ipd_fee, $department_description, $ailment_name, $department_id);
        
        if($stmt->execute()) {
            $_SESSION['success'] = "Department updated successfully";
            header("Location: {$_SERVER['PHP_SELF']}#ipd-opd-settings");
            exit();
        } else {
            $errors['database'] = "Error updating department: " . $stmt->error;
        }
    }
}

// Handle General System Settings
if(isset($_POST['update_system_settings'])) {
    $system_name = trim($_POST['system_name']);
    $system_email = trim($_POST['system_email']);
    $system_phone = trim($_POST['system_phone']);
    $system_address = trim($_POST['system_address']);
    $system_mission = trim($_POST['system_mission']);
    
    // Validate inputs
    if(empty($system_name)) {
        $errors['system_name'] = 'System name is required';
    }
    
    if(!empty($system_email) && !filter_var($system_email, FILTER_VALIDATE_EMAIL)) {
        $errors['system_email'] = 'Invalid email format';
    }
    
    // Handle file upload (logo)
    if(isset($_FILES['system_logo']) && $_FILES['system_logo']['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $file_name = $_FILES['system_logo']['name'];
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        
        if(in_array($file_ext, $allowed)) {
            $new_name = 'logo_' . time() . '.' . $file_ext;
            $upload_path = 'assets/uploads/' . $new_name;
            
            if(move_uploaded_file($_FILES['system_logo']['tmp_name'], $upload_path)) {
                $system_logo = $upload_path;
                // Delete old logo if exists
                $old_logo = $mysqli->query("SELECT system_logo FROM his_system_settings LIMIT 1")->fetch_assoc();
                if($old_logo && file_exists($old_logo['system_logo'])) {
                    unlink($old_logo['system_logo']);
                }
            } else {
                $errors['system_logo'] = 'Failed to upload logo';
            }
        } else {
            $errors['system_logo'] = 'Invalid file type. Only JPG, JPEG, PNG, GIF are allowed';
        }
    }
    
    if(empty($errors)) {
        // Check if settings exist
        $check = $mysqli->query("SELECT COUNT(*) as count FROM his_system_settings")->fetch_assoc();
        
        if($check['count'] > 0) {
            // Update existing settings
            $query = "UPDATE his_system_settings SET 
                     system_name = ?, 
                     system_email = ?, 
                     system_phone = ?, 
                     system_address = ?, 
                     system_mission = ?" . 
                     ($system_logo ? ", system_logo = ?" : "") . " 
                     WHERE id = 1";
            
            $stmt = $mysqli->prepare($query);
            
            if($system_logo) {
                $stmt->bind_param('ssssss', $system_name, $system_email, $system_phone, $system_address, $system_mission, $system_logo);
            } else {
                $stmt->bind_param('sssss', $system_name, $system_email, $system_phone, $system_address, $system_mission);
            }
        } else {
            // Insert new settings
            $query = "INSERT INTO his_system_settings (system_name, system_email, system_phone, system_address, system_mission" . 
                     ($system_logo ? ", system_logo" : "") . ") 
                     VALUES (?, ?, ?, ?, ?" . ($system_logo ? ", ?" : "") . ")";
            
            $stmt = $mysqli->prepare($query);
            
            if($system_logo) {
                $stmt->bind_param('ssssss', $system_name, $system_email, $system_phone, $system_address, $system_mission, $system_logo);
            } else {
                $stmt->bind_param('sssss', $system_name, $system_email, $system_phone, $system_address, $system_mission);
            }
        }
        
        if($stmt->execute()) {
            $_SESSION['success'] = "System settings updated successfully";
            header("Location: {$_SERVER['PHP_SELF']}");
            exit();
        } else {
            $errors['database'] = "Error updating system settings: " . $stmt->error;
        }
    }
}

// Handle Insurance Settings
if(isset($_POST['add_insurance'])) {
    $insurance_name = trim($_POST['insurance_name']);
    
    if(empty($insurance_name)) {
        $errors['insurance_name'] = 'Insurance name is required';
    }
    
    if(empty($errors)) {
        $query = "INSERT INTO his_insurance (insurance_name) VALUES (?)";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('s', $insurance_name);
        
        if($stmt->execute()) {
            $_SESSION['success'] = "Insurance added successfully";
            header("Location: {$_SERVER['PHP_SELF']}#insurance-settings");
            exit();
        } else {
            $errors['database'] = "Error adding insurance: " . $stmt->error;
        }
    }
}

// Handle Delete Insurance
if(isset($_GET['delete_insurance'])) {
    $insurance_id = intval($_GET['delete_insurance']);
    
    $query = "DELETE FROM his_insurance WHERE insurance_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $insurance_id);
    
    if($stmt->execute()) {
        $_SESSION['success'] = "Insurance deleted successfully";
        header("Location: {$_SERVER['PHP_SELF']}#insurance-settings");
        exit();
    } else {
        $errors['database'] = "Error deleting insurance: " . $stmt->error;
    }
}

// Handle IPD/OPD Settings
if(isset($_POST['add_department'])) {
    $department_type = trim($_POST['department_type']);
    $department_name = trim($_POST['department_name']);
    $errors = []; // Initialize errors array
    
    // Get all fields
    $opd_fee = ($department_type == 'OutPatient') ? trim($_POST['opd_fee']) : 0;
    $ipd_fee = ($department_type == 'InPatient') ? trim($_POST['ipd_fee']) : 0;
    $department_description = trim($_POST['department_description']);
    $ailment_name = trim($_POST['ailment_name']);

    // Common validations
    if(empty($department_name)) {
        $errors['department_name'] = 'Department name is required';
    }
    if(empty($department_type)) {
        $errors['department_type'] = 'Department type is required';
    }
    if(empty($ailment_name)) {
        $errors['ailment_name'] = 'Ailment name is required';
    }
    
    // Fee validations
    if($department_type == 'OutPatient' && empty($opd_fee)) {
        $errors['opd_fee'] = 'OutPatient fee is required';
    }
    if($department_type == 'InPatient' && empty($ipd_fee)) {
        $errors['ipd_fee'] = 'IPD fee is required';
    }

    if(empty($errors)) {
        $query = "INSERT INTO his_departments 
                 (department_type, department_name, opd_fee, ipd_fee, department_description, ailment_name) 
                 VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('ssddss', 
            $department_type, 
            $department_name, 
            $opd_fee,
            $ipd_fee,
            $department_description, 
            $ailment_name
        );
        
        if($stmt->execute()) {
            $_SESSION['success'] = "Department added successfully";
            header("Location: {$_SERVER['PHP_SELF']}#ipd-opd-settings");
            exit();
        } else {
            $errors['database'] = "Error adding department: " . $stmt->error;
        }
    }
}

// Handle Delete Department
if(isset($_GET['delete_department'])) {
    $department_id = intval($_GET['delete_department']);
    
    $query = "DELETE FROM his_departments WHERE department_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $department_id);
    
    if($stmt->execute()) {
        $_SESSION['success'] = "Department deleted successfully";
        header("Location: {$_SERVER['PHP_SELF']}#ipd-opd-settings");
        exit();
    } else {
        $errors['database'] = "Error deleting department: " . $stmt->error;
    }
}

// Fetch current system settings
$system_settings = $mysqli->query("SELECT * FROM his_system_settings LIMIT 1")->fetch_assoc();
if($system_settings) {
    $system_name = $system_settings['system_name'];
    $system_email = $system_settings['system_email'];
    $system_phone = $system_settings['system_phone'];
    $system_address = $system_settings['system_address'];
    $system_logo = $system_settings['system_logo'];
    $system_mission = $system_settings['system_mission'];
}

// Fetch all insurances
$insurances = $mysqli->query("SELECT * FROM his_insurance ORDER BY insurance_name");

// Fetch all departments
$departments = $mysqli->query("SELECT * FROM his_departments ORDER BY department_type, department_name");
?>

<!DOCTYPE html>
<html lang="en">

    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }
        
        body {
            background-color: var(--light);
            font-family: 'Inter', sans-serif;
        }
        
        .card {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
        }
        
        .card-body {
            padding: 2rem;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark);
            font-weight: 700;
        }
        
        .form-label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
        }
        
        .form-control {
            border-radius: 8px;
            border: 1px solid var(--border);
            padding: 10px 15px;
            height: calc(2.25rem + 8px);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }
        
        .btn-primary {
            background-color: var(--primary);
            border-color: var(--primary);
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .btn-success {
            background-color: var(--success);
            border-color: var(--success);
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .btn-danger {
            background-color: var(--danger);
            border-color: var(--danger);
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .btn-secondary {
            background-color: var(--gray);
            border-color: var(--gray);
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .alert {
            border-radius: 8px;
        }
       
       
        .tab-content {
            padding: 20px 0;
        }
        
        .logo-preview {
            max-width: 200px;
            max-height: 100px;
            margin-bottom: 15px;
            border: 1px solid var(--border);
            padding: 5px;
            border-radius: 8px;
        }
        
        .table {
            border-radius: 8px;
            overflow: hidden;
        }
        
        .table th {
            background-color: var(--primary-light);
            color: var(--primary);
            font-weight: 600;
        }
        
        .badge-opd {
            background-color: #e3f2fd;
            color: #1976d2;
        }
        
        .badge-ipd {
            background-color: #e8f5e9;
            color: #388e3c;
        }
        
        .is-invalid {
            border-color: var(--danger) !important;
        }
        
        .invalid-feedback {
            color: var(--danger);
            font-size: 0.875rem;
        }
        
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            
            .nav-tabs .nav-link {
                padding: 10px 15px;
                font-size: 0.9rem;
            }
        }
    </style>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item active">System Settings</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">System Settings</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Display alerts -->
                    <?php if(isset($_SESSION['success'])) { ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle mr-2"></i> <?php echo $_SESSION['success']; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php unset($_SESSION['success']); ?>
                    <?php } ?>
                    
                    <?php if(!empty($errors)) { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle mr-2"></i> Please correct the following errors:
                            <ul class="mb-0">
                                <?php foreach($errors as $error): ?>
                                    <li><?php echo $error; ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php } ?>

                    <!-- Tabs row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" id="general-tab" data-toggle="tab" href="#general-settings" role="tab" aria-controls="general" aria-selected="true">
                                                <i class="fas fa-cog mr-1"></i> General Settings
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="insurance-tab" data-toggle="tab" href="#insurance-settings" role="tab" aria-controls="insurance" aria-selected="false">
                                                <i class="fas fa-shield-alt mr-1"></i> Insurance Settings
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="ipd-opd-tab" data-toggle="tab" href="#ipd-opd-settings" role="tab" aria-controls="ipd-opd" aria-selected="false">
                                                <i class="fas fa-procedures mr-1"></i> IPD/OPD Settings
                                            </a>
                                        </li>
                                    </ul>
                                    
                                    <div class="tab-content" id="settingsTabsContent">
                                        <!-- General Settings Tab -->
                                        <div class="tab-pane fade show active" id="general-settings" role="tabpanel" aria-labelledby="general-tab">
                                            <h4 class="header-title mb-4">General System Settings</h4>
                                            
                                            <form method="post" enctype="multipart/form-data">
                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                        <label for="system_name" class="form-label">System Name</label>
                                                        <input type="text" required name="system_name" class="form-control <?php echo isset($errors['system_name']) ? 'is-invalid' : ''; ?>" 
                                                            id="system_name" value="<?php echo htmlspecialchars($system_name); ?>">
                                                        <?php if(isset($errors['system_name'])): ?>
                                                            <div class="invalid-feedback"><?php echo $errors['system_name']; ?></div>
                                                        <?php endif; ?>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-6">
                                                        <label for="system_email" class="form-label">System Email</label>
                                                        <input type="email" name="system_email" class="form-control <?php echo isset($errors['system_email']) ? 'is-invalid' : ''; ?>" 
                                                            id="system_email" value="<?php echo htmlspecialchars($system_email); ?>">
                                                        <?php if(isset($errors['system_email'])): ?>
                                                            <div class="invalid-feedback"><?php echo $errors['system_email']; ?></div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                        <label for="system_phone" class="form-label">System Phone</label>
                                                        <input type="text" name="system_phone" class="form-control" 
                                                            id="system_phone" value="<?php echo htmlspecialchars($system_phone); ?>">
                                                    </div>
                                                    
                                                    <div class="form-group col-md-6">
                                                        <label for="system_logo" class="form-label">System Logo</label>
                                                        <input type="file" name="system_logo" class="form-control-file <?php echo isset($errors['system_logo']) ? 'is-invalid' : ''; ?>" 
                                                            id="system_logo">
                                                        <?php if(isset($errors['system_logo'])): ?>
                                                            <div class="invalid-feedback d-block"><?php echo $errors['system_logo']; ?></div>
                                                        <?php endif; ?>
                                                        
                                                        <?php if($system_logo && file_exists($system_logo)): ?>
                                                            <div class="logo-preview-container mt-2">
                                                                <p class="mb-1">Current Logo:</p>
                                                                <img src="<?php echo $system_logo; ?>" alt="System Logo" class="logo-preview">
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="system_address" class="form-label">System Address</label>
                                                    <textarea name="system_address" class="form-control" id="system_address" rows="3"><?php echo htmlspecialchars($system_address); ?></textarea>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="system_mission" class="form-label">Mission Statement</label>
                                                    <textarea name="system_mission" class="form-control" id="system_mission" rows="5"><?php echo htmlspecialchars($system_mission); ?></textarea>
                                                </div>
                                                
                                                <button type="submit" name="update_system_settings" class="btn btn-primary">
                                                    <i class="fas fa-save mr-2"></i> Save Settings
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <!-- Insurance Settings Tab -->
                                        <div class="tab-pane fade" id="insurance-settings" role="tabpanel" aria-labelledby="insurance-tab">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h4 class="header-title mb-4">Add New Insurance</h4>
                                                    
                                                    <form method="post">
                                                        <div class="form-group">
                                                            <label for="insurance_name" class="form-label">Insurance Name</label>
                                                            <input type="text" required name="insurance_name" class="form-control <?php echo isset($errors['insurance_name']) ? 'is-invalid' : ''; ?>" 
                                                                id="insurance_name" value="<?php echo htmlspecialchars($insurance_name); ?>">
                                                            <?php if(isset($errors['insurance_name'])): ?>
                                                                <div class="invalid-feedback"><?php echo $errors['insurance_name']; ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <button type="submit" name="add_insurance" class="btn btn-success">
                                                            <i class="fas fa-plus mr-2"></i> Add Insurance
                                                        </button>
                                                    </form>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <h4 class="header-title mb-4">Existing Insurances</h4>
                                                    
                                                    <?php if($insurances->num_rows > 0): ?>
                                                        <div class="table-responsive">
                                                            <table class="table table-hover table-centered mb-0">
                                                                <thead>
                                                                    <tr>
                                                                        <th>#</th>
                                                                        <th>Insurance Name</th>
                                                                        <th>Actions</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php $counter = 1; while($insurance = $insurances->fetch_assoc()): ?>
                                                                        <tr>
                                                                            <td><?php echo $counter++; ?></td>
                                                                            <td><?php echo htmlspecialchars($insurance['insurance_name']); ?></td>
                                                                            <td>
                                                                               
                                                                                <a href="?delete_insurance=<?php echo $insurance['insurance_id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this insurance?');">
                                                                                    <i class="fas fa-trash"></i>
                                                                                </a>
                                                                            </td>
                                                                        </tr>
                                                                    <?php endwhile; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="alert alert-info">
                                                            No insurances found. Please add some insurances.
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- IPD/OPD Settings Tab -->
                                        <div class="tab-pane fade" id="ipd-opd-settings" role="tabpanel" aria-labelledby="ipd-opd-tab">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h4 class="header-title mb-4">Add New Department</h4>
                                                    
                                                    <form method="post">
                                                        <div class="form-group">
                                                            <label for="department_type" class="form-label">Department Type</label>
                                                            <select name="department_type" class="form-control" id="department_type" required>
                                                                <option value="">Select Type</option>
                                                                <option value="OutPatient" <?php echo ($department_type == 'OutPatient') ? 'selected' : ''; ?>>OPD (Outpatient Department)</option>
                                                                <option value="InPatient" <?php echo ($department_type == 'InPatient') ? 'selected' : ''; ?>>IPD (Inpatient Department)</option>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="department_name" class="form-label">Department Name</label>
                                                            <input type="text" required name="department_name" class="form-control <?php echo isset($errors['department_name']) ? 'is-invalid' : ''; ?>" 
                                                                id="department_name" value="<?php echo htmlspecialchars($department_name); ?>">
                                                            <?php if(isset($errors['department_name'])): ?>
                                                                <div class="invalid-feedback"><?php echo $errors['department_name']; ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="ailment_name" class="form-label">Ailment Name</label>
                                                            <input type="text" required name="ailment_name" class="form-control <?php echo isset($errors['ailment_name']) ? 'is-invalid' : ''; ?>" 
                                                                id="ailment_name" value="<?php echo htmlspecialchars($ailment_name); ?>">
                                                            <?php if(isset($errors['ailment_name'])): ?>
                                                                <div class="invalid-feedback"><?php echo $errors['ailment_name']; ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <div class="form-group opd-fields" style="<?php echo ($department_type != 'OutPatient') ? 'display: none;' : ''; ?>">
                                                            <label for="opd_fee" class="form-label">OPD Fee</label>
                                                            <input type="number" step="0.01" name="opd_fee" class="form-control <?php echo isset($errors['opd_fee']) ? 'is-invalid' : ''; ?>" 
                                                                id="opd_fee" value="<?php echo htmlspecialchars($opd_fee); ?>">
                                                            <?php if(isset($errors['opd_fee'])): ?>
                                                                <div class="invalid-feedback"><?php echo $errors['opd_fee']; ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <div class="form-group ipd-fields" style="<?php echo ($department_type != 'InPatient') ? 'display: none;' : ''; ?>">
                                                            <label for="ipd_fee" class="form-label">IPD Fee</label>
                                                            <input type="number" step="0.01" name="ipd_fee" class="form-control <?php echo isset($errors['ipd_fee']) ? 'is-invalid' : ''; ?>" 
                                                                id="ipd_fee" value="<?php echo htmlspecialchars($ipd_fee); ?>">
                                                            <?php if(isset($errors['ipd_fee'])): ?>
                                                                <div class="invalid-feedback"><?php echo $errors['ipd_fee']; ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="department_description" class="form-label">Description</label>
                                                            <textarea name="department_description" class="form-control" id="department_description" rows="3"><?php echo htmlspecialchars($department_description); ?></textarea>
                                                        </div>
                                                        
                                                        <button type="submit" name="add_department" class="btn btn-success">
                                                            <i class="fas fa-plus mr-2"></i> Add Department
                                                        </button>
                                                    </form>
                                                </div>
                                                
                                               <div class="col-md-6">
    <h4 class="header-title mb-4">Existing Departments</h4>
    
    <?php if($departments->num_rows > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover table-centered mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Type</th>
                        <th>Name</th>
                        <th>Details</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $counter = 1; while($department = $departments->fetch_assoc()): ?>
                        <tr id="row-<?php echo $department['department_id']; ?>">
                            <td><?php echo $counter++; ?></td>
                            <td>
                                <span class="badge <?php echo ($department['department_type'] == 'OutPatient') ? 'badge-opd' : 'badge-ipd'; ?> p-2">
                                    <?php echo $department['department_type']; ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($department['department_name']); ?></td>
                            <td>
                                <strong>Ailment:</strong> <?php echo htmlspecialchars($department['ailment_name']); ?><br>
                                <?php if($department['department_type'] == 'OutPatient'): ?>
                                    <strong>OPD Fee:</strong> $<?php echo number_format($department['opd_fee'], 2); ?><br>
                                <?php else: ?>
                                    <strong>IPD Fee:</strong> $<?php echo number_format($department['ipd_fee'], 2); ?><br>
                                <?php endif; ?>
                                <?php echo htmlspecialchars($department['department_description']); ?>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-primary edit-btn" data-id="<?php echo $department['department_id']; ?>">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <a href="?delete_department=<?php echo $department['department_id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this department?');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        
                        <!-- Hidden Edit Form -->
                        <tr id="edit-form-<?php echo $department['department_id']; ?>" style="display: none;" class="edit-form-row">
                            <td colspan="5">
                                <form class="edit-department-form" data-id="<?php echo $department['department_id']; ?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Department Type</label>
                                                <select name="department_type" class="form-control">
                                                    <option value="OutPatient" <?php echo ($department['department_type'] == 'OutPatient') ? 'selected' : ''; ?>>OPD</option>
                                                    <option value="InPatient" <?php echo ($department['department_type'] == 'InPatient') ? 'selected' : ''; ?>>IPD</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Department Name</label>
                                                <input type="text" name="department_name" class="form-control" value="<?php echo htmlspecialchars($department['department_name']); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Ailment Name</label>
                                                <input type="text" name="ailment_name" class="form-control" value="<?php echo htmlspecialchars($department['ailment_name']); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label><?php echo ($department['department_type'] == 'OutPatient') ? 'OutPatient' : 'InPatient'; ?> Fee</label>
                                                <input type="number" name="<?php echo ($department['department_type'] == 'OutPatient') ? 'opd_fee' : 'ipd_fee'; ?>" class="form-control" 
                                                    value="<?php echo ($department['department_type'] == 'OutPatient') ? $department['opd_fee'] : $department['ipd_fee']; ?>" step="0.01">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Description</label>
                                                <textarea name="department_description" class="form-control"><?php echo htmlspecialchars($department['department_description']); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-right mt-2">
                                        <button type="button" class="btn btn-secondary cancel-edit" data-id="<?php echo $department['department_id']; ?>">Cancel</button>
                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                    </div>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info">
            No departments found. Please add some departments.
        </div>
    <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    // Show/hide fee fields based on department type selection
    $('#department_type').change(function() {
        var type = $(this).val();
                if (type === 'OutPatient') {
            $('.opd-fields').show();
            $('.ipd-fields').hide();
        } else if (type === 'InPatient') {
            $('.opd-fields').hide();
            $('.ipd-fields').show();
        } else {
            $('.opd-fields').hide();
            $('.ipd-fields').hide();
        }
    });

    // Department edit functionality
    $('.edit-btn').click(function() {
        var id = $(this).data('id');
        $('#row-' + id).hide();
        $('#edit-form-' + id).show();
    });

    $('.cancel-edit').click(function() {
        var id = $(this).data('id');
        $('#edit-form-' + id).hide();
        $('#row-' + id).show();
    });

    // Handle edit form submission
    $('.edit-department-form').submit(function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var formData = $(this).serialize();
        
        $.ajax({
            url: 'update_department.php',
            type: 'POST',
            data: formData + '&department_id=' + id,
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    location.reload(); // Reload the page to show updated data
                } else {
                    alert('Error: ' + result.message);
                }
            },
            error: function() {
                alert('An error occurred while updating the department.');
            }
        });
    });

    // Tab functionality to preserve tab on page reload
    $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
        localStorage.setItem('lastTab', $(e.target).attr('href'));
    });

    var lastTab = localStorage.getItem('lastTab');
    if (lastTab) {
        $('[href="' + lastTab + '"]').tab('show');
    }
});
</script>

<script src="assets/js/vendor.min.js"></script>
<script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/libs/metismenu/metisMenu.min.js"></script>
<script src="assets/libs/simplebar/simplebar.min.js"></script>
<script src="assets/libs/node-waves/waves.min.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>

</body>
</html>