<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>
<style>
    /* Modern Color Scheme */
    :root {
        --primary-blue: #4361ee;
        --primary-light: #eef2ff;
        --secondary-blue: #3a0ca3;
        --warning-orange: #ff9e00;
        --warning-light: #fff4e5;
        --dark-text: #2b2d42;
        --medium-text: #495057;
        --light-text: #6c757d;
        --border-color: #e0e3ff;
        --card-bg: #ffffff;
        --page-bg: #f8f9fc;
    }

    body {
        background-color: var(--page-bg);
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    }

    /* Card Styling */
    .card-box {
        background: var(--card-bg);
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .card-box:hover {
        box-shadow: 0 10px 30px rgba(67, 97, 238, 0.1);
    }

    /* Header Styling */
    .page-title-box {
        padding: 15px 0;
    }

    .page-title {
        color: var(--dark-text);
        font-weight: 600;
    }

    .breadcrumb {
        background: transparent;
        padding: 0.5rem 0;
    }

    .breadcrumb-item a {
        color: var(--light-text);
        text-decoration: none;
        transition: all 0.2s ease;
    }

    .breadcrumb-item a:hover {
        color: var(--primary-blue);
    }

    .breadcrumb-item.active {
        color: var(--primary-blue);
        font-weight: 500;
    }

    /* Search Box */
    .form-control {
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 15px 8px 40px;
        transition: all 0.3s ease;
        background-color: white;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: 15px center;
        background-size: 16px;
    }

    .form-control:focus {
        border-color: var(--primary-blue);
        box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.1);
    }

    /* Table Styling */
    .table {
        border-collapse: separate;
        border-spacing: 0;
        width: 100%;
    }

    .table th {
        background-color: var(--primary-light);
        color: var(--primary-blue);
        font-weight: 600;
        padding: 15px;
        border-bottom: 2px solid var(--border-color);
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
    }

    .table td {
        padding: 15px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
        color: var(--medium-text);
    }

    .table tr:last-child td {
        border-bottom: none;
    }

    .table tr:hover {
        background-color: rgba(67, 97, 238, 0.03);
    }

    /* Action Buttons */
    .badge {
        border-radius: 6px;
        padding: 8px 12px;
        font-size: 0.75rem;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 5px;
        transition: all 0.2s ease;
    }

    .badge-warning {
        background-color: var(--warning-light);
        color: var(--warning-orange);
    }

    .badge-warning:hover {
        background-color: var(--warning-orange);
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(255, 158, 0, 0.2);
    }

    /* Employee Initials */
    .employee-initials {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        background-color: var(--primary-light);
        color: var(--primary-blue);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        margin-right: 10px;
        font-weight: 600;
    }

    /* Pagination */
    .pagination .page-link {
        color: var(--primary-blue);
        border: 1px solid var(--border-color);
    }

    .pagination .page-item.active .page-link {
        background-color: var(--primary-blue);
        border-color: var(--primary-blue);
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .table th, 
        .table td {
            padding: 10px 8px;
            font-size: 14px;
        }
        
        .badge {
            padding: 6px 8px;
            font-size: 0.7rem;
        }
        
        .employee-initials {
            width: 30px;
            height: 30px;
            font-size: 0.9rem;
        }
    }
</style>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Employee</a></li>
                                        <li class="breadcrumb-item active">Transfer Employee</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Transfers</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="mb-3">
                                    <div class="row align-items-center">
                                        <div class="col-md-6">
                                            <h4 class="header-title mb-0">Employee List</h4>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <input id="demo-foo-search" type="text" placeholder="Search employees..." class="form-control" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table mb-0" data-page-size="10">
                                        <thead>
                                        <tr>
                                            <th style="width: 50px">#</th>
                                            <th data-toggle="true">Employee Name</th>
                                            <th data-hide="phone">ID Number</th>
                                            <th data-hide="phone">Current Department</th>
                                            <th data-hide="phone">Email</th>
                                            <th style="width: 150px">Actions</th>
                                        </tr>
                                        </thead>
                                        <?php
                                            $ret="SELECT * FROM his_docs ORDER BY RAND()"; 
                                            $stmt= $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res=$stmt->get_result();
                                            $cnt=1;
                                            while($row=$res->fetch_object())
                                            {
                                        ?>

                                            <tbody>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td>
                                                    <div style="display: flex; align-items: center;">
                                                        <div class="employee-initials">
                                                            <?php echo strtoupper(substr($row->doc_fname, 0, 1) . substr($row->doc_lname, 0, 1)); ?>
                                                        </div>
                                                        <?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?>
                                                    </div>
                                                </td>
                                                <td><?php echo $row->doc_number;?></td>
                                                <td><?php echo $row->doc_dept;?></td>
                                                <td><?php echo $row->doc_email;?></td>
                                                
                                                <td>
                                                    <a href="transfer_single_employee.php?doc_number=<?php echo $row->doc_number;?>" class="badge badge-warning">
                                                        <i class="mdi mdi-account-arrow-right mr-1"></i> Transfer
                                                    </a>
                                                </td>
                                            </tr>
                                            </tbody>
                                        <?php $cnt = $cnt +1; }?>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="6">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
             <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>