<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['trans_dept'])) {
        $doc_dept = $_POST['doc_dept'];
        $doc_number = $_GET['doc_number'];

        $query = "UPDATE his_docs SET doc_dept=? WHERE doc_number = ?";
        $stmt = $mysqli->prepare($query);
        $rc = $stmt->bind_param('ss', $doc_dept, $doc_number);
        $stmt->execute();
        
        if($stmt) {
            $success = "Employee Transferred Successfully";
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --warning-color: #ff9e00;
            --warning-light: #fff4e5;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .transfer-header {
            background: linear-gradient(135deg, var(--warning-color) 0%, #ff6b00 100%);
            color: white;
            padding: 25px 0;
            border-radius: 12px 12px 0 0;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .transfer-card {
            background: white;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
            transition: all 0.3s ease;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .transfer-card:hover {
            box-shadow: 0 10px 30px rgba(255, 158, 0, 0.15);
        }
        
        .employee-avatar {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 4px solid white;
            overflow: hidden;
            margin: -50px auto 20px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            background-color: var(--warning-light);
            color: var(--warning-color);
            font-size: 2rem;
            font-weight: bold;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .form-section {
            padding: 30px;
        }
        
        .section-title {
            color: var(--warning-color);
            font-weight: 600;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 50px;
            height: 3px;
            background: var(--warning-color);
            border-radius: 3px;
        }
        
        .form-control {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--warning-color);
            box-shadow: 0 0 0 2px rgba(255, 158, 0, 0.1);
        }
        
        .readonly-field {
            background-color: #f8f9fc;
            color: var(--medium-text);
        }
        
        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23ff9e00' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            background-size: 12px;
        }
        
        .btn-transfer {
            background: var(--warning-color);
            border: none;
            padding: 12px 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            border-radius: 8px;
            width: 100%;
            max-width: 250px;
            margin: 20px auto 0;
            display: block;
        }
        
        .btn-transfer:hover {
            background: #ff6b00;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 107, 0, 0.3);
        }
        
        .current-dept {
            font-weight: 600;
            color: var(--warning-color);
        }
        
        @media (max-width: 768px) {
            .employee-avatar {
                width: 80px;
                height: 80px;
                margin-top: -40px;
                font-size: 1.5rem;
            }
            
            .form-section {
                padding: 20px;
            }
            
            .btn-transfer {
                width: 100%;
                max-width: none;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Employee</a></li>
                                        <li class="breadcrumb-item active">Transfer Employee</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Department Transfer</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <?php
                        $doc_number = $_GET['doc_number'];
                        $ret = "SELECT * FROM his_docs WHERE doc_number=?";
                        $stmt = $mysqli->prepare($ret);
                        $stmt->bind_param('i', $doc_number);
                        $stmt->execute();
                        $res = $stmt->get_result();
                        $row = $res->fetch_object();
                    ?>
                    
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="transfer-card">
                                <div class="transfer-header">
                                    <h3>Department Transfer</h3>
                                </div>
                                
                                <div class="employee-avatar">
                                    <?php echo strtoupper(substr($row->doc_fname, 0, 1) . substr($row->doc_lname, 0, 1)); ?>
                                </div>
                                
                                <div class="form-section">
                                    <h4 class="section-title">Employee Details</h4>
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>First Name</label>
                                                <input type="text" required readonly value="<?php echo $row->doc_fname; ?>" class="form-control readonly-field">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Last Name</label>
                                                <input required type="text" readonly value="<?php echo $row->doc_lname; ?>" class="form-control readonly-field">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Email Address</label>
                                            <input required type="email" readonly value="<?php echo $row->doc_email; ?>" class="form-control readonly-field">
                                        </div>

                                        <div class="form-group">
                                            <label>Employee Number</label>
                                            <input required type="text" readonly value="<?php echo $row->doc_number; ?>" class="form-control readonly-field">
                                        </div>

                                        <div class="form-group">
                                            <label>Current Department</label>
                                            <input required type="text" readonly value="<?php echo $row->doc_dept; ?>" class="form-control readonly-field current-dept">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Transfer To Department</label>
                                            <select required name="doc_dept" class="form-control">
                                                <option value="">Select New Department</option>
                                                <option value="Patient Registration" <?php echo ($row->doc_dept == 'Patient Registration') ? 'selected' : ''; ?>>Patient Registration</option>
                                                <option value="Laboratory" <?php echo ($row->doc_dept == 'Laboratory') ? 'selected' : ''; ?>>Laboratory</option>
                                                <option value="Pharmacy" <?php echo ($row->doc_dept == 'Pharmacy') ? 'selected' : ''; ?>>Pharmacy</option>
                                                <option value="Accounting" <?php echo ($row->doc_dept == 'Accounting') ? 'selected' : ''; ?>>Accounting</option>
                                                <option value="Surgery | Theatre" <?php echo ($row->doc_dept == 'Surgery | Theatre') ? 'selected' : ''; ?>>Surgery | Theatre</option>
                                            </select>
                                        </div>                                         

                                        <button type="submit" name="trans_dept" class="btn btn-transfer">
                                            <i class="mdi mdi-account-arrow-right mr-1"></i> Confirm Transfer
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>
</html>