<?php
    session_start();
    include('assets/inc/config.php');
    
    // Fetch insurance companies for dropdown
    $insurance_query = "SELECT * FROM his_insurance ORDER BY insurance_name ASC";
    $insurance_stmt = $mysqli->prepare($insurance_query);
    $insurance_stmt->execute();
    $insurance_result = $insurance_stmt->get_result();
    
    if(isset($_POST['update_patient'])) {
        $pat_id = $_GET['pat_id'];
        $pat_fname = $_POST['pat_fname'];
        $pat_lname = $_POST['pat_lname'];
        $pat_number = $_POST['pat_number'];
        $pat_phone = $_POST['pat_phone'];
        $pat_type = $_POST['pat_type'];
        $pat_addr = $_POST['pat_addr'];
        $pat_age = $_POST['pat_age'];
        $pat_dob = $_POST['pat_dob'];
        $pat_ailment = $_POST['pat_ailment'];
        $doc_dept = $_POST['doc_dept'];
        $doc_id = $_POST['doc_id'];
        $f = $_POST['fee'];
        $insurance = $_POST['insurance'];
        $status = $_POST['status'];
        $gender = $_POST['gender'];
        $card_no = $_POST['card_no'];
        $title = $_POST['title'];

        $query = "UPDATE his_patients SET pat_fname=?, pat_lname=?, pat_age=?, pat_dob=?, pat_phone=?, pat_type=?, pat_addr=?, pat_ailment=?, dept=?, doc_id=?, insurance=?, status=?, gender=?, card_no=?, title=?, fee=? WHERE pat_id = ?";
        $stmt = $mysqli->prepare($query);
        $rc = $stmt->bind_param('sssssssssssssssis', $pat_fname, $pat_lname, $pat_age, $pat_dob, $pat_phone, $pat_type, $pat_addr, $pat_ailment, $doc_dept, $doc_id, $insurance, $status, $gender, $card_no, $title, $f, $pat_id);
        $stmt->execute();
        
        if($stmt) {
            $success = "Patient Details Updated Successfully";
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary-color: #4e73df;
            --secondary-color: #1cc88a;
            --accent-color: #f6c23e;
            --dark-color: #5a5c69;
            --light-color: #f8f9fc;
            --transition-speed: 0.3s;
        }
        
        body {
            background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%);
            font-family: 'Poppins', sans-serif;
        }
        
        .form-control {
            transition: all var(--transition-speed) ease, box-shadow 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            border-radius: 10px;
            padding: 12px 20px;
            height: auto;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
            transform: translateY(-2px);
        }
        
        .form-group {
            transition: transform 0.3s ease;
        }
        
        .form-group:hover {
            transform: translateY(-3px);
        }
        
        .card {
            transition: transform 0.4s ease, box-shadow 0.4s ease;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.15);
        }
        
        .btn-success {
            position: relative;
            overflow: hidden;
            transition: all 0.4s ease;
            background: linear-gradient(to right, #11998e, #38ef7d);
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(17, 153, 142, 0.3);
        }
        
        .btn-success:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(17, 153, 142, 0.4);
        }
        
        .btn-success:active {
            transform: translateY(1px);
        }
        
        .page-title-box {
            background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2);
            color: white;
            margin-bottom: 25px;
            position: relative;
            overflow: hidden;
        }
        
        .header-title {
            color: #4e73df;
            border-bottom: 2px solid #f8f9fc;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        
        select.form-control {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%235a5c69' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right 0.75rem center;
            background-size: 16px 12px;
        }
        
        select.form-control:focus {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%234e73df' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        }
        
        /* Animations */
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-8px); }
            100% { transform: translateY(0px); }
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(30, 204, 138, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(30, 204, 138, 0); }
            100% { box-shadow: 0 0 0 0 rgba(30, 204, 138, 0); }
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .floating {
            animation: float 3s ease-in-out infinite;
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        .fade-in {
            animation: fadeIn 0.5s ease forwards;
        }
        
        .is-invalid {
            border-color: #e74a3b !important;
        }
        
        .invalid-feedback {
            color: #e74a3b;
            font-size: 0.8rem;
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- Left Sidebar Start -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                        <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Update Patient</li>
                                    </ol>
                                </div>
                                <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                    <i class="fas fa-user-edit mr-2"></i>Update Patient Details
                                </h4>
                            </div>
                        </div>
                    </div>
                    
                    <?php
                        $pat_id = $_GET['pat_id'];
                        $ret = "SELECT * FROM his_patients WHERE pat_id=?";
                        $stmt = $mysqli->prepare($ret);
                        $stmt->bind_param('i', $pat_id);
                        $stmt->execute();
                        $res = $stmt->get_result();
                        while($row = $res->fetch_object()) {
                    ?>
                    
                    <div class="row fade-in">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body" style="padding: 2rem;">
                                    <h4 class="header-title">
                                        <i class="fas fa-user-injured mr-2"></i>Patient Information
                                    </h4>
                                    
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success pulse"><?php echo $success; ?></div>
                                    <?php } ?>
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    
                                    <form method="post" id="patientForm">
                                        <div class="form-row">
                                            <!-- Personal Information -->
                                            <div class="form-group col-md-4">
                                                <label for="patientTitle">Patient Title</label>
                                                <select required name="title" class="form-control" id="patientTitle">
                                                    <option value="" disabled selected>Select Title</option>
                                                    <option value="Mr" <?php echo ($row->title == 'Mr') ? 'selected' : ''; ?>>Mr</option>
                                                    <option value="Miss" <?php echo ($row->title == 'Miss') ? 'selected' : ''; ?>>Miss</option>
                                                    <option value="Mrs" <?php echo ($row->title == 'Mrs') ? 'selected' : ''; ?>>Mrs</option>
                                                    <option value="Master" <?php echo ($row->title == 'Master') ? 'selected' : ''; ?>>Master</option>
                                                    <option value="Baby" <?php echo ($row->title == 'Baby') ? 'selected' : ''; ?>>Baby</option>
                                                    <option value="Prof" <?php echo ($row->title == 'Prof') ? 'selected' : ''; ?>>Prof</option>
                                                    <option value="Doc" <?php echo ($row->title == 'Doc') ? 'selected' : ''; ?>>Doc</option>
                                                </select>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="pat_fname">First Name</label>
                                                <input type="text" required name="pat_fname" class="form-control" id="pat_fname" value="<?php echo $row->pat_fname; ?>">
                                                <div class="invalid-feedback">Please enter first name</div>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="pat_lname">Last Name</label>
                                                <input type="text" required name="pat_lname" class="form-control" id="pat_lname" value="<?php echo $row->pat_lname; ?>">
                                                <div class="invalid-feedback">Please enter last name</div>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="card_no">Aadhar Card No</label>
                                                <input type="text" required name="card_no" class="form-control" id="card_no" value="<?php echo $row->card_no; ?>">
                                                <div class="invalid-feedback">Please enter Aadhar number</div>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="gender">Gender</label>
                                                <select required name="gender" class="form-control" id="gender">
                                                    <option value="" disabled selected>Select Gender</option>
                                                    <option value="Male" <?php echo ($row->gender == 'Male') ? 'selected' : ''; ?>>Male</option>
                                                    <option value="Female" <?php echo ($row->gender == 'Female') ? 'selected' : ''; ?>>Female</option>
                                                    <option value="Other" <?php echo ($row->gender == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                </select>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="status">Marital Status</label>
                                                <select required name="status" class="form-control" id="status">
                                                    <option value="" disabled selected>Select Status</option>
                                                    <option value="Single" <?php echo ($row->status == 'Single') ? 'selected' : ''; ?>>Single</option>
                                                    <option value="Married" <?php echo ($row->status == 'Married') ? 'selected' : ''; ?>>Married</option>
                                                    <option value="Divorced" <?php echo ($row->status == 'Divorced') ? 'selected' : ''; ?>>Divorced</option>
                                                    <option value="Other" <?php echo ($row->status == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                </select>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="pat_dob">Date of Birth</label>
                                                <input type="date" required name="pat_dob" class="form-control" id="pat_dob" value="<?php echo $row->pat_dob; ?>">
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="pat_age">Age</label>
                                                <input type="number" required name="pat_age" class="form-control" id="pat_age" min="0" max="120" value="<?php echo $row->pat_age; ?>">
                                                <div class="invalid-feedback">Please enter valid age (0-120)</div>
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="insurance">Insurance Company</label>
                                                <select required name="insurance" class="form-control" id="insurance">
                                                    <option value="" disabled selected>Select Insurance</option>
                                                    <?php while($insurance = $insurance_result->fetch_assoc()) { ?>
                                                        <option value="<?php echo $insurance['insurance_name']; ?>" <?php echo ($row->insurance == $insurance['insurance_name']) ? 'selected' : ''; ?>>
                                                            <?php echo $insurance['insurance_name']; ?>
                                                        </option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                            
                                            <div class="form-group col-md-12">
                                                <label for="pat_addr">Address</label>
                                                <input type="text" required name="pat_addr" class="form-control" id="pat_addr" value="<?php echo $row->pat_addr; ?>">
                                            </div>
                                            
                                            <div class="form-group col-md-4">
                                                <label for="pat_phone">Mobile Number</label>
                                                <input type="tel" required name="pat_phone" class="form-control" id="pat_phone" value="<?php echo $row->pat_phone; ?>">
                                                <div class="invalid-feedback">Please enter valid phone number</div>
                                            </div>
                                            
                                       
                                       
                                          
                                            







                                                <div class="form-group col-md-4">
    <label for="pat_type">OPD/IPD</label>
    <select id="pat_type" name="pat_type" class="form-control" required>
        <option value="<?php echo $row->pat_type; ?>" disabled selected> <?php echo $row->pat_type; ?></option>
     <option value="OutPatient">OPD</option>
        <option value="InPatient">IPD</option>
    </select>
</div>

<div class="form-group col-md-4">
    <label for="department">Department</label>
    <select id="department" name="doc_dept" class="form-control" required>
        <option value="<?php echo $row->dept; ?>" disabled selected><?php echo $row->dept; ?></option>
    </select>
</div>
<div class="form-group col-md-4">
    <label for="ailment">Ailment</label>
    <select id="ailment" name="pat_ailment" class="form-control" required>
        <option value="<?php echo $row->pat_ailment; ?>" disabled selected><?php echo $row->pat_ailment; ?></option>
    </select>
</div>

<div class="form-group col-md-4">
    <label for="fee">Fee</label>
    <input type="text" class="form-control" id="fee" name="fee" value="<?php echo $row->fee; ?>" readonly>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#pat_type').on('change', function () {
        let patType = $(this).val();
        $.ajax({
            url: 'get_departments.php',
            type: 'POST',
            data: { pat_type: patType },
            success: function (response) {
                $('#department').html(response);
                $('#ailment').html('<option value="" disabled selected>Select Ailment</option>');
                $('#fee').val('');
            }
        });
    });

    $('#department').on('change', function () {
        let deptId = $(this).val();
        $.ajax({
            url: 'get_ailments_and_fee.php',
            type: 'POST',
            dataType: 'json',
            data: { department_id: deptId },
            success: function (data) {
                $('#ailment').html('<option value="" disabled selected>Select Ailment</option>');
                data.ailments.forEach(function (ailment) {
                    $('#ailment').append('<option value="' + ailment + '">' + ailment + '</option>');
                });
                $('#fee').val(data.fee);
            }
        });
    });
});

</script>

                                            <div class="form-group col-md-4">
                                                <label for="doc_id">Doctor</label>
                                                <select required name="doc_id" class="form-control">
                                                    <option value="" disabled selected>Select Doctor</option>
                                                    <?php
                                                    $doctors = $mysqli->query("SELECT * FROM his_docs");
                                                    while($doctor = $doctors->fetch_object()) {
                                                        echo '<option value="'.$doctor->doc_id.'" data-dept="'.$doctor->doc_dept.'" '.($row->doc_id == $doctor->doc_id ? 'selected' : '').'>'.$doctor->doc_fname.' '.$doctor->doc_lname.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            
                                                                                     
                                            <input type="hidden" name="pat_number" value="<?php echo $row->pat_number; ?>">
                                        </div>
                                        
                                        <div class="text-right mt-4">
                                            <button type="submit" name="update_patient" class="ladda-button btn btn-success" data-style="expand-right">
                                                <span class="ladda-label">
                                                    <i class="fas fa-save mr-2"></i>Update Patient
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
        <!-- END wrapper -->

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>
        <!-- App js-->
        <script src="assets/js/app.min.js"></script>
        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>
        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
        
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
        $(document).ready(function() {
            // Initialize form validation
            function validateForm() {
                let isValid = true;
                
                // Check required fields
                $('[required]').each(function() {
                    if(!$(this).val()) {
                        $(this).addClass('is-invalid');
                        isValid = false;
                    } else {
                        $(this).removeClass('is-invalid');
                    }
                });
                
                // Validate phone number
                const phone = $('#pat_phone').val();
                if(phone && !/^\+?\d{10,15}$/.test(phone)) {
                    $('#pat_phone').addClass('is-invalid');
                    $('#pat_phone').next('.invalid-feedback').text('Please enter a valid phone number');
                    isValid = false;
                }
                
                // Validate age
                const age = $('#pat_age').val();
                if(age && (age < 0 || age > 120)) {
                    $('#pat_age').addClass('is-invalid');
                    isValid = false;
                }
                
                return isValid;
            }
            
            // Form submission handler
            $('#patientForm').on('submit', function(e) {
                if(!validateForm()) {
                    e.preventDefault();
                    $('.form-error').remove();
                    $(this).prepend('<div class="alert alert-danger form-error">Please fill all required fields correctly.</div>');
                }
            });
            
            // Real-time validation
            $('input, select').on('input change', function() {
                if($(this).val()) {
                    $(this).removeClass('is-invalid');
                }
            });
            
            // Filter doctors by department
            function filterDoctors() {
                const department = $('#doc_dept').val();
                $('#doc_id option').each(function() {
                    if(!department || $(this).data('dept') === department) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
                
                // Reset selection if current selection is hidden
                if($('#doc_id option:selected').is(':hidden')) {
                    $('#doc_id').val('');
                }
            }
            
            $('#doc_dept').on('change', filterDoctors);
            filterDoctors(); // Initial filter
            
            // Animate form elements on focus
            $('.form-control').on('focus', function() {
                $(this).parent().css('transform', 'translateY(-3px)');
            }).on('blur', function() {
                $(this).parent().css('transform', '');
            });
            
            // Initialize with existing values
            if($('#pat_type').val()) {
                // You can add additional initialization logic here
            }
        });
        </script>
    </body>
</html>