<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box animated fadeIn">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Employee</a></li>
                                            <li class="breadcrumb-item active">View Employee</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title text-primary">Employee Details</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box shadow-lg rounded animated fadeInUp">
                                    <style>
                                        .table-hover tbody tr:hover {
                                            background-color: rgba(70, 130, 180, 0.1);
                                            transform: scale(1.01);
                                            transition: all 0.3s ease;
                                        }
                                        .badge-success {
                                            transition: all 0.3s ease;
                                            background: linear-gradient(45deg, #28a745, #5cb85c);
                                        }
                                        .badge-success:hover {
                                            transform: translateY(-2px);
                                            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
                                        }
                                        .card-box {
                                            border: none;
                                            background: linear-gradient(to bottom, #ffffff, #f8f9fa);
                                        }
                                        .header-title {
                                            color: #2c3e50;
                                            position: relative;
                                            padding-bottom: 10px;
                                        }
                                        .header-title:after {
                                            content: '';
                                            position: absolute;
                                            left: 0;
                                            bottom: 0;
                                            width: 50px;
                                            height: 3px;
                                            background: linear-gradient(to right, #3498db, #2ecc71);
                                        }
                                        .form-control:focus {
                                            border-color: #3498db;
                                            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
                                        }
                                        .pagination .page-item.active .page-link {
                                            background: linear-gradient(45deg, #3498db, #2ecc71);
                                            border-color: #3498db;
                                        }
                                        @keyframes fadeIn {
                                            from { opacity: 0; }
                                            to { opacity: 1; }
                                        }
                                        .animated {
                                            animation-duration: 0.5s;
                                            animation-fill-mode: both;
                                        }
                                        .fadeIn {
                                            animation-name: fadeIn;
                                        }
                                        @keyframes fadeInUp {
                                            from {
                                                opacity: 0;
                                                transform: translateY(20px);
                                            }
                                            to {
                                                opacity: 1;
                                                transform: translateY(0);
                                            }
                                        }
                                        .fadeInUp {
                                            animation-name: fadeInUp;
                                        }
                                    </style>
                                    <h4 class="header-title">Employee Directory</h4>
                                    <div class="mb-2">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline">
                                                <div class="form-group mr-2" style="display:none">
                                                    <select id="demo-foo-filter-status" class="custom-select custom-select-sm">
                                                        <option value="">Show all</option>
                                                        <option value="Discharged">Discharged</option>
                                                        <option value="OutPatients">OutPatients</option>
                                                        <option value="InPatients">InPatients</option>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <input id="demo-foo-search" type="text" placeholder="Search employees..." class="form-control form-control-sm" autocomplete="on">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-bordered table-hover toggle-circle mb-0" data-page-size="7">
                                            <thead>
                                            <tr class="bg-primary text-white">
                                                <th>#</th>
                                                <th data-toggle="true">Name</th>
                                                <th data-hide="phone">Number</th>
                                                <th data-hide="phone">Email</th>
                                                <th data-hide="phone">Action</th>
                                            </tr>
                                            </thead>
                                            <?php
                                                $ret="SELECT * FROM  his_docs ORDER BY RAND() "; 
                                                $stmt= $mysqli->prepare($ret) ;
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>
                                                <tbody>
                                                <tr class="animated fadeIn" style="animation-delay: <?php echo $cnt * 0.1; ?>s">
                                                    <td><?php echo $cnt;?></td>
                                                    <td>
                                                        <i class="mdi mdi-account-circle mr-1 text-primary"></i> <?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?>
                                                    </td>
                                                    <td><i class="mdi mdi-phone mr-1 text-info"></i> <?php echo $row->doc_number;?></td>
                                                    <td><i class="mdi mdi-email mr-1 text-warning"></i> <?php echo $row->doc_email;?></td>                                                    
                                                    <td>
                                                        <a href="view_single_employee.php?doc_id=<?php echo $row->doc_id;?>&&doc_number=<?php echo $row->doc_number;?>" class="badge badge-success">
                                                            <i class="mdi mdi-eye"></i> View
                                                        </a>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            <?php  $cnt = $cnt +1 ; }?>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="8">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <script>
            // Add animation to table rows on hover
            $(document).ready(function() {
                $('table tbody tr').hover(
                    function() {
                        $(this).addClass('shadow-sm');
                    },
                    function() {
                        $(this).removeClass('shadow-sm');
                    }
                );
                
                // Add pulse animation to the view button when page loads
                $('.badge-success').addClass('animate__animated animate__pulse animate__delay-1s');
                
                // Smooth scroll to top when clicking on the page title
                $('.page-title').click(function() {
                    $('html, body').animate({scrollTop: 0}, 800);
                });
            });
        </script>
        
    </body>
</html>