<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
<?php include ('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $mdr_number=$_GET['mdr_number'];
                $mdr_id=$_GET['mdr_id'];
                $ret="SELECT  * FROM his_medical_records WHERE mdr_id = ?";
                $stmt= $mysqli->prepare($ret) ;
                $stmt->bind_param('i',$mdr_id);
                $stmt->execute() ;//ok
                $res=$stmt->get_result();
                //$cnt=1;
                while($row=$res->fetch_object())
                {
                    $mysqlDateTime = $row->mdr_date_rec;
            ?>

                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Medical Records</a></li>
                                                <li class="breadcrumb-item active">View Medical Records</li>
                                            </ol>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h4 class="page-title">#<?php echo $row->mdr_number;?></h4>
                                            <button id="printBtn" class="btn btn-primary">
                                                <i class="fas fa-print mr-1"></i> Print Record
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 

                            <div class="row">
                                <div class="col-12">
                                    <div class="card-box">
                                        <div class="row">
                                            
                                            <div class="col-xl-12">
                                                <div class="pl-xl-3 mt-3 mt-xl-0">
                                                    <div class="patient-info">
                                                        <h2 class="mb-3 patient-name"><?php echo $row->mdr_pat_name;?></h2>
                                                        <div class="patient-detail">
                                                            <span class="detail-label">Age:</span>
                                                            <span class="detail-value"><?php echo $row->mdr_pat_age;?> Years</span>
                                                        </div>
                                                        <div class="patient-detail">
                                                            <span class="detail-label">Patient Number:</span>
                                                            <span class="detail-value"><?php echo $row->mdr_pat_number;?></span>
                                                        </div>
                                                        <div class="patient-detail">
                                                            <span class="detail-label">Date Recorded:</span>
                                                            <span class="detail-value"><?php echo date("d/m/Y - h:i A", strtotime($mysqlDateTime));?></span>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="medical-info">
                                                        <h4 class="section-title">Diagnosis</h4>
                                                        <div class="section-content">
                                                            <?php echo $row->mdr_pat_ailment;?>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="medical-info">
                                                        <h4 class="section-title">Prescription</h4>
                                                        <div class="section-content">
                                                            <?php echo $row->mdr_pat_prescr;?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> <!-- end col -->
                                        </div>
                                        <!-- end row -->
                                    </div> <!-- end card-->
                                </div> <!-- end col-->
                            </div>
                            <!-- end row-->
                            
                        </div> <!-- container -->

                    </div> <!-- content -->

                    <!-- Footer Start -->
                        <?php include('assets/inc/footer.php');?>
                    <!-- end Footer -->

                </div>
            <?php }?>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            .patient-info {
                background: #f8f9fa;
                padding: 15px;
                border-radius: 8px;
                margin-bottom: 20px;
            }
            
            .patient-name {
                color: #3bafda;
                border-bottom: 1px solid #eee;
                padding-bottom: 10px;
            }
            
            .patient-detail {
                display: flex;
                margin-bottom: 8px;
            }
            
            .detail-label {
                font-weight: 600;
                min-width: 120px;
                color: #495057;
            }
            
            .detail-value {
                color: #212529;
            }
            
            .section-title {
                color: #3bafda;
                margin-bottom: 15px;
            }
            
            .section-content {
                background: #f8f9fa;
                padding: 15px;
                border-radius: 5px;
                white-space: pre-wrap;
            }
            
            @media print {
                body * {
                    visibility: hidden;
                }
                
                .content-page, .content-page * {
                    visibility: visible;
                }
                
                .content-page {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    padding: 20px;
                }
                
                .no-print, .page-title-right, #printBtn {
                    display: none !important;
                }
                
                .card-box {
                    border: none !important;
                    box-shadow: none !important;
                }
                
                .patient-info {
                    background: transparent !important;
                    padding: 0 !important;
                }
                
                .section-content {
                    background: transparent !important;
                    padding: 0 !important;
                }
            }
        </style>
        
        <script>
        $(document).ready(function() {
            // Print functionality
            $('#printBtn').click(function() {
                // Store original content
                var originalContent = $('.content-page').html();
                
                // Create printable version
                var printContent = `
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <h2 class="text-center mb-4">Medical Record #<?php echo $row->mdr_number; ?></h2>
                                <p class="text-center mb-4">Generated on: ${new Date().toLocaleString()}</p>
                                
                                <div class="row">
                                    <div class="col-md-5">
                                        <img src="assets/images/medical_record.png" alt="" class="img-fluid mx-auto d-block rounded">
                                    </div>
                                    <div class="col-md-7">
                                        <div class="patient-info">
                                            <h3 class="patient-name"><?php echo $row->mdr_pat_name; ?></h3>
                                            <div class="patient-detail">
                                                <span class="detail-label">Age:</span>
                                                <span class="detail-value"><?php echo $row->mdr_pat_age; ?> Years</span>
                                            </div>
                                            <div class="patient-detail">
                                                <span class="detail-label">Patient Number:</span>
                                                <span class="detail-value"><?php echo $row->mdr_pat_number; ?></span>
                                            </div>
                                            <div class="patient-detail">
                                                <span class="detail-label">Date Recorded:</span>
                                                <span class="detail-value"><?php echo date("d/m/Y - h:i A", strtotime($mysqlDateTime)); ?></span>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="medical-info">
                                            <h4 class="section-title">Diagnosis</h4>
                                            <div class="section-content">
                                                <?php echo $row->mdr_pat_ailment; ?>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="medical-info">
                                            <h4 class="section-title">Prescription</h4>
                                            <div class="section-content">
                                                <?php echo $row->mdr_pat_prescr; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                
                // Replace content with printable version
                $('.content-page').html(printContent);
                
                // Print the page
                window.print();
                
                // Restore original content
                $('.content-page').html(originalContent);
            });
        });
        </script>
    </body>
</html>