<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $doc_id = $_SESSION['doc_id'];
?>

<!DOCTYPE html>
<html lang="en">
    <?php include('assets/inc/head.php');?>
    <style>
        .payroll-card {
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .payroll-header {
            background-color: #4e73df;
            color: white;
            padding: 20px;
            border-radius: 8px 8px 0 0;
        }
        .info-box {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .summary-box {
            background-color: #f1f8ff;
            border-left: 4px solid #4e73df;
            padding: 15px;
        }
        .tax-highlight {
            color: #dc3545;
            font-weight: 600;
        }
        .net-salary {
            font-size: 1.5rem;
            font-weight: 600;
            color: #28a745;
        }
    </style>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include ('assets/inc/sidebar.php');?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $pay_number = $_GET['pay_number'];
                $ret="SELECT  * FROM his_payrolls WHERE pay_number = ?";
                $stmt= $mysqli->prepare($ret) ;
                $stmt->bind_param('s',$pay_number);
                $stmt->execute() ;//ok
                $res=$stmt->get_result();
                $cnt=1;
                while($row=$res->fetch_object())
                {
                    $mysqlDateTime = $row->pay_date_generated;
                    $tax = 16/100;
                    $salary = $row->pay_emp_salary;
                    $taxable_salary = $tax*$salary;
                    $total_salary = $salary - $taxable_salary;
            ?>
                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Payroll</a></li>
                                                <li class="breadcrumb-item active">Payroll Details</li>
                                            </ol>
                                        </div>
                                        <h4 class="page-title">
                                            <i class="mdi mdi-cash-multiple mr-2"></i>
                                            Payroll Statement
                                        </h4>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 

                            <div class="row">
                                <div class="col-12">
                                    <div class="payroll-card">
                                        <div class="payroll-header">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h4 class="m-0"><?php echo $row->pay_doc_name;?> Payroll</h4>
                                                <span class="badge badge-light"><?php echo $row->pay_status;?></span>
                                            </div>
                                        </div>
            
                                        <div class="p-4">
                                            <div class="row mb-4">
                                                <div class="col-md-6">
                                                    <div class="info-box">
                                                        <h5 class="mb-3"><i class="mdi mdi-account-circle mr-2"></i>Employee Information</h5>
                                                        <div class="mb-2">
                                                            <strong>Employee Number:</strong> <?php echo $row->pay_doc_number;?>
                                                        </div>
                                                        <div class="mb-2">
                                                            <strong>Payroll Number:</strong> <?php echo $row->pay_number;?>
                                                        </div>
                                                        <div>
                                                            <strong>Generated Date:</strong> <?php echo date("d-m-Y - h:i A", strtotime($mysqlDateTime));?>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <div class="info-box">
                                                        <h5 class="mb-3"><i class="mdi mdi-office-building mr-2"></i>Department Information</h5>
                                                        <?php
                                                            $doc_number = $_SESSION['doc_number'];
                                                            $ret="SELECT  * FROM his_docs WHERE doc_number = ?";
                                                            $stmt= $mysqli->prepare($ret) ;
                                                            $stmt->bind_param('s',$doc_number);
                                                            $stmt->execute() ;//ok
                                                            $res=$stmt->get_result();
                                                            while($dept_row=$res->fetch_object()):
                                                        ?>
                                                        <div class="mb-2">
                                                            <strong>Department:</strong> <?php echo $dept_row->doc_dept;?>
                                                        </div>
                                                        <?php endwhile; ?>
                                                    </div>
                                                </div>
                                            </div>
            
                                            <div class="table-responsive mb-4">
                                                <table class="table table-hover">
                                                    <thead class="thead-light">
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Description</th>
                                                            <th class="text-right">Amount</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td><?php echo $cnt;?></td>
                                                            <td>Base Salary</td>
                                                            <td class="text-right">$<?php echo number_format($row->pay_emp_salary, 2);?></td>
                                                        </tr>
                                                        <tr class="tax-highlight">
                                                            <td></td>
                                                            <td>PAYE Tax (16%)</td>
                                                            <td class="text-right">-$<?php echo number_format($taxable_salary, 2);?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
            
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="info-box">
                                                        <h5 class="mb-3"><i class="mdi mdi-note-text mr-2"></i>Notes</h5>
                                                        <p><?php echo $row->pay_descr;?></p>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6">
                                                    <div class="summary-box">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <span>Gross Salary:</span>
                                                            <span>$<?php echo number_format($row->pay_emp_salary, 2);?></span>
                                                        </div>
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <span>Tax Deduction:</span>
                                                            <span class="tax-highlight">-$<?php echo number_format($taxable_salary, 2);?></span>
                                                        </div>
                                                        <hr>
                                                        <div class="d-flex justify-content-between">
                                                            <strong>Net Salary:</strong>
                                                            <span class="net-salary">$<?php echo number_format($total_salary, 2);?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
            
                                            <div class="mt-4 text-right">
                                                <button onclick="window.print()" class="btn btn-primary">
                                                    <i class="mdi mdi-printer mr-1"></i> Print Payroll
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div> <!-- end col -->
                            </div>
                            <!-- end row --> 
                            
                        </div> <!-- container -->

                    </div> <!-- content -->

                    <!-- Footer Start -->
                        <?php include ("assets/inc/footer.php");?>
                    <!-- end Footer -->

                </div>
            <?php
                $cnt = $cnt + 1;
                }
            ?>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>