<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid=$_SESSION['ad_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- CKEditor 5 -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --info: #17a2b8;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #6c757d;
            --border: #e0e3ff;
        }

        body {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-family: 'Inter', sans-serif;
            color: var(--dark);
        }

        #wrapper {
            background-color: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
        }

        .content-page {
            background: transparent;
        }

        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            background-color: white;
            overflow: hidden;
        }

        .page-title-box {
            padding: 20px 0;
            background: transparent;
        }

        .page-title {
            color: var(--dark);
            font-weight: 700;
        }

        h2, h4 {
            color: var(--dark);
            margin-bottom: 1rem;
        }

        h2 {
            font-weight: 700;
            color: var(--primary);
        }

        .text-danger {
            color: var(--danger) !important;
        }

        hr {
            border-top: 1px solid var(--border);
            margin: 1.5rem 0;
        }

        .text-muted {
            color: var(--gray) !important;
        }

        /* CKEditor styling */
        .ck.ck-editor {
            max-width: 100%;
            margin-bottom: 1rem;
        }
        .ck.ck-editor__main>.ck-editor__editable {
            min-height: 200px;
            border: 1px solid var(--border) !important;
            border-radius: 0.35rem !important;
        }
        .ck.ck-editor__main>.ck-editor__editable:focus {
            border-color: var(--primary) !important;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25) !important;
        }

        /* Print-specific styles */
        @media print {
            body * {
                visibility: hidden;
            }
            #printable-area, #printable-area * {
                visibility: visible;
            }
            #printable-area {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background: white;
                padding: 20px;
            }
            .no-print {
                display: none !important;
            }
            .card-box {
                box-shadow: none !important;
                border: 1px solid #ddd !important;
            }
            .page-title-box {
                padding: 0 0 20px 0 !important;
            }
            .text-danger {
                color: #dc3545 !important;
            }
            /* Hide editor toolbar in print */
            .ck.ck-toolbar {
                display: none !important;
            }
            .ck.ck-editor__main>.ck-editor__editable {
                border: none !important;
                padding: 0 !important;
            }
        }

        /* Action buttons */
        .action-buttons {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        .btn-print {
            background-color: var(--warning);
            border-color: var(--warning);
            color: white;
        }
        .btn-print:hover {
            background-color: #e69100;
            border-color: #e69100;
            color: white;
        }
        .btn-back {
            background-color: var(--gray);
            border-color: var(--gray);
            color: white;
        }
        .btn-save {
            background-color: var(--success);
            border-color: var(--success);
            color: white;
        }

        /* Pharmaceutical details card */
        .pharma-detail-card {
            background: linear-gradient(135deg, var(--primary-light) 0%, white 100%);
            border-radius: 12px;
            padding: 2rem;
            height: 100%;
        }

        .detail-label {
            font-weight: 600;
            color: var(--secondary);
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 0.5rem;
        }

        .detail-value {
            color: var(--dark);
            font-weight: 500;
            font-size: 1.1rem;
            margin-bottom: 1.5rem;
        }

        @media (max-width: 768px) {
            .pl-xl-3 {
                padding-left: 0 !important;
                margin-top: 1.5rem;
            }
            .action-buttons {
                flex-direction: column;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $phar_bcode = $_GET['phar_bcode'];
            $ret = "SELECT * FROM his_pharmaceuticals WHERE phar_bcode = ?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('i', $phar_bcode);
            $stmt->execute();
            $res = $stmt->get_result();
            
            while($row = $res->fetch_object()):
        ?>

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                            <li class="breadcrumb-item active">View Pharmaceuticals</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">#<?php echo htmlspecialchars($row->phar_bcode);?> - <?php echo htmlspecialchars($row->phar_name);?></h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="action-buttons no-print">
                            <button onclick="window.print()" class="btn btn-print">
                                <i class="fas fa-print mr-1"></i> Print Details
                            </button>
                            <a href="javascript:history.back()" class="btn btn-back">
                                <i class="fas fa-arrow-left mr-1"></i> Back
                            </a>
                            <button id="edit-desc-btn" class="btn btn-primary">
                                <i class="fas fa-edit mr-1"></i> Edit Description
                            </button>
                            <button id="save-desc-btn" class="btn btn-save" style="display:none">
                                <i class="fas fa-save mr-1"></i> Save Changes
                            </button>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" id="printable-area">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="pharma-detail-card">
                                                <h2 class="mb-4"><?php echo htmlspecialchars($row->phar_name);?></h2>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Barcode</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($row->phar_bcode);?></div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Vendor</div>
                                                    <div class="detail-value text-danger"><?php echo htmlspecialchars($row->phar_vendor);?></div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Quantity</div>
                                                    <div class="detail-value text-danger"><?php echo htmlspecialchars($row->phar_qty);?> Cartons</div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Category</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($row->phar_cat);?></div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Description</div>
                                                    <div class="detail-value">
                                                        <div id="description-display">
                                                            <?php echo $row->phar_desc; ?>
                                                        </div>
                                                        <div id="description-editor-container" style="display:none">
                                                            <textarea id="editor" name="phar_desc"><?php echo htmlspecialchars($row->phar_desc);?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div> <!-- end card-->
                            </div> <!-- end col-->
                        </div>
                        <!-- end row-->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>
        <?php endwhile; ?>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <script>
        // Initialize CKEditor
        let editor;
        
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'undo', 'redo'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                    ]
                }
            })
            .then(newEditor => {
                editor = newEditor;
            })
            .catch(error => {
                console.error(error);
            });

        // Toggle between display and edit modes
        const editBtn = document.getElementById('edit-desc-btn');
        const saveBtn = document.getElementById('save-desc-btn');
        const displayDiv = document.getElementById('description-display');
        const editorContainer = document.getElementById('description-editor-container');

        editBtn.addEventListener('click', function() {
            displayDiv.style.display = 'none';
            editorContainer.style.display = 'block';
            editBtn.style.display = 'none';
            saveBtn.style.display = 'inline-block';
        });

        saveBtn.addEventListener('click', function() {
            const editorData = editor.getData();
            
            // Here you would typically send the data to the server via AJAX
            // For demonstration, we'll just update the display
            displayDiv.innerHTML = editorData;
            
            displayDiv.style.display = 'block';
            editorContainer.style.display = 'none';
            saveBtn.style.display = 'none';
            editBtn.style.display = 'inline-block';
            
            // Show success message
            alert('Description updated successfully!');
        });

        // Print button functionality
        document.querySelector('.btn-print').addEventListener('click', function() {
            window.print();
        });
    </script>
</body>
</html>