<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Reporting</a></li>
                                        <li class="breadcrumb-item active">Accounts</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Accounts Records</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h4 class="header-title">Account Details</h4>
                                    <div class="btn-group">
                                        <button id="printBtn" class="btn btn-primary btn-sm">
                                            <i class="fas fa-print mr-1"></i> Print
                                        </button>
                                        <button class="btn btn-success btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fas fa-file-export mr-1"></i> Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item export-btn" href="#" data-type="csv">CSV</a>
                                            <a class="dropdown-item export-btn" href="#" data-type="excel">Excel</a>
                                            <a class="dropdown-item export-btn" href="#" data-type="pdf">PDF</a>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group mr-2">
                                                <input id="demo-foo-search" type="text" placeholder="Search accounts..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="accountsTable" class="table table-bordered table-striped table-hover mb-0" data-page-size="7">
                                        <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th data-toggle="true">Account Name</th>
                                            <th data-hide="phone">Account Number</th>
                                            <th data-hide="phone">Account Amount</th>
                                            <th data-hide="phone">Account Type</th>
                                            <th data-hide="phone">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                            $ret="SELECT * FROM his_accounts ORDER BY RAND()"; 
                                            $stmt= $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res=$stmt->get_result();
                                            $cnt=1;
                                            while($row=$res->fetch_object()):
                                        ?>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td><?php echo htmlspecialchars($row->acc_name);?></td>
                                                <td><?php echo htmlspecialchars($row->acc_number);?></td>
                                                <td>$ <?php echo number_format($row->acc_amount, 2);?></td>
                                                <td><?php echo htmlspecialchars($row->acc_type);?></td>
                                                <td>
                                                    <a href="view_single_account.php?acc_number=<?php echo $row->acc_number;?>" class="btn btn-xs btn-primary">
                                                        <i class="fas fa-eye mr-1"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php 
                                            $cnt++;
                                            endwhile;
                                        ?>
                                        </tbody>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="6">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- TableExport library -->
    <script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>

    <!-- Print and Export functionality -->
    <script>
        $(document).ready(function() {
            // Initialize footable
            $('#accountsTable').footable();
            
            // Print functionality
            $('#printBtn').click(function() {
                var printWindow = window.open('', '', 'height=600,width=800');
                printWindow.document.write('<html><head><title>Accounts Records</title>');
                printWindow.document.write('<link rel="stylesheet" href="assets/css/vendor/bootstrap.min.css">');
                printWindow.document.write('<style>');
                printWindow.document.write('body { font-family: Arial; margin: 20px; }');
                printWindow.document.write('h2 { color: #333; text-align: center; }');
                printWindow.document.write('table { width: 100%; border-collapse: collapse; margin-top: 20px; }');
                printWindow.document.write('th { background-color: #f8f9fa; text-align: left; padding: 8px; border: 1px solid #ddd; }');
                printWindow.document.write('td { padding: 8px; border: 1px solid #ddd; }');
                printWindow.document.write('.text-right { text-align: right; }');
                printWindow.document.write('.text-center { text-align: center; }');
                printWindow.document.write('</style>');
                printWindow.document.write('</head><body>');
                printWindow.document.write('<h2>Accounts Records</h2>');
                printWindow.document.write('<p>Generated on: ' + new Date().toLocaleString() + '</p>');
                printWindow.document.write(document.getElementById('accountsTable').outerHTML);
                printWindow.document.write('</body></html>');
                printWindow.document.close();
                setTimeout(function() {
                    printWindow.print();
                    printWindow.close();
                }, 500);
            });
            
            // Export functionality
            $('.export-btn').click(function(e) {
                e.preventDefault();
                var type = $(this).data('type');
                var table = $('#accountsTable');
                
                switch(type) {
                    case 'csv':
                        table.tableExport({
                            type: 'csv',
                            escape: false,
                            ignoreColumn: [5] // ignore action column
                        });
                        break;
                    case 'excel':
                        table.tableExport({
                            type: 'excel',
                            escape: false,
                            ignoreColumn: [5] // ignore action column
                        });
                        break;
                    case 'pdf':
                        table.tableExport({
                            type: 'pdf',
                            pdfmake: { enabled: true },
                            escape: false,
                            ignoreColumn: [5], // ignore action column
                            title: 'Accounts Records',
                            message: 'Generated on: ' + new Date().toLocaleString()
                        });
                        break;
                }
            });
        });
    </script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>