<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

// Initialize variables
$acc_name = $acc_desc = $acc_amount = '';
$errors = [];

if(isset($_POST['add_acc'])) {
    // Sanitize inputs
    $acc_name = trim($_POST['acc_name']);
    $acc_desc = trim($_POST['acc_desc']);
    $acc_type = 'Payable Account'; // Fixed value as per your original code
    $acc_number = substr(str_shuffle('0123456789'), 1, 15); // Generate random number
    $acc_amount = trim($_POST['acc_amount']);

    // Validate inputs
    if(empty($acc_name)) {
        $errors['acc_name'] = 'Account name is required';
    }

    if(empty($acc_desc)) {
        $errors['acc_desc'] = 'Account description is required';
    }

    if(empty($acc_amount)) {
        $errors['acc_amount'] = 'Amount is required';
    } elseif(!is_numeric($acc_amount)) {
        $errors['acc_amount'] = 'Amount must be a valid number';
    }

    // If no errors, proceed with database insertion
    if(empty($errors)) {
        $query = "INSERT INTO his_accounts (acc_name, acc_desc, acc_type, acc_number, acc_amount) VALUES (?, ?, ?, ?, ?)";
        $stmt = $mysqli->prepare($query);
        $stmt->bind_param('sssss', $acc_name, $acc_desc, $acc_type, $acc_number, $acc_amount);
        
        if($stmt->execute()) {
            $_SESSION['success'] = "Account Payable Details Added Successfully";
            header("Location: {$_SERVER['PHP_SELF']}");
            exit();
        } else {
            $errors['database'] = "Error adding account: " . $stmt->error;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- Editor Version 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/quill@2.0.0/dist/quill.snow.css" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }
        
        body {
            background-color: var(--light);
            font-family: 'Inter', sans-serif;
        }
        
        .card {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
        }
        
        .card-body {
            padding: 2rem;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark);
            font-weight: 700;
        }
        
        .form-label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
        }
        
        .form-control {
            border-radius: 8px;
            border: 1px solid var(--border);
            padding: 10px 15px;
            height: calc(2.25rem + 8px);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }
        
        .btn-success {
            background-color: var(--success);
            border-color: var(--success);
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .btn-success:hover {
            background-color: #008a56;
            border-color: #008a56;
        }
        
        .alert {
            border-radius: 8px;
        }
        
        /* Quill Editor styling */
        #editor-container {
            height: 200px;
            margin-bottom: 20px;
        }
        
        .ql-toolbar {
            border-radius: 8px 8px 0 0 !important;
            background: var(--primary-light) !important;
            border-color: var(--border) !important;
        }
        
        .ql-container {
            border-radius: 0 0 8px 8px !important;
            border-color: var(--border) !important;
            font-family: 'Inter', sans-serif;
        }
        
        /* Amount input styling */
        .input-group-text {
            background-color: var(--primary-light);
            color: var(--primary);
            font-weight: 600;
        }
        
        .is-invalid {
            border-color: var(--danger) !important;
        }
        
        .invalid-feedback {
            color: var(--danger);
            font-size: 0.875rem;
        }
        
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Accounting</a></li>
                                        <li class="breadcrumb-item active">Add Payable Account</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Payable Account Details</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Display alerts -->
                    <?php if(isset($_SESSION['success'])) { ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle mr-2"></i> <?php echo $_SESSION['success']; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php unset($_SESSION['success']); ?>
                    <?php } ?>
                    
                    <?php if(!empty($errors)) { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle mr-2"></i> Please correct the following errors:
                            <ul class="mb-0">
                                <?php foreach($errors as $error): ?>
                                    <li><?php echo $error; ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php } ?>

                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title mb-4">Fill all fields</h4>
                                    
                                    <form method="post" id="accountForm">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="acc_name" class="form-label">Account Name</label>
                                                <input type="text" required name="acc_name" class="form-control <?php echo isset($errors['acc_name']) ? 'is-invalid' : ''; ?>" 
                                                    id="acc_name" value="<?php echo htmlspecialchars($acc_name); ?>">
                                                <?php if(isset($errors['acc_name'])): ?>
                                                    <div class="invalid-feedback"><?php echo $errors['acc_name']; ?></div>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <div class="form-group col-md-6">
                                                <label for="acc_amount" class="form-label">Account Amount</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text">$</span>
                                                    </div>
                                                    <input type="text" required name="acc_amount" 
                                                        class="form-control <?php echo isset($errors['acc_amount']) ? 'is-invalid' : ''; ?>" 
                                                        id="acc_amount" value="<?php echo htmlspecialchars($acc_amount); ?>"
                                                        pattern="[0-9]+(\.[0-9]{1,2})?" title="Enter a valid amount (e.g. 100 or 100.50)">
                                                </div>
                                                <small class="form-text text-muted">Enter amount without currency symbol</small>
                                                <?php if(isset($errors['acc_amount'])): ?>
                                                    <div class="invalid-feedback"><?php echo $errors['acc_amount']; ?></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="form-group" style="display:none">
                                            <input type="text" name="acc_number" value="<?php echo $acc_number; ?>" class="form-control">
                                        </div>

                                        <div class="form-group">
                                            <label for="editor-container" class="form-label">Account Description</label>
                                            <div id="editor-container"><?php echo htmlspecialchars($acc_desc); ?></div>
                                            <textarea name="acc_desc" id="acc_desc" style="display:none"></textarea>
                                            <?php if(isset($errors['acc_desc'])): ?>
                                                <div class="invalid-feedback d-block"><?php echo $errors['acc_desc']; ?></div>
                                            <?php endif; ?>
                                        </div>

                                        <div class="form-group" style="display:none">
                                            <input required value="Payable Account" type="text" class="form-control" name="acc_type">
                                        </div>

                                        <button type="submit" name="add_acc" class="ladda-button btn btn-success" data-style="expand-right">
                                            <i class="fas fa-save mr-2"></i> Add Account
                                        </button>
                                        
                                        <a href="manage_accounts.php" class="btn btn-secondary ml-2">
                                            <i class="fas fa-arrow-left mr-2"></i> Back to Accounts
                                        </a>
                                    </form>
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Quill Editor JS -->
    <script src="https://cdn.jsdelivr.net/npm/quill@2.0.0/dist/quill.js"></script>
    <script>
        // Initialize Quill editor
        const quill = new Quill('#editor-container', {
            theme: 'snow',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    ['link', 'image'],
                    ['clean']
                ]
            },
            placeholder: 'Enter account description...'
        });

        // Update hidden textarea before form submission
        document.getElementById('accountForm').addEventListener('submit', function() {
            const editorContent = document.querySelector('.ql-editor').innerHTML;
            document.getElementById('acc_desc').value = editorContent;
        });

        // Set initial content if there's any
        <?php if(!empty($acc_desc)): ?>
            quill.root.innerHTML = `<?php echo $acc_desc; ?>`;
        <?php endif; ?>
    </script>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
    <!-- Form validation -->
    <script>
        document.getElementById('accountForm').addEventListener('submit', function(e) {
            const amountField = document.getElementById('acc_amount');
            const amountValue = amountField.value.trim();
            
            if(amountValue && !/^[0-9]+(\.[0-9]{1,2})?$/.test(amountValue)) {
                e.preventDefault();
                alert('Please enter a valid amount (e.g. 100 or 100.50)');
                amountField.focus();
            }
        });
    </script>
</body>
</html>