<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_acc']))
{
    $acc_name = $_POST['acc_name'];
    $acc_desc = $_POST['acc_desc'];
    $acc_type = $_POST['acc_type'];
    $acc_number = $_POST['acc_number'];
    $acc_amount = $_POST['acc_amount'];

    //sql to insert captured values
    $query = "INSERT INTO his_accounts (acc_name, acc_desc, acc_type, acc_number, acc_amount) values(?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sssss', $acc_name, $acc_desc, $acc_type, $acc_number, $acc_amount);
    $stmt->execute();
    
    if($stmt)
    {
        $success = "Account Receivable Details Added";
    }
    else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4e73df;
            --primary-light: #e3ebf7;
            --secondary: #1cc88a;
            --danger: #e74a3b;
            --warning: #f6c23e;
            --info: #36b9cc;
            --dark: #5a5c69;
            --light: #f8f9fc;
            --border: #dddfeb;
        }

        body {
            background-color: #f8f9fc;
            font-family: 'Nunito', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            color: var(--dark);
        }

        #wrapper {
            background-color: #fff;
        }

        .card {
            border: none;
            border-radius: 0.35rem;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }

        .card-body {
            padding: 2rem;
        }

        .page-title-box {
            padding: 1.5rem 0;
        }

        .page-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 0;
        }

        .form-control {
            border: 1px solid var(--border);
            border-radius: 0.35rem;
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 0.5rem;
        }

        .btn-success {
            background-color: var(--secondary);
            border-color: var(--secondary);
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s;
        }

        .btn-success:hover {
            background-color: #17a673;
            border-color: #17a673;
            transform: translateY(-1px);
        }

        .header-title {
            color: var(--primary);
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--primary-light);
            padding-bottom: 0.75rem;
        }

        /* CKEditor 5 custom styling */
        .ck.ck-editor {
            max-width: 100%;
            margin-bottom: 1rem;
        }
        .ck.ck-editor__main>.ck-editor__editable {
            min-height: 200px;
            border: 1px solid var(--border) !important;
            border-radius: 0.35rem !important;
        }
        .ck.ck-editor__main>.ck-editor__editable:focus {
            border-color: var(--primary) !important;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25) !important;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            .form-row {
                flex-direction: column;
            }
            .form-group {
                margin-bottom: 1rem;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="his_admin_dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Accounting</a></li>
                                        <li class="breadcrumb-item active">Add Receivable Account</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Receivable Account Details</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Fill all fields</h4>
                                    
                                    <?php if(isset($success)) { ?>
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <strong>Success!</strong> <?php echo $success; ?>
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php if(isset($err)) { ?>
                                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        <strong>Error!</strong> <?php echo $err; ?>
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <?php } ?>
                                    
                                    <!--Add Patient Form-->
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="acc_name" class="col-form-label">Account Name</label>
                                                <input type="text" required name="acc_name" class="form-control" id="acc_name">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="acc_amount" class="col-form-label">Account Amount ($)</label>
                                                <input type="text" required name="acc_amount" class="form-control" id="acc_amount">
                                            </div>
                                        </div>

                                        <div class="form-group col-md-2" style="display:none">
                                            <?php 
                                                $length = 15;    
                                                $account_number = substr(str_shuffle('0123456789'),1,$length);
                                            ?>
                                            <label for="acc_number" class="col-form-label">Account Number</label>
                                            <input type="text" name="acc_number" value="<?php echo $account_number;?>" class="form-control" id="acc_number">
                                        </div>

                                        <div class="form-group">
                                            <label for="editor" class="col-form-label">Account Description</label>
                                            <textarea required name="acc_desc" class="form-control" id="editor"></textarea>
                                        </div>

                                        <div class="form-group" style="display:none">
                                            <label for="acc_type" class="col-form-label">Account Type</label>
                                            <input required value="Receivable Account" type="text" class="form-control" name="acc_type" id="acc_type">
                                        </div>

                                        <button type="submit" name="add_acc" class="ladda-button btn btn-success" data-style="expand-right">
                                            <span class="ladda-label">Add Account</span>
                                        </button>

                                    </form>
                                    <!--End Patient Form-->
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- CKEditor 5 -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'undo', 'redo'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                    ]
                }
            })
            .catch(error => {
                console.error(error);
            });
    </script>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>
</html>