<!--Server side code to handle Patient Registration-->
<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_patient_lab_result'])) {
    $lab_pat_name = $_POST['lab_pat_name'];
    $lab_pat_ailment = $_POST['lab_pat_ailment'];
    $lab_pat_number  = $_POST['lab_pat_number'];
    $lab_pat_tests = $_POST['lab_pat_tests'];
    $lab_number  = $_GET['lab_number'];
    $lab_pat_results = $_POST['lab_pat_results'];
    
    $query = "UPDATE his_laboratory SET lab_pat_name=?, lab_pat_ailment=?, lab_pat_number=?, lab_pat_tests=?, lab_pat_results=? WHERE lab_number=?";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('ssssss', $lab_pat_name, $lab_pat_ailment, $lab_pat_number, $lab_pat_tests, $lab_pat_results, $lab_number);
    $stmt->execute();
    
    if($stmt) {
        $success = "Patient Laboratory Results Added";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!--End Server Side-->

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- Add CKEditor 5 CDN -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <style>
        /* Custom CSS */
        .card {
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        .card-body {
            padding: 2rem;
        }
        .form-control {
            border-radius: 5px;
            padding: 10px 15px;
        }
        .btn-success {
            background-color: #28a745;
            border-color: #28a745;
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 5px;
            transition: all 0.3s;
        }
        .btn-success:hover {
            background-color: #218838;
            border-color: #1e7e34;
            transform: translateY(-2px);
        }
        .header-title {
            color: #2c3e50;
            margin-bottom: 1.5rem;
            font-weight: 700;
        }
        .ck-editor__editable {
            min-height: 200px;
            border-radius: 5px !important;
        }
        hr {
            margin: 2rem 0;
            border-top: 1px solid #eee;
        }
        .form-group label {
            font-weight: 600;
            margin-bottom: 8px;
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $lab_number = $_GET['lab_number'];
            $ret = "SELECT * FROM his_laboratory WHERE lab_number=?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('s', $lab_number);
            $stmt->execute();
            $res = $stmt->get_result();
            while($row = $res->fetch_object()) {
        ?>
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                            <li class="breadcrumb-item active">Add Lab Result</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Add Lab Result</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        
                        <!-- Form row -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Fill all fields</h4>
                                        
                                        <!-- Success/Error Messages -->
                                        <?php if(isset($success)) { ?>
                                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                                <?php echo $success; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                        <?php } ?>
                                        <?php if(isset($err)) { ?>
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                <?php echo $err; ?>
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                        <?php } ?>
                                        
                                        <!--Add Patient Form-->
                                        <form method="post">
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="lab_pat_name" class="col-form-label">Patient Name</label>
                                                    <input type="text" required readonly name="lab_pat_name" value="<?php echo $row->lab_pat_name;?>" class="form-control" id="lab_pat_name">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="lab_pat_ailment" class="col-form-label">Patient Ailment</label>
                                                    <input required type="text" readonly name="lab_pat_ailment" value="<?php echo $row->lab_pat_ailment;?>" class="form-control" id="lab_pat_ailment">
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="lab_pat_number" class="col-form-label">Patient Number</label>
                                                    <input type="text" required readonly name="lab_pat_number" value="<?php echo $row->lab_pat_number;?>" class="form-control" id="lab_pat_number">
                                                </div>
                                            </div>

                                            <hr>
                                            
                                            <div class="form-group">
                                                <label for="editor" class="col-form-label">Laboratory Tests</label>
                                                <textarea required type="text" class="form-control" name="lab_pat_tests" id="editor"><?php echo $row->lab_pat_tests;?></textarea>
                                            </div>

                                            <div class="form-group">
                                                <label for="editor1" class="col-form-label">Laboratory Result</label>
                                                <textarea required type="text" class="form-control" name="lab_pat_results" id="editor1"></textarea>
                                            </div>

                                            <button type="submit" name="add_patient_lab_result" class="ladda-button btn btn-success" data-style="expand-right">
                                                <span class="ladda-label">Add Laboratory Result</span>
                                            </button>
                                        </form>
                                        <!--End Patient Form-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->
                    </div> <!-- container -->
                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->
            </div>
        <?php } ?>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
    <!-- Initialize CKEditor 5 -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            ClassicEditor
                .create(document.querySelector('#editor'), {
                    toolbar: ['heading', '|', 'bold', 'italic', 'bulletedList', 'numberedList', 'blockQuote']
                })
                .catch(error => {
                    console.error(error);
                });
                
            ClassicEditor
                .create(document.querySelector('#editor1'), {
                    toolbar: ['heading', '|', 'bold', 'italic', 'bulletedList', 'numberedList', 'blockQuote']
                })
                .catch(error => {
                    console.error(error);
                });
        });
    </script>
</body>
</html>