<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['doc_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head Code-->
    <?php include("assets/inc/head.php");?>

    <body class="dashboard-background" style="background-color: #f5f7fa;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include('assets/inc/sidebar.php');?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="
                                    border-radius: 12px; 
                                    padding: 20px; 
                                    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
                                    box-shadow: 0 4px 24px rgba(0,0,0,0.05);
                                    border: 1px solid rgba(255,255,255,0.2);
                                    backdrop-filter: blur(5px);
                                ">
                                    <h4 class="page-title font-weight-bold" style="color: #2c3e50; font-size: 1.5rem;">
                                        <i class="fas fa-clinic-medical mr-2" style="color: #6c5ce7;"></i> 
                                        Hospital Dashboard
                                    </h4>
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: #6c5ce7;">Hospital</a></li>
                                            <li class="breadcrumb-item active" style="color: #636e72;">Dashboard</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        

                        <div class="row mt-4">

                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(108, 92, 231, 0.1);
                                                box-shadow: 0 4px 12px rgba(108, 92, 231, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-wheelchair font-24" style="color: #6c5ce7;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_patients ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($outpatient);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $outpatient;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 6px; color: #6c5ce7; vertical-align: middle;"></i> All Patients
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 75%; 
                                            background: linear-gradient(90deg, #6c5ce7 0%, #a29bfe 100%);
                                            animation: progressAnimation 2s ease-in-out;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--Start OutPatients-->
                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(108, 92, 231, 0.1);
                                                box-shadow: 0 4px 12px rgba(108, 92, 231, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-wheelchair font-24" style="color: #6c5ce7;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_patients WHERE pat_type = 'OutPatient' ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($outpatient);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $outpatient;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 10px; color: #6c5ce7; vertical-align: middle;"></i>OPD
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 75%; 
                                            background: linear-gradient(90deg, #6c5ce7 0%, #a29bfe 100%);
                                            animation: progressAnimation 2s ease-in-out;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--End Out Patients-->

                            <!--Start InPatients-->
                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out 0.1s;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(0, 184, 148, 0.1);
                                                box-shadow: 0 4px 12px rgba(0, 184, 148, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-bed font-24" style="color: #00b894;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_patients WHERE pat_type = 'InPatient' ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($inpatient);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $inpatient;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 10px; color: #00b894; vertical-align: middle;"></i> IPD
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 65%; 
                                            background: linear-gradient(90deg, #00b894 0%, #55efc4 100%);
                                            animation: progressAnimation 2s ease-in-out 0.1s;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--End InPatients-->

                            <!--Start Employees-->
                            
                            <!--End Employees-->
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out 0.2s;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(253, 114, 114, 0.1);
                                                box-shadow: 0 4px 12px rgba(253, 114, 114, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-user-nurse font-24" style="color: #fd7676;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_docs ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($doc);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $doc;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 6px; color: #fd7676; vertical-align: middle;"></i> Employee
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 85%; 
                                            background: linear-gradient(90deg, #fd7676 0%, #fab1a0 100%);
                                            animation: progressAnimation 2s ease-in-out 0.2s;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--Start Vendors-->
                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out 0.3s;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(255, 159, 67, 0.1);
                                                box-shadow: 0 4px 12px rgba(255, 159, 67, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-parachute-box font-24" style="color: #ff9f43;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_vendor ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($vendor);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $vendor;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 6px; color: #ff9f43; vertical-align: middle;"></i> Vendors
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 55%; 
                                            background: linear-gradient(90deg, #ff9f43 0%, #fdcb6e 100%);
                                            animation: progressAnimation 2s ease-in-out 0.3s;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--End Vendors-->  

                            <!--Start Corporation Assets-->
                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out 0.4s;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(45, 152, 218, 0.1);
                                                box-shadow: 0 4px 12px rgba(45, 152, 218, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-cogs font-24" style="color: #2d98da;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_equipments ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($assets);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $assets;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 6px; color: #2d98da; vertical-align: middle;"></i> Hospital Assets
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 45%; 
                                            background: linear-gradient(90deg, #2d98da 0%, #45aaf2 100%);
                                            animation: progressAnimation 2s ease-in-out 0.4s;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--End Corporation Assets-->

                            <!--Start Pharmaceuticals-->
                            <div class="col-md-6 col-xl-4">
                                <div class="widget-rounded-circle card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    overflow: hidden; 
                                    transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
                                    background: white;
                                    border: none;
                                    animation: fadeIn 0.6s ease-out 0.5s;
                                ">
                                    <div class="row align-items-center p-3">
                                        <div class="col-5">
                                            <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                                                background: rgba(120, 111, 166, 0.1);
                                                box-shadow: 0 4px 12px rgba(120, 111, 166, 0.15);
                                                transition: transform 0.3s ease;
                                            ">
                                                <i class="fas fa-prescription-bottle-alt font-24" style="color: #786fa6;"></i>
                                            </div>
                                        </div>
                                        <div class="col-7">
                                            <div class="text-right">
                                                <?php
                                                    $result ="SELECT count(*) FROM his_pharmaceuticals ";
                                                    $stmt = $mysqli->prepare($result);
                                                    $stmt->execute();
                                                    $stmt->bind_result($phar);
                                                    $stmt->fetch();
                                                    $stmt->close();
                                                ?>
                                                <h3 class="mt-1 mb-0" style="color: #2d3436;"><span data-plugin="counterup"><?php echo $phar;?></span></h3>
                                                <p class="mb-1 text-truncate" style="color: #636e72; font-weight: 500;">
                                                    <i class="fas fa-circle mr-1" style="font-size: 6px; color: #786fa6; vertical-align: middle;"></i> Pharmaceuticals
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="progress" style="height: 6px; background-color: #f1f1f1;">
                                        <div class="progress-bar" role="progressbar" style="
                                            width: 60%; 
                                            background: linear-gradient(90deg, #786fa6 0%, #a5b1c2 100%);
                                            animation: progressAnimation 2s ease-in-out 0.5s;
                                        "></div>
                                    </div>
                                </div>
                            </div>
                            <!--End Pharmaceuticals-->
                        </div>
                        
                        <!--Recently Employed Employees-->
                       
                        <!-- end row -->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Plugins js-->
        <script src="assets/libs/flatpickr/flatpickr.min.js"></script>
        <script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>
        <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.time.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.tooltip.min.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.selection.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.crosshair.js"></script>

        <!-- Dashboard init js-->
        <script src="assets/js/pages/dashboard-1.init.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Animations */
            @keyframes fadeIn {
                from { opacity: 0; transform: translateY(10px); }
                to { opacity: 1; transform: translateY(0); }
            }
            
            @keyframes slideUp {
                from { opacity: 0; transform: translateY(20px); }
                to { opacity: 1; transform: translateY(0); }
            }
            
            @keyframes fadeInRow {
                from { opacity: 0; }
                to { opacity: 1; }
            }
            
            @keyframes progressAnimation {
                from { width: 0; }
                to { width: attr(data-width); }
            }
            
            /* Hover effects */
            .widget-rounded-circle:hover {
                transform: translateY(-5px) !important;
                box-shadow: 0 15px 30px rgba(0,0,0,0.1) !important;
            }
            
            .widget-rounded-circle:hover .avatar-lg {
                transform: scale(1.1);
            }
            
            tr:hover {
                background-color: #f8f9fa !important;
                transform: translateX(5px);
                box-shadow: 0 5px 15px rgba(0,0,0,0.03);
            }
            
            tr:hover td h5 {
                color: #6c5ce7 !important;
            }
            
            tr:hover td a {
                color: #6c5ce7 !important;
            }
            
            .btn-view-all:hover, .btn-view:hover {
                transform: translateY(-2px) !important;
                box-shadow: 0 8px 20px rgba(108, 92, 231, 0.3) !important;
            }
            
            .department-badge:hover {
                background-color: #e2e8f0 !important;
                color: #6c5ce7 !important;
            }
            
            .status-badge:hover {
                background-color: rgba(0, 184, 148, 0.2) !important;
                color: #00b894 !important;
            }
            
            .avatar-container:hover img {
                transform: scale(1.1);
                border-color: #6c5ce7 !important;
            }
            
            .card-header i:hover {
                background: rgba(108, 92, 231, 0.2) !important;
                transform: rotate(15deg);
            }
            
            .card-footer a:hover {
                color: #6c5ce7 !important;
                transform: translateX(5px);
            }
            
            /* Responsive adjustments */
            @media (max-width: 768px) {
                .avatar-container {
                    margin-right: 0.5rem !important;
                }
                
                td, th {
                    padding: 0.75rem !important;
                }
                
                .btn-view, .btn-view-all {
                    padding: 0.25rem 0.5rem !important;
                    font-size: 0.75rem !important;
                }
                
                .widget-rounded-circle {
                    margin-bottom: 1rem;
                }
            }
            
            /* Custom scrollbar */
            ::-webkit-scrollbar {
                width: 8px;
                height: 8px;
            }
            
            ::-webkit-scrollbar-track {
                background: #f1f1f1;
                border-radius: 10px;
            }
            
            ::-webkit-scrollbar-thumb {
                background: #a29bfe;
                border-radius: 10px;
            }
            
            ::-webkit-scrollbar-thumb:hover {
                background: #6c5ce7;
            }
        </style>
    </body>
</html>